pro draw_hydra_skew, panelVector, currPlotInfo, orbitNo, $
                                  get_data_call, slice_type, IsRead, $
                                  OUTPUT=OUTPUT

   common extra, extra_PlotInfo
   common papco_color
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_header, $
     data_all, $
     data_up, $
     data_perp, $
     data_dn

   tres= currPlotInfo.typevector(1)
   species= currPlotInfo.typevector(0)

   options= currPlotInfo.typevector(3) and 1L
      
   data_context= hyd_dc( tres, 1 ) ; use aligned header.

   get_data_call="r_hydra_spec"

   PAPCO_occupy_subtable, 1     ; bipolar
   PAPCO_set_subtable, 1
   hydra_colors, r, g, b, /bipolar
   PAPCO_Load_SubTable, 1, r, g, b
   colors= PAPCO_get_ColorIndices( 1 )
   tvlct, r,g,b, /get
   middle= (colors(0)+colors(1))/2
;  congrid interpolates over the cusp in the bipolar colorbar.  fix this.
   r(middle)=r(middle+1) & g(middle)=g(middle+1) & b(middle)=b(middle+1)
   tvlct, r,g,b

   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       slice_type= 1+16
   endif else begin
       slice_type= 1
   endelse

; decide whether we need to reload or not.  This is a little more
; sophisticated than most PaPCo modules, but since hydra loading
; is expensive, it's worth the potentially confusing code.
   if n_elements( spec_header ) eq 0 then begin
       YesLoad=1
   endif else begin
       YesLoad= $
         spec_header(data_context).start_time gt xut1    or  $
         spec_header(data_context).end_time lt xut2      or  $
         spec_header(data_context).reload_flag or $ ; set with panel
         spec_header(data_context).options ne options
   endelse

   IF YesLoad THEN BEGIN
       r_hydra_spec_new, data_context, panel=panelVector, options=options, $
         /papco
       if ( get_err_no ne 0 ) then spec_header(data_context).reload_flag=1

       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           IsRead=1
           spec_header(data_context).reload_flag=0
           p_hydra_skew, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo, res= data_context ge 4, OUTPUT=OUTPUT
       ENDIF
   ENDIF ELSE BEGIN
       PAPCO_set_subtable, 1
       p_hydra_skew, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo, res= data_context ge 4, OUTPUT=OUTPUT
   ENDELSE

END

