;***************************************************************************
;*
;* PROCEDURE:
;*      PRO draw_polar_hydra, panelVector, currPlotInfo, orbitNo $
;*                          get_data_call, slice_type, IsRead
;* DESCRIPTION:
;*	This procedure performs the actual data read call and the plot call
;*      for this plottype.
;*
;*
;* INPUTS:
;*	panelVector	position of the plot (see papco_conventions.text, 6)
;*	currPlotInfo	structure containing all data for this plot.
;*                      (structure type: PAPCO_PLOTINFO,
;*                                             see papco_variables.text)
;*
;* OUTPUTS:
;*   	get_data_call	a string containing the data call. Used by other
;*                      routines that need to know how to get the data
;*                      in a panel, e.g. to draw spectra, distribution functions
;*      IsRead		a boolean which is set when the the data is read the
;*                      first time. Useful if a given data read puts data
;*                      into commons which can be plotted in many ways.
;*                      When set, data does not have to be read again.
;*      slice_type      Selects which slices are supported and for which
;*                      slice routines have been written.
;*                      This is a byte logical with 8 switches. Currently
;*                      Three are supported (this may be extended later)
;*                       1 = mouse zooms (default, always possible)
;*                       2 = mouse slices
;*                       4 = mouse calls level zero
;*                       8, 16, 32, 64, 128 = not supported yet
;*                      you can support more than one type of slice
;*                      by arythmetically adding the options, eg
;*                      slice_type=5  support zoom and level zero
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	draw_polar_hydra, panelVector, currPlotInfo, orbitNo, $
;*                                 get_data_call, slice_type, IsRead
;* MODIFICATION HISTORY:
;*     written November 1995, Reiner Friedel
;*
;***************************************************************************
pro draw_hydra_spec, panelVector, currPlotInfo, orbitNo, $
                                  get_data_call, slice_type, IsRead, $
                                  OUTPUT=OUTPUT

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_header, $
     spec_data, $
     spec_aligned_data, $
     spec_perp_data, $
     spec_opposed_data, $
     hr_spec_data, $
     hr_spec_aligned_data, $
     hr_spec_perp_data, $
     hr_spec_opposed_data

   type= currPlotInfo.typevector(2)
   tres= currPlotInfo.typevector(1)
   species= currPlotInfo.typevector(0)
   file= currPlotInfo.filename
   options= currPlotInfo.typevector(3) and 1L

   if currPlotInfo.soptions(0) eq '' then begin
       include_detectors= intarr(12)
   endif else begin
       include_detectors= byte( currPlotInfo.soptions(0) ) - 48
   endelse
   
   print, 'include_detectors='
   print, 'from box1:'+strtrim(fix(total( include_detectors(indgen(6)*2 ) )),2)+ $
     ' from box2:'+ strtrim(fix(total( include_detectors(indgen(6)*2+1 ) )),2)

   if hydra_new_papco(vers=vers) and vers ge 9.0 then begin
       if currPlotInfo.options(0) gt 0. then begin
           bsec= currPlotInfo.options(0) ; sorry about the confusion.  
                                ; tres is a bool, indicating whether
                                ; or not level1 should be used.  bsec
                                ;  is a float that is the resolution to load in.
       endif else begin
           bsec= 1.15
       endelse       
   endif else begin
       bsec= 1.15               ; for level1 reads only
   endelse

   data_context= hyd_dc( tres, type )
   
   if data_context lt 5 then bsec=13.8

; decide whether we need to reload or not.  This is a little more
; sophisticated than most PaPCo modules, but since hydra loading
; is expensive, it's worth the potentially confusing code.

   if n_elements( spec_header ) eq 0 then begin
       YesLoad=1 
   endif else begin
       YesLoad= $
         spec_header(data_context).start_time gt xut1    or  $
         spec_header(data_context).end_time lt xut2      or  $
         spec_header(data_context).reload_flag or $ ; set with panel
         spec_header(data_context).options ne options or $
         spec_header(data_context).time_resolution ne bsec or $
         total( abs( spec_header(data_context).include_detectors - $
                     include_detectors ) ) ne 0 
       if file ne '' and spec_header(data_context).file1 ne file then $
         YesLoad=1
   endelse
   
   get_data_call=""

   if hydra_new_papco() then begin
       n=(papco_slice_value('USER Hydra fV Slice')>0)
       n2=(papco_slice_value('USER Hydra fitf')>0)
       n3=(papco_slice_value('USER Time Range')>0)
       n4=(papco_slice_value('USER hydra ppaf')>0)
       n5=(papco_slice_value('USER hydra faverage')>0)
       n6=(papco_slice_value('USER Distribution')>0)
       n7=(papco_slice_value('USER walen')>0)
       slice_type= 1+2+16+n+n2+n3+n4+n5+n6+n7
   endif else begin
       slice_type= 1+2+8
   endelse

   IF YesLoad THEN BEGIN
       r_hydra_spec_new, data_context, panel=panelVector, options=options, $
         /papco, tres=bsec, file=file, $
         include_detectors= include_detectors
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           IsRead=1
           spec_header(data_context).reload_flag=0
           PAPCO_set_subtable, currPlotInfo.channel
           p_hydra_spec, panelVector, currPlotInfo.typeVector, $
             _EXTRA=extra_PlotInfo, res= tres, OUTPUT=OUTPUT
       ENDIF
   ENDIF ELSE BEGIN
       PAPCO_set_subtable, currPlotInfo.channel
       p_hydra_spec, panelVector, currPlotInfo.typeVector, $
         _EXTRA=extra_PlotInfo, res= tres, OUTPUT=OUTPUT
   ENDELSE
END

