pro draw_hydra_temp, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

   common extra, extra_PlotInfo
   common time, xut1, xut2
   common get_error, get_err_no, get_err_msg
   common hydra_temp_data, $
     initialized, $
     loaded, $                  ; bit0=efi
     efi_head, efi_data, $
     efi34_head, efi34_data
   
   get_data_call=""
   
   slice_type= 1+16
   typeVector= currPlotInfo.typevector
   type= typevector(0)

   case 1 of 
       0 le type and type le 12: begin
           loaded_bit=0
           if n_elements( efi_head ) gt 0 then begin
               start_time= efi_head.start_time
               end_time= efi_head.end_time
           endif
       end
       12 lt type and type le 14: begin
           loaded_bit=1
           if n_elements( efi34_head ) gt 0 then begin
               start_time= efi34_head.start_time
               end_time= efi34_head.end_time
           endif
       end
       else: loaded_bit=2
   endcase
   
   IF n_elements(initialized) EQ 0 THEN BEGIN
       initialized=1
       loaded=0L
   endif
   
   if n_elements( start_time ) eq 0 then yesload=1 else begin
       yesload= ( ( loaded and 2^loaded_bit ) / 2^loaded_bit ) eq 0   or $
         ( start_time gt xut1 ) or $ 
         ( end_time lt xut2 )
   endelse
   
; need to get moments J if plot is J_parl * E_parl
   if type ge 11 and type le 12 then begin
       common hydra_current_data, $
         current_header, $
         current_data
       IF n_elements(current_header) EQ 0 THEN YesLoad1 = 1 ELSE BEGIN 
           YesLoad1= $
             (current_header.start_time gt xut1)     OR  $
             (current_header.end_time lt xut2 )      OR  $
             (current_header.reload_flag ) ; set with panel
       ENDELSE     
       if yesload1 then begin
           r_hydra_current
           IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                     panelVector, orbitNr, $
                                     currPlotInfo.typeVector, $
                                     currPlotInfo.channel) $
             THEN current_header.reload_flag=0
       endif
   endif

   IF YesLoad THEN BEGIN
       r_hydra_temp, type
       IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                 panelVector, orbitNr, $
                                 currPlotInfo.typeVector, $
                                 currPlotInfo.channel) $
         THEN BEGIN
           loaded= loaded or 2^loaded_bit
           IsRead=1
       endif
   endif
   
   if (loaded and 2^loaded_bit) eq 2^loaded_bit then begin
       panelset, panelVector    ; sets !p.position
       p_hydra_temp, panelVector, typeVector, _EXTRA=extra_PlotInfo
       
       common coordinateSystems, plotted_x, plotted_y
       plotted_x= !x
       plotted_y= !y   
   ENDIF
   
END
