pro draw_hydra_tpp, panelVector, currPlotInfo, orbitNo, $
                     get_data_call, slice_type, IsRead

common extra, extra_PlotInfo
common time, xut1, xut2
common get_error, get_err_no, get_err_msg
common hydra_tpp_data, tpp_header, tpp_data

if n_elements( tpp_header ) eq 0 then begin
    tpp_header={ $
                 start_time:long(-1), $
                 end_time:long(-1), $
                 data_species:fix(-1), $
                 data_res:fix(-1), $
                 data_var:fix(-1), $
                 data_frame:fix(-1), $
                 data_version:float(-1.00), $
                 reload_flag:fix(1) $
               }
endif

get_data_call="r_hydra_tpp"

if hydra_new_papco() then begin
    n=(papco_slice_value('USER Hydra fV Slice')>0)
    slice_type= 1+16
endif else begin
    slice_type= 1
endelse

YesLoad= $
  tpp_header.start_time gt xut1    or  $
  tpp_header.end_time lt xut2      or  $
  tpp_header.data_species ne currPlotInfo.ioptions(0) or $
  tpp_header.data_res ne currPlotInfo.ioptions(1) or $
  tpp_header.data_var ne currPlotInfo.ioptions(2) or $
  tpp_header.data_frame ne currPlotInfo.ioptions(3) or $
  tpp_header.reload_flag        ; set with panel

IF YesLoad THEN BEGIN
    tpp_header.start_time=xut1
    tpp_header.end_time=xut2
    tpp_header.data_species = currPlotInfo.ioptions(0)
    tpp_header.data_res = currPlotInfo.ioptions(1)
    tpp_header.data_var = currPlotInfo.ioptions(2)
    tpp_header.data_frame = currPlotInfo.ioptions(3)
    tpp_header.reload_flag=1
    r_hydra_tpp
    IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                              panelVector, orbitNr, $
                              currPlotInfo.typeVector, $
                              currPlotInfo.channel) $
      THEN BEGIN
        tpp_header.reload_flag=0
        IsRead=1
        p_hydra_tpp, panelVector, currPlotInfo.typeVector, $
          _EXTRA=extra_PlotInfo
    ENDIF
ENDIF ELSE BEGIN
    p_hydra_tpp, panelVector, currPlotInfo.typeVector, $
      _EXTRA=extra_PlotInfo
ENDELSE

END

