pro draw_hydra_tpphr, panelVector, currPlotInfo, orbitNo, $
                      get_data_call, slice_type, IsRead

common extra, extra_PlotInfo
common time, xut1, xut2
common get_error, get_err_no, get_err_msg

; DE-COMMISIONED 6/15/00
get_err_no = 1
get_err_msg = '% DRAW_HYDRA_TPPHR: The TPPHR PaPCo code!chas been de-commisioned.!cPlease use the "plot TPP moments" option!cfrom the Polar/Hyd pulldown menu'
check = PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                               panelVector, orbitNr, $
                               currPlotInfo.typeVector, $
                               currPlotInfo.channel)
return
   
   common hydra_tpphr_data, $
    tpphr_nsweep_index, tpphr_nsweep, $
    tpphr_header, $
    tpphr_data1, $
    tpphr_data2, $
    tpphr_data3, $
    tpphr_data6
   
   COMMON tpphr_loaded, loaded1, loaded2, loaded3, loaded6
   
   tpphr_nsweep_index = currPlotInfo.typeVector(0)
   CASE tpphr_nsweep_index OF
      0:BEGIN
         tpphr_nsweep = 1
      END 
      1:BEGIN
         tpphr_nsweep = 2
      END
      2:BEGIN
         tpphr_nsweep = 3
      END
      3:BEGIN
         tpphr_nsweep = 6
      END
   ENDCASE
   
   get_data_call="r_hydra_tpphr"
   
   if hydra_new_papco() then begin
      n=(papco_slice_value('USER Hydra fV Slice')>0)
      slice_type= 1+16
   endif else begin
      slice_type= 1
   endelse
   
   IF n_elements( tpphr_header ) EQ 0 THEN YesLoad=1 ELSE BEGIN 
      YesLoad= $
       (NOT keyword_set(loaded1) AND tpphr_nsweep EQ 1)  OR  $
       (NOT keyword_set(loaded2) AND tpphr_nsweep EQ 2)  OR  $
       (NOT keyword_set(loaded3) AND tpphr_nsweep EQ 3)  OR  $
       (NOT keyword_set(loaded6) AND tpphr_nsweep EQ 6)  OR  $
       (tpphr_header(tpphr_nsweep_index).start_time gt xut1)   OR  $
       (tpphr_header(tpphr_nsweep_index).end_time lt xut2 )    OR  $
       (tpphr_header(tpphr_nsweep_index).reload_flag ) ; set with panel
   ENDELSE
   
   IF YesLoad THEN BEGIN
      r_hydra_tpphr
      IF PAPCO_Draw_CheckResult(currPlotInfo.panelKind, $
                                panelVector, orbitNr, $
                                currPlotInfo.typeVector, $
                                currPlotInfo.channel) $
       THEN BEGIN
         tpphr_header(tpphr_nsweep_index).reload_flag=0
         IsRead=1
         p_hydra_tpphr, panelVector, currPlotInfo.typeVector, $
          _EXTRA=extra_PlotInfo
         
; Who have we loaded so far?
         IF tpphr_nsweep EQ 1 THEN loaded1 =  1
         IF tpphr_nsweep EQ 2 THEN loaded2 =  1
         IF tpphr_nsweep EQ 3 THEN loaded3 =  1
         IF tpphr_nsweep EQ 6 THEN loaded6 =  1
         
      ENDIF
   ENDIF ELSE BEGIN
      p_hydra_tpphr, panelVector, currPlotInfo.typeVector, $
       _EXTRA=extra_PlotInfo
   ENDELSE
   
END

