pro hydra_display_info, spec=spec

COMMON hydra_spec_panel_DATA, widgetData

iowa=1                          ; 1=local installation, 0=remote

if keyword_set( spec ) then begin
    common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_header, $
     spec_data, $
     spec_aligned_data, $
     spec_perp_data, $
     spec_opposed_data, $
     hr_spec_data, $
     hr_spec_aligned_data, $
     hr_spec_perp_data, $
     hr_spec_opposed_data

    type= widgetData.typevector(2)
    tres= widgetData.typevector(1)
    species= widgetData.typevector(0)

    if n_elements( spec_header ) eq 0 then begin
        r= widget_message( 'No data loaded.', /info )
        return
    endif
    
    data_context= hyd_dc( tres, type )
    
    header= spec_header( data_context )

    if header.data_version eq 99999. then begin
        message=[ 'Data set loaded.' ]
        r= widget_message( message, /info )
        return
    endif    
        
    message=[ 'Infomation for Loaded Data Set' ]

    convert_t90_to_Date,header.start_time, year, day_oy, hour, min, sec, $
      month, cmonth, day_om    
    info1=string(day_om,cmonth,year,$
                 format="(i2.2,' ',a3,' ',i2.2,' ')")
    info1=info1+string(hour,min,sec,format=$
                       "(i2.2,':',i2.2,':',i2.2)")
    
    convert_t90_to_Date,header.end_time, year, day_oy, hour, min, sec, $
      month, cmonth, day_om    
    info2=string(day_om,cmonth,year,$
                 format="(i2.2,' ',a3,' ',i2.2,' ')")
    info2=info2+string(hour,min,sec,format=$
                       "(i2.2,':',i2.2,':',i2.2)")
    message= [ message, info1+' - '+info2, '' ]    

    message= [ message, $
               string('Data Version: ', format='(a24)')+ $
               string( header.data_version, format='(f9.2)') ]
    
    if iowa then begin
        s= { glint_mask_version:0.0, $
             sc_pot_version:0.0, $
             mfe_gain_version:0.0, $
             background_version:0.0, $
             rgains_version:0.0, $
             intersweep_version:0.0, $
             igains_version:0.0, $
             block_mode:0 } 
        
        s.block_mode = 10
        
        s.glint_mask_version = header.glint_mask_version
        s.rgains_version= header.rgains_version
        s.igains_version= header.igains_version

    endif else begin
        
        message= [ message, $
                   string('Nom. Calibration Vers: ',format='(a24)')+ $
                   string( header.calibration_version, format='(f9.2)') ]

        quality_string=''
        
    endelse
    

;    message= [ message, $
;               string('Intra-Box Gains: ', format='(a24)')+ $
;               string( header.rgains_version, format='(f9.2)') ]

;    message= [ message, $
;               string('Inter-Box Gains: ', format='(a24)')+ $
;               string( header.igains_version, format='(f9.2)') ]

;    message= [ message, $
;               string('Glint Mask: ', format='(a24)')+ $
;               string( header.glint_mask_version, format='(f9.3)') ]
 
    message= [ message, $
               string('Reader: ', format='(a24)')+ $
               string( header.reader_version, format='(f9.2)') ]

;    message= [ message, $
;               string('Occupies Memory Space: ', format='(a24)')+ $
;               string( data_context, format='(i9)') ]

    message= [ message, $
               string('Reload Flag: ', format='(a24)')+ $
               string( header.reload_flag, format='(i9)') ]


    r= widget_message( message, /info )
    
endif

return
end
