pro testit
   b=widget_base()
   r= hydra_file_widget( b, 'yow', data, /create, /save, /load, /edit )
   widget_control, b, /realize
   xmanager, 'hydra_file_widget', b
end

pro hydra_file_widget_check_status, widgetData

   canread=0
   canwrite=0

   hyd_file_status, widgetData.filename, write=canwrite, read=canread

   if widgetData.create_ID ne 0 then $
     widget_control, widgetData.create_ID, sensitive=(canwrite and not canread)
   if widgetData.save_ID ne 0 then $
     widget_control, widgetData.save_ID, sensitive=(canwrite and canread)
   if widgetData.load_ID ne 0 then $
     widget_control, widgetData.load_ID, sensitive=canread
   if widgetData.revert_ID ne 0 then $
     widget_control, widgetData.save_ID, sensitive=canread
   
   return
end


function hydra_file_widget_event, event, widgetData, handled=handled

   WIDGET_CONTROL,GET_UVALUE=uvalue, event.id
   
   handled=1
   case uvalue of
       'hfw_filename': begin
           widget_control, widgetData.file_ID, get_value=file
           widgetData.filename=file(0)
       end
       'hfw_browse': begin
           if papco_hasdir( widgetData.filename ) then begin
               papco_sepdir, widgetData.filename, path, file
               if papco_finddir(path) eq 0 then begin
                   cd, current=pwd               
                   path= pwd
               endif
           endif else begin
               path= getenv( 'PAPCO_HOME' )
               if path eq '' or not papco_finddir(path) then begin
                   cd, current=pwd               
                   path= pwd
               endif
               file= widgetData.filename
           endelse
           if papco_finddir(path) then begin
               cd, path
               cd, current=pwd
               path=pwd
           endif
           file= pickfile( file= widgetData.filename, $
                           filter=widgetData.extention, $
                           path= path )
           
           widgetData.filename=file
           widget_control, widgetData.file_ID, set_value=widgetData.filename
       end
       else: begin
           message, 'Event not handled: '+uvalue, /cont
           handled=0
       end
   endcase
   hydra_file_widget_check_status, widgetData
   return, widgetData
end


function hydra_file_widget, base, widgetData_in, $
                            edit=edit, create=create, load=load, save=save, $
                            buttons=buttons, $
                            revert=revert, ext=ext

   if n_elements( widgetData_in ) eq 0 then begin
       widgetData_in= { $
                        filename:'' $
       }
   endif

   w= widgetData_in
   widgetData= { $
                 filename:w.filename, $
                 status_text:'',$
                 extention:'', $
                 file_ID:0L, $
                 revert_ID:0L, $
                 save_ID:0L, $
                 create_ID:0L, $
                 edit_ID:0L, $
                 load_ID:0L $
               }
   
   if keyword_set( ext ) then widgetData.extention=ext

   file_base= widget_base( base, /column )

   name_base= widget_base( file_base, /row )
   widgetData.file_ID= cw_field( name_base, title='Filename: ', $
                                 value=widgetData.filename, $
                                 uvalue='hfw_filename', xsize=40, /return_ev )
   r= widget_button( name_base, value='Browse', uvalue='hfw_browse' )

   action_base= widget_base( file_base, /row )
   
   if keyword_set( buttons ) then begin
       for i=0,n_elements( buttons ) -1 do begin
           r= widget_button( name_base, value=buttons(i), $
                             uvalue='hfw_'+strlowcase(buttons(i)) )
       endfor
   endif
       
   if keyword_set( create ) then $
     widgetData.create_ID= $
     widget_button( name_base, value='Create', uvalue='hfw_create' )

   if keyword_set( edit ) then $
     widgetData.edit_ID= $
     widget_button( name_base, value='Edit', uvalue='hfw_edit' )

   if keyword_set( load ) then $
     widgetData.load_ID= $
     widget_button( name_base, value='Load', uvalue='hfw_load' )

   if keyword_set( save ) then $
     widgetData.save_ID= $
     widget_button( name_base, value='Save', uvalue='hfw_save' )

   if keyword_set( revert ) then $
     widgetData.revert_ID= $
     widget_button( name_base, value='Revert', uvalue='hfw_revert' )

   hydra_file_widget_check_status, widgetData

   return, widgetData
end

