pro hydra_fv_control_event, ev
  common hydra_fv_control_common, widget_data, cspecies
  common rp_hydra_fv_common, fv_out_header, fv_ele, fv_ion

  species= cspecies
  
  widget_control, ev.id, get_uvalue=uvalue 
  widget_control, widget_data.time_ID, get_value=timestr1
  
  timestr1= str_sep(timestr1(0),'[')
  timestr= timestr1(0)
  if n_elements( timestr1 ) gt 1 then $
    handle= long( timestr1(1) )$
  else $
    handle= -999                ; bogus 
  t90_str= convert_TimeToSeconds( timestr(0), /t90 )
  t90= t90_str.value
  err= t90_str.err
  case uvalue of 
      'pb_add': if err eq 0 then hydra_fv_listman, add_one=t90, species=species
      'pb_delete': if err eq 0 then begin
          hydra_fv_listman, delete_one=t90, index=index, species=species
          if index ne -1 then begin
              hydra_fv_rw_list, /read, species, $
                fv_header, fv_data
              time= fv_data(index).time + fv_header.start_time
              widget_control, widget_data.time_ID, $
                set_value= convert_secondstotime( time, /t90, country=1 )
          endif
      end
      'pb_delete_series': $
        hydra_fv_listman, delete_handle= handle, species=species
      'list_input': begin
          idx= ev.index+1
          widget_data.list_index=idx-1
          hydra_fv_rw_list, /read, species, fv_header, fv_data
          time= fv_data(idx).time + fv_header.start_time
          set_value= convert_secondstotime( time, /t90, country=1 )
          if fv_data(idx).handle gt 0 then $
            set_value= set_value+' ['+ strtrim( fv_data(idx).handle,2 )+']'
          widget_control, widget_data.time_ID, $
            set_value= set_value
      end
      'time_input': if err eq 0 then begin
          if widget_data.mode_switch eq 0 then begin
              hydra_fv_listman, add_one=t90, species=species
          endif else hydra_fv_listman, delete_one=t90, species=species
      endif      
      'pb_mode0': widget_data.mode_switch=0
      'pb_mode1': widget_data.mode_switch=1
      'series': 
      'pb_series': begin
;         get start time
          widget_control, widget_data.series_in_ID, get_value=timestr
          t90_str= convert_TimeToSeconds( timestr(0), /t90 )
          t90in= t90_str.value
          err= t90_str.err
;         get end time
          widget_control, widget_data.series_out_ID, get_value=timestr
          t90_str= convert_TimeToSeconds( timestr(0), /t90 )
          t90out= t90_str.value
          err= t90_str.err + err
;         get increment (seconds)
          widget_control, widget_data.series_delta_ID, get_value=delta
          delta= long( delta )
          if err eq 0 then $
            hydra_fv_listman, add_series=[ t90in, t90out, delta ], $
            species=species
      end
      'pb_dismiss': begin
          widget_control, widget_data.base_ID, /destroy
          r= temporary( widget_data )
          return
      end
      'pb_control': begin
          hydra_fv_rw_list, /read, species, fv_header, fv_data, fv_input_global
          r= where( abs( fv_data(*).time - t90 ) lt 1.0 )
          if r(0) ne -1 then begin
              fv_input= fv_data(r(0)).fv_input
              state= fv_input
              species_store= fv_input.species
              if species eq 0 then $
                control_ele= fv_input.control $
              else $
                control_ion= fv_input.control 
              fpitch_control, fv_input, widget_Data.base_id, /modal
              fv_data(r(0)).fv_input= fv_input
              fv_data(r(0)).reload=1
              if n_elements(fv_out_header) gt 0 then $
                fv_out_header.reload(species)=1
              hydra_fv_rw_list, /write, species, fv_header, fv_data, $
                fv_input_global
          endif else begin
              message, 'Couldn''t find time.', /cont
              return
          endelse
      end
      else: begin
          message, 'unrecognized uvalue.', /cont
      end
  endcase
  hydra_fv_rw_list, /read, species, fv_header, fv_data
      
  hydra_fv_listman, timestr, /get_labels, species=species
  widget_control, widget_data.list_ID, set_value= timestr
  widget_control, widget_data.list_ID, set_list_select=widget_data.list_index
  
  return
end

pro hydra_fv_control, t90, species=species, group_leader=group
; creates the widget that controls the fv (slice) module.  Allows
; user to add and delete slices, and add or delete a series of
; slices.
  
  common hydra_fv_control_common, widget_data, cspecies

   if xregistered('hydra_fv_control') then begin
       if cspecies ne species then begin
           widget_control, widget_data.base_ID, /destroy          
       endif else begin           
           if n_elements(t90) gt 0 then begin
               if widget_data.mode_switch eq 0 then begin
                   hydra_fv_listman, add_one=t90, species=species
               endif else begin 
                   hydra_fv_listman, delete_one=t90, species=species
               endelse
               hydra_fv_rw_list, /read, species, $
                 fv_header, fv_data, fv_input_global
               timestr= convert_SecondsToTime( t90, /t90,country=1) 
               widget_control, widget_data.time_ID, set_value= timestr
           
               hydra_fv_listman, timestr, /get_labels, species=species
               widget_control, widget_data.list_ID, set_value= timestr

               return
           endif
       endelse
   endif

   common time, xut1, xut2
   if n_elements( xut1 ) gt 0 then begin
       xut1str= convert_SecondsToTime( xut1, /t90,country=1) 
       xut2str= convert_SecondsToTime( xut2, /t90,country=1) 
   endif else begin
       xut1str= '05/29/96 7:00'
       xut2str= '05/29/96 7:15'
   endelse
   cspecies=species

   if n_elements(widget_data) eq 0 then begin
       widget_data= {  $
                      base_ID:0L, $
                      time_ID:0L, $
                      list_ID:0L, $
                      list_index:0L, $
                      series_in_ID:0L, $
                      series_in_val:xut1str, $
                      series_out_ID:0L, $
                      series_out_val:xut2str, $
                      series_delta_ID:0L, $
                      series_delta_val:'60', $
                      mode_switch:0L }
   endif

; The slicer sent a time, treat this like button push event.
   if n_elements(t90) gt 0 then begin
       if widget_data.mode_switch eq 0 then begin
           hydra_fv_listman, add_one=t90, species=species
       endif else begin 
           hydra_fv_listman, delete_one=t90, species=species
       endelse
   endif
   hydra_fv_rw_list, /read, species, fv_header, fv_data, fv_input_global

   specstr=['Ele','Ion']
   control_base= papco_widget_base( title=specstr(species)+' Slice Control',$
                                    /column, group=group )
   widget_data.base_ID= control_base

   
; mode base action determines what is done with papco slices.
   mode_base= widget_base( control_base, /column, /frame )
   x= widget_label(mode_base, value='PaPCo Slicer Action')
   b= widget_base( mode_base, /column, /exclusive )
   x= widget_button( b, value='Add Slices', uvalue='pb_mode0' )
   widget_data.mode_switch=0    ; 0=add, 1=delete 
   widget_control, x, set_button=1
   x= widget_button( b, value='Delete Slices', uvalue='pb_mode1' )
   
  
; time base allows user to add/delete specific time
   times_base= widget_base( control_base, /frame, /column )
   if n_elements(t90) gt 0 then $     
     timestr= convert_SecondsToTime( t90, /t90,country=1) $
   else $
     timestr= xut1str
   r= widget_text( times_base, $
                   /edit, xsize=24, value=timestr, $
                   uvalue='time_input' )
   widget_data.time_ID= r
   
   timestr= ['---']
   r= widget_list( times_base, $
                   xsize=20, scr_xsize=160, ysize=5, value=timestr, $
                   uvalue='list_input' )
   widget_data.list_ID=r
   widget_data.list_index=0
   widget_control, widget_data.list_ID, $
     set_list_select= widget_data.list_index
   hydra_fv_listman, timestr, /get_labels, species=species
   widget_control, widget_data.list_ID, set_value= timestr
   
   if timestr(0) ne '---' then begin
       widget_control, widget_data.time_ID, set_value= timestr(0)
   endif

; add/delete time and delete series button
   times_but_base= widget_base( times_base, /row )
   r= widget_button( times_but_base, value='Add', uvalue='pb_add' )
   r= widget_button( times_but_base, value='Delete', uvalue='pb_delete' )
   r= widget_button( times_but_base, value='Delete Series', $
                     uvalue='pb_delete_series' )
   r= widget_button( times_base, value='Control', uvalue='pb_control')

; series base allows user to add delete a series
   series_base= widget_base( control_base, /frame, /column )
   r= widget_label( series_base, value='Series Start Time: ' )
   r= widget_text( series_base, $
                   /edit, xsize=20, value=widget_Data.series_in_val, $
                   uvalue='series' )
   widget_data.series_in_ID= r
   r= widget_label( series_base, value='Series End Time: ' )
   r= widget_text( series_base, $
                   /edit, xsize=20, value=widget_Data.series_out_val, $
                   uvalue='series' )
   widget_data.series_out_ID= r
   b= widget_base( series_base, /row )
   r= cw_field( series_base, $
                title='Series Increment (sec): ', $
                xsize=5, value=widget_Data.series_delta_val, $
                uvalue='series', /float )
   widget_data.series_delta_ID= r
   r= widget_button( series_base, value='Add Series', uvalue='pb_series' )

   onelast_base= widget_base( control_base, /frame, /row )
   b= widget_button( onelast_base, value='Dismiss', uvalue='pb_dismiss' )
   
   widget_control, control_base, /realize

   init_fpitch, fv_input, control_ele, control_ion, $
     species= species

   widget_state= { slice_draw:0L, $
                   winidx:0L, $
                   state:fv_input, $
                   control_ele:control_ele, $
                   control_ion:control_ion, $
                   lock_id:0L }
   widget_control, control_base, set_uvalue= widget_state

   xmanager, 'hydra_fv_control', control_base

end
