pro hydra_fv_listman, arg1, $
                      reset=reset, add_one=add, delete_one=delete, $
                      add_series=add_series, $
                      index=index, delete_handle=delete_handle, $
                      get_labels=get_labels, $
                      species=species
                      

; listman:  general list manager for papco
; 
; Actions:
;    /reset             reset list 
;    add_one=x          add x to end of list
;    delete_one=x       delete first x from list
;    add_series=[a,b,d] add fix((b-a)/d) elements to list, starting at
;                          a, incrementing d.
;    delete_handle=n    delete all elements with handle n
;    index=n            set n equal to a useful index (like index of
;                          last added item, or index of next to delete.
;    /get_labels        return a strarr of label names.
;    species=species    species context used to set index

hydra_fv_rw_list, /read, species, fv_header,fv_data,fv_input_global

common time, xut1, xut2
forward_function convert_SecondsToTime

index=-1                        ; be certain to return something

if keyword_set( reset ) then begin    
    
    fv_header= { fv_header_struct_1_12, $
                 start_time:double(0), $
                 end_time:1d31, $
                 reload_flag:1, $
                 n:51, m:51, $
                 handle:0L, $
                 species:0 $
               }

    fv_data= { fv_data_struct_1_12, $
               time:double(0), $               
               fv_input:fv_input_global, $
               handle:-1L, $    ; identifies operation
               species:-99, $   ; this one is a bogus place holder.
               reload:0 }
endif

list_empty= n_elements( fv_data ) eq 1

if n_elements(add_series) eq 3 then $
  fv_header.handle= fv_header.handle + 1

if n_elements(add) gt 0 then begin
    fv_data1= { fv_data_struct_1_12 }
    s= size(add)
    if s(n_elements(s)-2) eq 8 then begin ; structure form to add
        yyyymmdd= add.mode.path 
        hh_mm_ss= add.mode.t0 
        hms= fix( str_sep( hh_mm_ss, ':' ) )
        hms(2)= hms(2) + 13.8*add.mode.next - 13.8*add.mode.prev ;kludge
        r= convert_date_to_t90( year= yyyymmdd/10000, $
                                month= yyyymmdd/100 mod 100, $
                                day= yyyymmdd mod 100, $
                                hour= hms(0), $
                                min= hms(1), $
                                sec= hms(2) )
        fv_data1.time= r - fv_header.start_time
        fv_data1.fv_input= add
    endif else begin
        fv_data1.time= add - fv_header.start_time
        fv_data1.fv_input= fv_input_global
    endelse
    fv_data1.reload= 1
    fv_data1.handle= 0
    fv_data1.species= species
    fv_data= [ fv_data, fv_data1 ] 
    common rp_hydra_fv_common, fv_out_header, fv_ele, fv_ion
    if n_elements(fv_out_header) gt 0 then fv_out_header.reload(species)=1
    fv_header.reload_flag= 1
    index= n_elements(fv_data)-1 ; index is last guy added
endif

if n_elements(add_series) eq 3 then begin
    delta= add_series(2)
    in= add_series(0)
    out= add_series(1)
    n= long( ( out-in ) / delta ) +1 > 2 ; less than 2 causes crash, since array is assumed.
    fv_data1= replicate( { fv_data_struct_1_12 }, n )
    fv_data1(*).time= dindgen(n)*delta + in
    fv_data1(*).fv_input= replicate( fv_input_global, n )
    fv_data1(*).reload= 1
    fv_data1(*).handle= fv_header.handle
    fv_data1(*).species= species
    fv_data= [ fv_data, fv_data1 ]
    if n_elements(fv_out_header) gt 0 then fv_out_header.reload(species)=1
    fv_header.reload_flag= 1
    index= n_elements(fv_data)-1 ; index is last guy added    
endif
    
if n_elements(delete) gt 0 then begin    
    r= where( abs( fv_data(*).time + fv_header.start_time - delete ) lt 1.0 )
    if r(0) ne -1 then begin
        last=n_elements(fv_data)-1
        if list_empty then begin
            message, 'list is empty', /cont 
            return
        endif
        imin=r(0)
        if imin eq 0 then fv_data= fv_data((imin+1):*) $
        else if imin eq last then fv_data= fv_data(0:(imin-1)) $
        else fv_data= [ fv_data(0:(imin-1)), fv_data((imin+1):*) ]
        index= imin < (n_elements(fv_data)-1)
    endif else begin
        message, 'time not found.', /cont
    endelse
end

if n_elements( delete_handle ) then begin
    handle= delete_handle
    r= where( fv_data(*).handle ne handle )
    r1= where( fv_data(*).handle eq handle )
    if r(0) ne -1 then fv_data= fv_data(r) ; r should not equal -1
    index= r1(0)
endif

list_empty= n_elements( fv_data ) eq 1

; clean up handle space
if not list_empty then begin
    r= where( fv_data(1:*).handle gt 0 ) +1
    if r(0) ne 0 then begin
        h= ( fv_data(r).handle )
        if n_elements( h ) gt 1 then u= uniq( h, sort(h) ) else u=0
        nh= intarr( max(h)+1 )
        nh( h(u) ) = indgen( n_elements(u) )+1
        fv_data(r).handle= nh(h)
        fv_header.handle= max( nh(h) )
    endif
endif

if keyword_set(get_labels) then begin
    ntime= ( n_elements( fv_data(*).time )-1 ) < 30
    if ntime gt 0  then begin
        timestr= strarr( ntime )
        series_str= strarr( n_elements(fv_data) )
        r= where( fv_data(*).handle gt 0)
        if r(0) ne -1 then series_str(r)= $
          ' ['+strtrim(fv_data(r).handle,2)+']'
        for i=1,ntime do $          
          timestr(i-1)=$
          convert_SecondsToTime(fv_data(i).time, /t90,countr=1)+$
          series_str(i)
    endif else begin
        timestr=['---']
    endelse
    arg1=timestr
endif

hydra_fv_rw_list, /write, species, fv_header,fv_data,fv_input_global
return

end
