pro hydra_fv_rw_list, species, fv_header,fv_data,fv_input_global, $
                      read=read, write=write

  common hydra_fv_common, $
    fve_header, fve_data, fve_input_global, $
    fvi_header, fvi_data, fvi_input_global

  if n_elements( fve_header ) eq 0 then begin 
      message, 'Initializing list...', /cont
      init_fpitch, fv_input, control_ele, control_ion
      fv_input.mode.last_block=-1
      fv_input.mode.fillcon=1
      fv_input.mode.drawcon=0
      fv_input.mode.colorplot=0

      fve_input_global= fv_input
      fvi_input_global= fv_input      
      fve_input_global.species.ele= 1
      fve_input_global.species.ion= 0
      fve_input_global.control= control_ele
      fvi_input_global.species.ele= 0
      fvi_input_global.species.ion= 1
      fvi_input_global.control= control_ion

      fv_header= { fv_header_struct_1_12, $
                   start_time:double(0), $
                   end_time:1d31, $
                   reload_flag:1, $
                   n:51, m:51, $
                   handle:0L, $
                   species:0 $
                 }
      fve_header= fv_header
      fvi_header= fv_header
      
      fve_data= { fv_data_struct_1_12, $
                  time:double(0), $               
                  fv_input:fve_input_global, $
                  handle:-1L, $ ; identifies operation
                  species:-99, $ ; this one is a bogus place holder.
                  reload:0 }
      fvi_data= fve_data
      fvi_data.fv_input=fvi_input_global
  endif
  
  if keyword_set(read) then begin
      if species eq 0 then begin ; select the context
          fv_header= fve_header
          fv_data= fve_data
          fv_input_global= fve_input_global
      endif else begin
          fv_header= fvi_header
          fv_data= fvi_data
          fv_input_global= fvi_input_global
      endelse
      
      return
  endif

  if keyword_set(write) then begin
      if species eq 0 then begin ; select the context
          fve_header= fv_header
          fve_data= fv_data
          fve_input_global= fv_input_global
      endif else begin
          fvi_header= fv_header
          fvi_data= fv_data
          fvi_input_global= fv_input_global
      endelse
      return
  endif
end
