pro hydra_moments_configure
   common hydra_moments_config, ID_moments_data_dir,moments_data_dir

   base= widget_base( /column, title='Hydra Moments Configure' )
   
;  add Moments Data Directory Widgets
   base1= widget_base( base, /row )
   rr= cw_field( base1, $
                 value= getenv( 'HYDRA_MOMENTS_DATA_PATH' ) , $
                 title= 'Hydra Moments', $
                 uvalue= 'cwf_moments_data_dir', $
                 /string, /frame, /column, xsize=80 )
   ID_moments_data_dir = rr

;  add Action Buttons
   action_base= widget_base( base, /row, /frame )
   rr= widget_button( action_base, $
                      value='Okay', $
                      uvalue='pb_okay' )
   rr= widget_button( action_base, $
                      value='Cancel', $
                      uvalue='pb_cancel' )   
   rr= widget_button( action_base, $
                      value='Help', $
                      uvalue='pb_help' )

;  center widget on screen
   geo= widget_info( base, /geo )
   x= 600- geo.xsize/2
   y= 300- geo.ysize/2

   widget_control, base, xoffset=x, yoffset=y

;  realize and start xmanager with widget in modal mode.
   widget_control, base, /realize
   xmanager, 'hydra_moments_configure', base, /modal

   return
end

pro hydra_moments_configure_event, event

   common hydra_moments_config, ID_moments_data_dir,moments_data_dir
   widget_control, event.id, get_uval= uval

   case uval of 
       'pb_okay': BEGIN

;          read widget entries
           widget_control, ID_moments_data_dir, $
             get_value=data
           moments_data_dir= data(0)

;          set environment variables
           hydra_module= getenv('HYDRA_MODULE_PATH')
           ss= 'setenv, ''HYDRA_MOMENTS_DATA_PATH='+$
             moments_data_dir+''''
           r=execute(ss)

           widget_control, event.top, /destroy           
       end
       'pb_cancel': begin
           widget_control, event.top, /destroy
       end
       'pb_help': begin
           xdisplayfile,module_helpfile('hydra_moments_configure.help')
       end
       else: print, 'hydra_moments_configure: internal error.'
   endcase
   return
end

   
