pro hydra_rw_configuration, read=read, write=write, stat=stat

;  Note:
;  write copies from common block to (disk,environment)
;  read copies from disk to (environment,common block)
;    (Don't ask me why I have both environment and common block storage)

;  write copies lines from existing configuration file to new, 
;    changing only the lines it recognizes.

   common hydra_configure_common, configure_data

   stat='success'
   hydra_module= getenv('HYDRA_MODULE_PATH')

   if !version.os_family eq 'Windows' then dir_sep='\' else dir_sep='/'

   if keyword_set(read) then begin
       on_ioerror, cannot_read
       openr, 11, hydra_module+dir_sep+'hydra_configure_module.pro'
       
       ss= ' '
       while not eof(11) do begin
           readf, 11, ss
           r=execute(ss)       
       endwhile

       close, 11

       if n_elements( configure_data ) eq 0 then begin           
           configure_data= { $
                             survey_data_dir:' ', $
                             level1_data_dir:' ', $
                             level1cal_data_dir:' ', $
                             l1_time_limit:' ', $
                             ID_base:0L, $
                             ID_survey_data_dir:0L, $
                             ID_level1_data_dir:0L, $
                             ID_level1cal_data_dir:0L, $
                             ID_l1_time_limit:0L, $
                             can_save:1, $
                             ID_save:0L $
                           }
       endif

       configure_data.level1_data_dir=getenv( 'HYDRA_LEVEL1_DATA_PATH' )
       configure_data.level1cal_data_dir = getenv('HYDRA_LEVEL1CAL_DATA_PATH')
       configure_data.survey_data_dir=getenv( 'HYDRA_SURVEY_DATA_PATH' )
       configure_data.l1_time_limit=getenv( 'HYDRA_L1_SPEC_TIME_LIMIT' )
              
   endif

   if keyword_set(write) then begin
       on_ioerror, cannot_write
       fnew= hydra_module+dir_sep+'hydra_configure_module_new.pro'
       fold= hydra_module+dir_sep+'hydra_configure_module.pro'

       openr, lunold, fold, /get_lun
       openw, lunnew, fnew, /get_lun
       
       s=''
       while not eof(lunold) do begin
           readf, lunold, s
           
           ss= str_sep(s,';')     ; remove comments
           ss= ss(0)
           
           ss= strtrim(str_sep( ss, '=' ),2)
           if n_elements(ss) eq 2 and $
             strlowcase(strmid(ss(0),0,6)) eq 'setenv' then begin
               env= strtrim( str_sep( ss(0), "," ), 2) 
               env= strmid( env(1), 1, 80 )
               out= 'no matches'               
               case 1 of 
                   env eq 'HYDRA_LEVEL1_DATA_PATH': $
                     out= configure_data.level1_data_dir
                   env eq 'HYDRA_LEVEL1CAL_DATA_PATH': $
                     out= configure_data.level1cal_data_dir
                   env eq 'HYDRA_SURVEY_DATA_PATH': $
                     out= configure_data.survey_data_dir
                   env eq 'HYDRA_L1_SPEC_TIME_LIMIT': $
                     out= configure_data.l1_time_limit               
                   else: out='no matches'
               endcase
               if strtrim(out,2) ne 'no matches' then begin
                   printf, lunnew, "setenv, '" + env + '=' + out + "'"
               endif else begin
                   printf, lunnew, s
               endelse
           endif else begin
               printf, lunnew, s
           endelse
       endwhile
       close, lunnew
       close, lunold

       if !version.os_family eq 'Windows' then begin
           spawn, 'move '+fnew+' '+fold
       endif else begin
           spawn, 'mv '+fnew+' '+fold
       endelse
   endif

   return

   cannot_write:
   print, 'hydra_rw_configuration: can''t write configuration file.'
   stat='fail'
   return

   cannot_read:
   print, 'hydra_rw_configuration: can''t read configuration file.'
   stat='fail'
   return
   
end

