pro hydra_skew_drawangles, red=red_ranges, blue=blue_ranges, animate=animate
  common papco_color_names
  
  plot, position=[0,0,1,1], [-1,1], [-1,1], /nodata, xstyle=5, ystyle=5

; erase and draw blank plot with axes
  polyfill, [-1,-1,1,1,-1], [-1,1,1,-1,-1,1], color=white
  if not keyword_set( animate ) then begin
      oplot, [0,0], [-1,1], linestyle=1, thick=1.5, color=black
      oplot, [-1,1], [0,0], linestyle=1, thick=1.5, color=black
      polyfill, [ 0,1,0,0 ]*0.2+0.8, [-1,0,1,-1]*0.2, color=black
      
;     show this for a second... this helps the eye understand the change.
      empty
      wait, .05
  endif
  
  angles= findgen(181)/180. * !pi 
  circy= sin( angles ) * ( 0.80 + 0.02 * sin( 50*angles ) )
  circx= cos( angles ) * ( 0.80 + 0.02 * sin( 50*angles ) )

  for i= 0, n_elements(red_ranges)-1, 2 do begin
      b1= red_ranges(i) * !dtor
      b2= red_ranges(i+1) * !dtor
      r= where( angles ge b1 and angles le b2 )
      polyfill, [ 0, circx(r), 0 ], [ 0, circy(r), 0 ], color=red
      polyfill, [ 0, circx(r), 0 ], [ 0, -circy(r), 0 ], color=red
  endfor

  for i= 0, n_elements(blue_ranges)-1, 2 do begin
      b1= blue_ranges(i) * !dtor
      b2= blue_ranges(i+1) * !dtor
      r= where( angles ge b1 and angles le b2 )
      polyfill, [ 0, circx(r), 0 ], [ 0, circy(r), 0 ], color=blue
      polyfill, [ 0, circx(r), 0 ], [ 0, -circy(r), 0 ], color=blue
  endfor

  oplot, [0,0], [-1,1], linestyle=1, thick=1.5, color=black
  oplot, [-1,1], [0,0], linestyle=1, thick=1.5, color=black
  polyfill, [ 0,1,0,0 ]*0.2+0.8, [-1,0,1,-1]*0.2, color=black
  
  return
end
   
