pro hydra_spec_l1_options_event, event
   common hydra_spec_l1_options_common, widgetData

   widget_control, event.id, get_uval= uval
;   child= widget_info( event.top, /child )
;   widget_control, child, get_uvalue= widgetData

   s= str_sep( uval,':' )
   action=s(0)
   case action of
       'pb_okay': begin
           widget_control, event.top, /destroy
           return
       endif
       'tres': begin
           arg= float((str_sep(s(1),','))(event.index))           
           widgetData.options(0)= arg
       end
       'include_box1': begin
           arg= event.select
           s= widgetData.soptions(0)
           if strtrim(s,2) eq '' then s= '111111111111'
           is= byte(s)
           is(indgen(6)*2+0)= arg+48
           widgetData.soptions(0)= string(is)
       end
       'include_box2': begin
           arg= event.select
           s= widgetData.soptions(0)
           if strtrim(s,2) eq '' then s= '111111111111'
           is= byte(s)
           is(indgen(6)*2+1)= arg+48
           widgetData.soptions(0)= string(is)
       end
       else: print, 'hydra_spec_l1_options: unrecognised uval: ', uval
   endcase
   
;   widget_control, child, set_uvalue= widgetData
   return
end


pro hydra_spec_l1_options, widgetData_1, parent=parent
   common hydra_spec_l1_options_common, widgetData

   widgetData= widgetData_1
   base= widget_base( /column, title='Hydra L1 Options' )
;   child= widget_base( base )
   
   if n_elements( parent ) gt 0 then begin
       r= widget_info( parent, /geo )
       widget_control, base, xoffset=r.xoffset
       widget_control, base, yoffset=r.yoffset+300
   endif

;   add tres options   
   base1= widget_base( base, /row )
   l= widget_label( base1, value='Select time resolution: ' )
   i= [ 0.575, 1.15, 2.3, 4.6, 6.9, 13.8 ]
   uval= 'tres: '
   for qq= 0,n_elements(i)-1 do uval= uval+string(i(qq))+','
   w= widget_droplist( base1, value=strtrim(string(i,form='(f6.3)'),2)+' s', uval=uval  )
   r= where( abs( widgetData.options(0) - i ) lt 0.01 )
   if r(0) ne -1 then begin
       widget_control, w, set_droplist_select=r(0)
   endif

   
;   add include detectors
   s= widgetData.soptions(0)
   if strtrim(s,2) eq '' then s='111111111111'
   is= byte(s)

   base1= widget_base( base, /row, /nonexclusive )
   x= widget_button( base1, value='Box1', uvalue='include_box1' )
   widget_control, x, set_button=is[0]-48

   x= widget_button( base1, value='Box2', uvalue='include_box2' )
   widget_control, x, set_button=is[1]-48
   
;  add Action Buttons
   action_base= widget_base( base, /row, /frame )
   rr= widget_button( action_base, $
                      value='Okay', $
                      uvalue='pb_okay' )

;  realize and start xmanager with widget in modal mode.
   widget_control, base, /realize

;   widget_control, child, set_uvalue= widgetData

   xmanager, 'hydra_spec_l1_options', base, /modal

   widgetData_1= widgetData
;   widget_control, child, get_uvalue= widgetData
   return
end

