;***************************************************************************
;* file papcoadd_polar_hydra
;*      Papcoadd_hydra_spec
;*      Papcoadd_hydra_skew
;*      Papcoadd_hydra_ppa
;*      Papcoadd_hydra_kp
;*      Papcoadd_hydra_tpp
;*      Papcoadd_hydra_spp
;*      Papcoadd_hydra_kp_extra
;*      Papcoadd_hydra_tpphr
;*      Papcoadd_hydra_sppion
;*      Papcoadd_hydra_moments
;*      Papcoadd_hydra_current
;*      Papcoadd_hydra_other
;*      Papcoadd_hydra_bfield
;*      Papcoadd_hydra_events
;*      Papcoadd_hydra_ticks
;*      Papcoadd_hydra_kptest
;*      Papcoadd_hydra_temp
;*      Papcoadd_hydra_fv
;* end
;;;*      Papcoadd_hydra_simple_spec
;*
;* this files contains all the collected routines which have to be added in
;* for hydra_plots.
;*
;*    Those procedures are contained:
;*
;*    PRO addplottype_hydra_plots,plottypes_base,pb_plottype
;*        ->  adds the button for the new plot type to the main window.
;*
;*    PRO plottable_hydra_plots, plottable
;*        -> Sets a variable to indicate plottable without orbit.
;*
;*    PRO descriptor_hydra_plots, plotInfo, descriptStr
;*        -> Constructs the string used to label plots in the panels window
;*
;*    PRO addpanel_polar_hydra
;*        -> Calls the panel editor for this plottype and adds the plot to the
;*            panel window.
;*
;*    PRO editor_hydra_plots, plotNumber, newPlotData
;*        -> This procedure calls the panel editor when called from
;*	     PAPCO_EditPlot (papco_paneledit.pro).
;*
;*    PRO  draw_hydra_plots, panelVector, currPlotInfo, get_data_call, IsRead
;*        -> This procedure performs actual data read call and the plot call
;*           for this plottype
;***************************************************************************

;***************************************************************************
;*
;* PROCEDURE:
;*      PRO addplottype_hydra_plots,plottypes_base,buttonGeometry,pb_plottype
;*
;* DESCRIPTION:
;*	This procedure adds a button for this plottype to the plottypes_base.
;*      The UVALUE declared here is critical, since it is used to construct
;*      the procedure names of all procedures contained in this add-in
;*	papckage, so that they can be automatically called when needed.
;*
;* INPUTS:
;*	plottypes_base	the widget ID of the parent widget to contain the
;*			plottype buttons.
;*
;* OUTPUTS:
;*   	pb_plottype	the widget ID of the button created here.
;*      buttonGeometry  size of the button. Only used in simple
;*                      WIDGET_BUTTON to make them the same size as the
;*                      compound CW_PDMENU, pulldown for subtypes.
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	addplottype_hydra_plots,plottypes_base,buttonGeometry,pb_plottype
;*
;* MODIFICATION HISTORY:
;*
;***************************************************************************
pro addplottype_polar_hydra,plottypes_base,buttonGeometry,pdm_polar_hydra

; VALUE assigns a label for the button
; The polar_hydra portion of UVALUE is used to construct the calls to all
; other procedures in this add-in needed by PAPCO.

  if polar_hydra_public() then begin
      MenuDesc544 = [ $
                      { CW_PDMENU_S, 3, strcenter('PO-HYDRA',10) }, $
                      { CW_PDMENU_S, 0, ' plot Spec           ' }, $
                      { CW_PDMENU_S, 0, ' plot Skew           ' }, $
                      { CW_PDMENU_S, 0, ' plot Miscellany     ' }, $
                      { CW_PDMENU_S, 0, ' plot Bfield         ' }, $
                      { CW_PDMENU_S, 0, ' plot Events         ' }, $
                      { CW_PDMENU_S, 0, ' tick labels         ' }, $
                      { CW_PDMENU_S, 2, ' config module       ' } $
                    ]
  endif else begin
      MenuDesc544 = [ $
                      { CW_PDMENU_S, 3, strcenter('PO-HYDRA',10) }, $
                      { CW_PDMENU_S, 0, ' plot Spec           ' }, $
                      { CW_PDMENU_S, 0, ' plot Skew           ' }, $
                      { CW_PDMENU_S, 0, ' plot PPA            ' }, $
                      { CW_PDMENU_S, 0, ' plot KP moments     ' }, $
                      { CW_PDMENU_S, 0, ' plot TPP moments    ' }, $
                      { CW_PDMENU_S, 0, ' plot SPP moments    ' }, $
;use tpp                  { CW_PDMENU_S, 0, ' plot Ion KP TPP     ' }, $
;use tpp                  { CW_PDMENU_S, 0, ' plot Ion KP TPPHR   ' }, $
;use spp                  { CW_PDMENU_S, 0, ' plot Ion KP SPP     ' }, $
      { CW_PDMENU_S, 0, ' plot Moments        ' }, $
        { CW_PDMENU_S, 0, ' plot Moments - J    ' }, $
        { CW_PDMENU_S, 0, ' plot Miscellany     ' }, $
        { CW_PDMENU_S, 0, ' plot Bfield         ' }, $
        { CW_PDMENU_S, 0, ' plot Events         ' }, $
        { CW_PDMENU_S, 0, ' tick labels         ' }, $
;dcom                  { CW_PDMENU_S, 0, ' plot KP Test        ' }, $
      { CW_PDMENU_S, 0, ' plot fv             ' }, $
;                  { CW_PDMENU_S, 0, ' plot temporary      ' }, $
;                  { CW_PDMENU_S, 0, ' plot simple spec    ' }, $
;                  { CW_PDMENU_S, 0, ' data manager        ' }, $
      { CW_PDMENU_S, 2, ' config module       ' } $
        ]
  endelse

  pdm_polar_hydra = CW_PDMENU(plottypes_base, MenuDesc544, $
                              UVALUE='pdm_polar_hydra')

END

;***************************************************************************
;*
;* PROCEDURE:
;*      PRO plottable_hydra_subtype, plottable
;*
;* DESCRIPTION:
;*	Sets a variable to indicate plottable without orbit. One routine for
;*      each subtype
;*
;* INPUTS:
;*	none
;*
;* OUTPUTS:
;*   	plottable	a boolean 0 if plottable only by hydra orbit
;*                                1 if plottable by time also.
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	plottable_hydra_subtype, plottable
;*
;* MODIFICATION HISTORY:
;*
;***************************************************************************
pro plottable_hydra_spec, plottable
   plottable=1
END
pro plottable_hydra_skew, plottable
   plottable=1
END
pro plottable_hydra_ppa, plottable
   plottable=1
END
pro plottable_hydra_kp, plottable
   plottable=1
END
pro plottable_hydra_tpp, plottable
   plottable=1
END
pro plottable_hydra_spp, plottable
   plottable=1
END
pro plottable_hydra_kp_extra, plottable
   plottable=1
END
pro plottable_hydra_tpphr, plottable
   plottable=1
END
pro plottable_hydra_sppion, plottable
   plottable=1
END
pro plottable_hydra_moments, plottable
   plottable=1
END
pro plottable_hydra_current, plottable
   plottable=1
END
pro plottable_hydra_other, plottable
   plottable=1
END
pro plottable_hydra_bfield, plottable
   plottable=1
END
pro plottable_hydra_ticks, plottable
   plottable=1
END
pro plottable_hydra_kptest, plottable
   plottable=1
END
pro plottable_hydra_fv, plottable
   plottable=1
END
pro plottable_hydra_temp, plottable
   plottable=1
END
;pro plottable_hydra_simple_spec, plottable
;   plottable=1
;END
pro plottable_hydra_events, plottable
   plottable=1
END

;******************************************************************************
;* PROCEDURE:     
;*      PRO canget_polar_hydra, canget
;*
;* DESCRIPTION:  
;*      Sets a variable to indicate that polar_hydra support the OUTPUT
;*      functionality. 
;*      
;* NB!  You will need one of these routines for each submenu entry you
;*      add. The name of the routine MUST consist of "canget_" plus
;*      the panel_kind you have set for your submenu entry in 
;*      addpanel_polar_eph.
;*
;* INPUTS:       
;*      none
;*
;* OUTPUTS: 
;*      canget         a boolean 0 if this feature is not available
;*                               1 if this feature is available
;*
;* KEYWORDS:
;*      none
;* 
;* CALLING SEQUENCE:
;*      canget_polar_hydra, canget
;******************************************************************************
PRO canget_hydra_spec, canget & canget = 1 & END
PRO canget_hydra_skew, canget & canget = 1 & END
PRO canget_hydra_moments, canget & canget = 1 & END
PRO canget_hydra_bfield, canget & canget = 1 & END

;***************************************************************************
;*
;* PROCEDURE:
;*      PRO descriptor_polar_hydra, plotInfo, descriptStr
;*
;* DESCRIPTION:
;*	Constructs the string used to label plots in the panel window
;*
;* INPUTS:
;*	plotInfo        structure containing all data for this plot.
;*                      (structure type: PAPCO_PLOTINFO,
;*                                             see papco_variables.text)
;*
;* OUTPUTS:
;*   	descriptStr	a string containing the label
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	descriptor_polar_hydra, plotInfo, descriptStr
;*
;* MODIFICATION HISTORY:
;*
;***************************************************************************
pro descriptor_hydra_spec, plotInfo, descriptStr
    case plotInfo.typeVector(1) of
        1: tres='sv '
        2: tres='hr '
        else: tres=''
    endcase
    case plotInfo.typeVector(0) of
        0: type='electrons'
        1: type='ions'
        else: type='EE'
    endcase
    case plotInfo.typeVector(2) of
        0: pitch=''
        1: pitch=': aligned'
        2: pitch=': perp'
        3: pitch=': opposed'
        else: pitch='EE'
    endcase
    descriptStr= tres+type+pitch
END

pro descriptor_hydra_skew, plotInfo, descriptStr
    case plotInfo.typeVector(1) of
        1: tres='sv '
        2: tres='hr '
        else: tres=''
    endcase
    case plotInfo.typeVector(0) of
        0: spec='electrons '
        1: spec='ions '
        else: spec='EE'
    endcase
    case plotInfo.typeVector(2) of
        0: type='Skew '
        1: type='Anisotropy '
        2: type='Binary Skew '
    END
    descriptStr= spec+type+tres
end
    
pro descriptor_hydra_ppa, plotInfo, descriptStr

   COMMON hydra_ppa_labels, $
    ppa_labels

    IF n_elements(ppa_labels) EQ 0 THEN $
     hydra_define_structure,/ppa_lab

    varb = ppa_labels(plotInfo.typeVector(0),1)

    descriptStr=descriptStr+varb
END
pro descriptor_hydra_kp, plotInfo, descriptStr
COMMON hydra_kp_labels, $
  kp_labels
case plotInfo.typeVector(0) of
    0: type='lr kp ele '
    1: type='lr kp ion '
    2: type='hr kp ele '
    else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
ENDCASE
IF n_elements(kp_labels) EQ 0 THEN $
  hydra_define_structure,/kp_lab
varb = kp_labels(plotInfo.typeVector(1),1)
descriptStr=descriptStr+type+varb
END

pro descriptor_hydra_tpp, plotInfo, descriptStr
common hydra_label_maker_block
if (n_elements(tpp_spec_lab) eq 0) then hydra_label_maker, /tpp
spec = tpp_spec_lab(plotInfo.ioptions(0))
res = tpp_res_lab(plotInfo.ioptions(1))
var = tpp_var_lab(plotInfo.ioptions(2),1)
frame = tpp_frame_lab(plotInfo.ioptions(3))
descriptStr = descriptStr+'tpp_'+res+' '+spec+' '+var+' '+frame
end

pro descriptor_hydra_spp, plotInfo, descriptStr
common hydra_label_maker_block
if (n_elements(spp_spec_lab) eq 0) then hydra_label_maker, /spp
spec = spp_spec_lab(plotInfo.ioptions(0))
res = spp_res_lab(plotInfo.ioptions(1))
var = spp_var_lab(plotInfo.ioptions(2),1)
frame = spp_frame_lab(plotInfo.ioptions(3))
descriptStr = descriptStr+'spp_'+res+' '+spec+' '+var+' '+frame
end

pro descriptor_hydra_kp_extra, plotInfo, descriptStr
    case plotInfo.typeVector(0) of
        0: type = 'best density lr tpp'
        1: type = 'rstudy density lr tpp'
        2: type = 'mean energy lr tpp'
        3: type = 'var in bhat lr tpp'
        4: type = 'lshell lr tpp'
        5: type = 'radius lr tpp'
        6: type = 'ccmax lr tpp'
        7: type = 'energy of ccmax lr tpp'
        8: type = 'emax patched lr tpp'
        9: type = 'emin patched lr tpp'
        10:type = 'angle parl ev & B lr tpp'
        11:type = 'v_alf lr tpp'
        12:type = 'umag lr tpp'
        13:type = 'u_parl lr tpp'
        14:type = 'u_perp_x lr tpp'
        15:type = 'u_perp_y lr tpp'
        16:type = 'u_perp_z lr tpp'
        17:type = 'u_perp_mag lr tpp'
        18:type = 'best ux_pay lr tpp'
        19:type = 'rstudy ux_pay lr tpp'
        20:type = 'best uy_pay lr tpp'
        21:type = 'rstudy uy_pay lr tpp'
        22:type = 'best uz_pay lr tpp'
        23:type = 'rstudy uz_pay lr tpp'
        24:type = 'ux_gsm lr tpp'
        25:type = 'uy_gsm lr tpp'
        26:type = 'uz_gsm lr tpp'
        27:type = 'best ktparl lr tpp'
        28:type = 'rstudy ktparl lr tpp'
        29:type = 'best ktperp lr tpp'
        30:type = 'rstudy ktperp lr tpp'
        31:type = 'p_parl lr tpp'
        32:type = 'p_perp lr tpp'
        33:type = 'best gyrotropy lr tpp'
        34:type = 'rstudy gyrotropy lr tpp'
        35:type = 'rchi2 whole lr tpp'
        36:type = 'rchi2 patch lr tpp'
        37:type = 'npatch lr tpp'
        38:type = 'nrealizations lr tpp'
        39:type = 'anisotropy lr tpp'
        else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
    ENDCASE
    case plotInfo.typeVector(2) of
        0: spec ='H+ '
        1: spec ='He+ '
        2: spec ='He++ '
        3: spec ='O+ ' 
        else: spec ='Index: '+strtrim(plotInfo.typeVector(2),2)
    ENDCASE
    descriptStr=descriptStr+spec+type
END

pro descriptor_hydra_tpphr, plotInfo, descriptStr

   COMMON hydra_tpphr_labels, $
    tpphr_labels
   
   case plotInfo.typeVector(0) of
      0: type = '1sweep'
      1: type = '2sweep'
      2: type = '3sweep'
      3: type = '6sweep'
      else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
   ENDCASE
   
   IF n_elements(tpphr_labels) EQ 0 THEN $
    hydra_define_structure,/tpphr_lab
   
   varb = tpphr_labels(plotInfo.typeVector(1),1)
   
   descriptStr=descriptStr+type+varb
END

pro descriptor_hydra_sppion, plotInfo, descriptStr
    case plotInfo.typeVector(0) of
        0: type = 'ion Density lr spp'
        1: type = 'ion Mean Energy lr spp'
        2: type = 'ion Mean Energy Overplt lr spp'
        3: type = 'ion Var in bhat lr spp'
        4: type = 'ion lshell lr spp'
        5: type = 'ion radius lr spp'
        6: type = 'ion CCmax lr spp'
        7: type = 'ion Energy of CCmax lr spp'
        8: type = 'ion Emax Patched lr spp'
        9: type = 'ion Emin Patched lr spp'
        10:type = 'ion Angle Parl ev & B lr spp'
        11:type = 'ion v_alf lr spp'
        12:type = 'ion umag lr spp'
        13:type = 'ion u_parl lr spp'
        14:type = 'ion u_perp_x lr spp'
        15:type = 'ion u_perp_y lr spp'
        16:type = 'ion u_perp_z lr spp'
        17:type = 'ion_u_perp_mag lr spp'
        18:type = 'ion ux_pay lr spp'
        19:type = 'ion uy_pay lr spp'
        20:type = 'ion uz_pay lr spp'
        21:type = 'ion ux_gsm lr spp'
        22:type = 'ion uy_gsm lr spp'
        23:type = 'ion uz_gsm lr spp'
        24:type = 'ion kTparl lr spp'
        25:type = 'ion kTperp lr spp'
        26:type = 'ion P_parl lr spp'
        27:type = 'ion P_perp lr spp'
        28:type = 'ion Rchi2 Whole lr spp'
        29:type = 'ion Rchi2 Patch lr spp'
        30:type = 'ion Npatch lr spp'
        31:type = 'ion Nrealizations lr spp'
        32:type = 'ion Anisotropy lr spp'
        else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
    endcase
    descriptStr=descriptStr+type
END

pro descriptor_hydra_moments, plotInfo, descriptStr

   COMMON hydra_moments_labels, $
    moments_labels

    case plotInfo.typeVector(0) of
        0: type='mom ele '
        1: type='mom ion '
        else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
    ENDCASE

    IF n_elements(moments_labels) EQ 0 THEN $
     hydra_define_structure,/mom_lab

    varb = moments_labels(plotInfo.typeVector(1),1)

    descriptStr=descriptStr+type+varb
END

pro descriptor_hydra_current, plotInfo, descriptStr

   COMMON hydra_current_labels, $
    current_labels

    IF n_elements(current_labels) EQ 0 THEN $
     hydra_define_structure,/cur_lab

    varb = current_labels(plotInfo.typeVector(0),1)

    descriptStr=descriptStr+varb
END

pro descriptor_hydra_events, plotInfo, descriptStr
   descriptStr='Events'
END

pro descriptor_hydra_other, plotInfo, descriptStr
    case plotInfo.typeVector(0) of
        0: type = 'ILT'
        1: type = 'MAG_LAT'
        2: type = 'MLT'
        3: type = 'R'
        4: type = 'L'
        5: type = 'Ephem Box'
        6: type = 'X_GSM'
        7: type = 'Y_GSM'
        8: type = 'Z_GSM'
        9: type = 'S/C Pot Best'
        10: type = 'S/C Pot Berkeley'
        11: type = 'S/C Pot Hydra'
        12: type = 'S/C Pot Goddard'
        13: type = 'Background Ele'
        14: type = 'Background Ion'
        15: type = 'PPA Background'
        16: type = 'PPA/DDEIS Background Comparison'
        17: type = 'Hydra Instrument Status'
        else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
    endcase
    descriptStr=descriptStr+type
END

pro descriptor_hydra_bfield, plotInfo, descriptStr
    case plotInfo.typeVector(0) of
        0: type = 'AutoSelect'
        1: type = 'low res'
        2: type = 'mid res'
        3: type = 'DDEIS res '
        4: type = 'PPA res '
        else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
    ENDCASE
    CASE plotInfo.typeVector(1) OF
       0: varb = 'Bmag_gsm'
       1: varb = 'Bx_gsm'
       2: varb = 'By_gsm'
       3: varb = 'Bz_gsm'
       4: varb = 'Bx_pay'
       5: varb = 'By_pay'
       6: varb = 'Bz_pay'
       7: varb = 'Btheta_pay'
       8: varb = 'Bphi_pay'
       9: varb = 'mag_pres'
       10:varb = 'Theta B'
       11:varb = 'Bmag(KHz)'
       ELSE: varb = 'Index: '+strtrim(plotInfo.typeVector(1),2)
    ENDCASE
    descriptStr=descriptStr+type+varb
END

pro descriptor_hydra_ticks, plotInfo, descriptStr
    code=plotInfo.typeVector(0)
    descriptStr='tick labels: '+strtrim(code,0)
END

pro descriptor_hydra_kptest, plotInfo, descriptStr
    case plotInfo.typeVector(0) of
        0: type='lr kp ele '
        1: type='lr kp ion '
        2: type='hr kp ele '
        else: type='Index: '+strtrim(plotInfo.typeVector(0),2)
    ENDCASE
    CASE plotInfo.typeVector(1) OF
       0: varb = 'Density'
       1: varb = 'Mean Energy'
       2: varb = 'Mean Energy Overplt'
       3: varb = 'Iretu'
       ELSE: varb = 'Index: '+strtrim(plotInfo.typeVector(1),2)
    ENDCASE
    descriptStr=descriptStr+type+varb
END

pro descriptor_hydra_fv, plotInfo, descriptStr
   case plotInfo.typeVector(0) of
       0: type='electrons'
       1: type='ions'
       else: type='EE'
   endcase
   descriptStr='fv slices '+type
END

pro descriptor_hydra_temp, plotInfo, descriptStr
   type= plotInfo.typeVector(0)
   if type le 2 then begin
       axis_str=['X','Y','Z']
       desc= 'ExB '+axis_str(type)+' GSM'
   endif else if type eq 3 then begin
       desc= 'ExB Mag'
   endif else if type lt 10 then begin
       dec_types=[ '', '', '', '', $ ; see above
                   'Ex GSM', $
                   'Ey GSM', $
                   'Ez GSM', $
                   'E mag', $
                   'Ex FAC', $
                   'Ey FAC', $
                   'Ez FAC', $
                   'Ez * Jz', $
                   'E dot J', $
                   'V34Raw', $
                   'SCPot34' $
                 ]
       desc= dec_types(type)
   endif else begin                   
       vecstr='['
       for i=0,1 do begin
           vecstr= vecstr + strtrim( plotInfo.typeVector(i),2 ) + ','
       endfor
       vecstr= vecstr + strtrim(plotInfo.typeVector(i),2) + ']'
       desc= vecstr
   endelse
   descriptStr='fv temp '+desc
END

;pro descriptor_hydra_simple_spec, plotInfo, descriptStr
;   sp= (['Ele','Ion'])( plotInfo.typeVector(0) )
;   det= strtrim( plotInfo.typeVector(1) and 2^0,2 )
;   for i=1,11 do det= det+strtrim( (ishft(plotInfo.typeVector(1),-i)) and 1,2 )
;   descriptStr='simple spec '+sp+' '+det
;END


;***************************************************************************
;*
;* PROCEDURE:
;*      PRO addpanel_polar_hydra
;*
;* DESCRIPTION:
;*	Calls the panel editor for this plottype and adds the plot to the
;*      panel window.
;*      using an instance of the PAPCO_PLOTINFO structure called "defaults"
;*      the default settings of the panel editor can be controlled.
;*      panelEditor must be set to the name of the panel editor routine
;*
;* INPUTS:
;*	event		event value of papco main window. This is
;*                      only used if there are plot sub_types,
;*                      for example see papcoadd_polar_hydra
;*
;* OUTPUTS:
;*   	none
;*
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	addpanel_polar_hydra
;*
;* MODIFICATION HISTORY:
;*
;***************************************************************************
pro addpanel_polar_hydra,event

   forward_function PAPCO_getPlotInfoStruct

   if polar_hydra_public() then begin
       x= { hydra_spec:1, $
            hydra_skew:2, $
            hydra_ppa:-1, $
            hydra_kp:-1, $
            hydra_tpp:-1, $
            hydra_spp:-1, $
            hydra_moments:-1, $
            hydra_current:-1, $
            hydra_other:3, $
            hydra_bfield:4, $
            hydra_events:5, $
            hydra_ticks:6, $
            hydra_fv:-1, $
            configure:7 }
   endif else begin
       x= { hydra_spec:1, $
            hydra_skew:2, $
            hydra_ppa:3, $
            hydra_kp:4, $
            hydra_tpp:5, $
            hydra_spp:6, $
            hydra_moments:7, $
            hydra_current:8, $
            hydra_other:9, $
            hydra_bfield:10, $
            hydra_events:11, $
            hydra_ticks:12, $
            hydra_fv:13, $
            configure:14 }
   endelse


   panelKind=''
   CASE Event.Value OF
       x.hydra_spec: BEGIN
           panelKind='hydra_spec'
           panelEditor='hydra_spec_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
           defaults.typeVector(3)= defaults.typeVector(3) or $
             long( getenv('hydra_spec_sc_potential_shift') )
           defaults.soptions[0]= ''
       END
       x.hydra_skew: BEGIN
           panelKind='hydra_skew'
           panelEditor='hydra_skew_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
           defaults.typeVector(3)= defaults.typeVector(3) or $
             long( getenv('hydra_spec_sc_potential_shift') )
       END
       x.hydra_ppa: BEGIN
           panelKind='hydra_ppa'
           panelEditor='hydra_ppa_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END
       x.hydra_kp: BEGIN
           panelKind='hydra_kp'
           panelEditor='hydra_kp_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END
       x.hydra_tpp: BEGIN
           panelKind='hydra_tpp'
           panelEditor='hydra_tpp_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END
       x.hydra_spp: BEGIN
           panelKind='hydra_spp'
           panelEditor='hydra_spp_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END       
       x.hydra_moments: BEGIN
           panelKind='hydra_moments'
           panelEditor='hydra_moments_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END
       x.hydra_current: BEGIN
           panelKind='hydra_current'
           panelEditor='hydra_current_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END
       x.hydra_other: BEGIN
           panelKind='hydra_other'
           panelEditor='hydra_other_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
       END
       x.hydra_bfield: BEGIN
           panelKind='hydra_bfield'
           panelEditor='hydra_bfield_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,7+16,0]
       END
       x.hydra_events: BEGIN
           panelKind='hydra_events'
           panelEditor='hydra_events_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,0,0,0]
           defaults.filename='/opt/hydra/papco/polar_hydra/discon.txt'
       END
       x.hydra_ticks: BEGIN
           panelKind='hydra_ticks'
           panelEditor='hydra_ticks_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[1,0,0,0]
       END
       x.hydra_fv: BEGIN
           panelKind='hydra_fv'
           panelEditor='hydra_fv_panel'
           defaults=PAPCO_getPlotInfoStruct()
           defaults.typeVector=[0,1,0,0]
       END
;       14: BEGIN
;           panelKind='hydra_temp'
;           panelEditor='hydra_temp_panel'
;           defaults=PAPCO_getPlotInfoStruct()
;           defaults.typeVector=[0,0,0,0]
;       END
;       15: BEGIN
;           panelKind='hydra_simple_spec'
;           panelEditor='hydra_simple_spec_panel'
;           defaults=PAPCO_getPlotInfoStruct()
;           defaults.typeVector=[0,4095,1,0]
;       END
;       15: begin
;           papco_Input, /DISABLE
;           dataman
;           papco_Input, /ENABLE   
;           return
;       end
       x.configure: begin
           papco_Input, /DISABLE
           papco_module_Configure, 'polar_hydra'
           papco_Input, /ENABLE
           return
       end       
   ENDCASE
   PAPCO_add_Plot, panelEditor, panelKind, initialPlotInfo=defaults

END

;***************************************************************************
;*
;* PROCEDURE:
;*      PRO editor_polar_hydra, plotNumber, newPlotData
;*
;* DESCRIPTION:
;*	This procedure calls the panel editor when called from
;*	PAPCO_EditPlot (papco_paneledit.pro).
;*
;* INPUTS:
;*	plotNumber	anInteger. 0<=plotNumber<=widgetData.numberOfPlots
;*			the index of the plot in widgetData.plotInfos.
;*
;* OUTPUTS:
;*   	newPlotData     the new structure returned by the panel editor
;* KEYWORDS:
;* 	none
;*
;* CALLING SEQUENCE:
;*	editor_polar_hydra, plotNumber, newPlotData
;*
;* MODIFICATION HISTORY:
;*
;***************************************************************************
PRO editor_hydra_spec, plotNumber, newPlotData
  COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_spec_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_skew, plotNumber, newPlotData
  COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_skew_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_ppa, plotNumber, newPlotData
  COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_ppa_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_kp, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_kp_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_tpp, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_tpp_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_spp, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_spp_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_kp_extra, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_kp_extra_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_tpphr, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_tpphr_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_sppion, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_sppion_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_moments, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_moments_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_current, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_current_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_other, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_other_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_bfield, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_bfield_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_events, plotNumber, newPlotData
COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_events_panel(plotInfo, $
                                  ACTION='Update '+plotInfo.panelKind, $
                                  GROUP=widgetData.main_base)
END


PRO editor_hydra_ticks, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_ticks_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_kptest, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_kptest_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_fv, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_fv_panel(plotInfo, $
        ACTION='Update '+plotInfo.panelKind, $
	GROUP=widgetData.main_base)
END

PRO editor_hydra_temp, plotNumber, newPlotData
   COMMON PLOT_COMPOSER, widgetData
   plotInfo=widgetData.plotInfos(plotNumber)
   newPlotData=hydra_temp_panel(plotInfo, $
                                ACTION='Update '+plotInfo.panelKind, $
                                GROUP=widgetData.main_base)
END

;PRO editor_hydra_simple_spec, plotNumber, newPlotData
;   COMMON PLOT_COMPOSER, widgetData
;   plotInfo=widgetData.plotInfos(plotNumber)
;   newPlotData= $
;     hydra_simple_spec_panel( plotInfo, $
;                              ACTION='Update '+plotInfo.panelKind, $
;                              GROUP=widgetData.main_base)
;END
