pro hydra_faverage_killed, id
   COMMON HYDRA_DRAWSLICE, sliceWidgetData
   r= temporary( sliceWidgetData )
end

pro user_hydra_faverage_hydra_spec_event, event
  widget_control, event.id, get_uvalue=uval
  child= widget_info( event.top, /child )
  widget_control, child, get_uvalue=state
  case uval of 
      'Control': begin
          if not widget_info( state.control_base, /valid_id ) then begin
              b= widget_base( state.control_parent, /row )
              b1= widget_base( b, /column )
              state.control_base= b
;              x= widget_button( b, value='Draw', uvalue='Draw' )
              x= cw_field( b1, title='f max: ', $
                           /float, value=state.f_max, uval='f_max', /return_ev)
              x= cw_field( b1, title='f min: ', $
                           /float, value=state.f_min, uval='f_min', /return_ev)
              b1= widget_base( b, /column, /nonexclusive )
              x= widget_button( b1, value='Show Parl,Perp,-Parl', uval='show_all' )
              widget_control, x, set_button= state.show_all
              x= widget_button( b1, value='vs Velocity', uval='velocity' )
              widget_control, x, set_button= state.velocity  
          endif else begin
              widget_control, state.control_base, /destroy
          endelse
      end
      'Draw': user_hydra_faverage_hydra_spec
      'f_min': begin
          state.f_min=event.value
          redraw=1
      end
      'f_max': begin
          state.f_max=event.value    
          redraw=1
      end
      'show_all': begin
          state.show_all= event.select
          redraw=1
      end
      'velocity': begin
          state.velocity= event.select
          redraw=1
      end
      'Print': user_hydra_faverage_hydra_spec, /hc
      'Close': begin
          widget_control, event.top, /destroy
          return
      end
      'Help': begin
          xdisplayfile, papco_helpfile('user_hydra_faverage_hydra_spec.help'), $
            title='papco Online-Help', group=event.top      
      end
      else: begin
          message, 'uval not recognised: '+uval, /cont
      end
  end      
  widget_control, child, set_uvalue=state
  if keyword_set( redraw ) then user_hydra_faverage_hydra_spec

  return
end

PRO user_hydra_faverage_hydra_spec, panelNr, seconds, yValue, event=event, $
                                    erase_only=erase_only, hc=hc

   COMMON HYDRA_DRAWSLICE, sliceWidgetData
   COMMON PLOT_COMPOSER, widgetData
   common papco_hydra_slice_control, hydra_sliceWidgetData

   common time, xut1, xut2

   common hydra_spec_data, $
     data_context, $            ; selects current data set
     spec_header, $
     spec_data, $
     spec_aligned_data, $
     spec_perp_data, $
     spec_opposed_data, $
     hr_spec_data, $
     hr_spec_aligned_data, $
     hr_spec_perp_data, $
     hr_spec_opposed_data

   hc= keyword_set( hc )

   if n_elements( panelNr ) eq 0 then begin ; we've reentered this code
       panelNr= sliceWidgetData.panelNr
       seconds= sliceWidgetData.seconds
       yValue= sliceWidgetData.yValue
   endif

   thisPlot=widgetData.plotsDrawn(panelNr)
   type=thisPlot.typeVector  

   species= ([ -1,1 ])(type(0))

   if species eq -1 then $
     yrange_def= [ 1d-32,1d-24 ] $
   else $
     yrange_def= [ 1d-25,1d-20 ]
       
;   rebuild the widget and reset defaults if species changes
   if n_elements( sliceWidgetData ) gt 0 then begin
       if species ne sliceWidgetData.species then begin 
           widget_control, sliceWidgetData.base, /destroy
       endif   
   endif
   
   if hc then begin
       set_plot, 'ps'
       filename='hydra_faverage_hydra_spec.ps'
       device, filename=filename, xsize=7, ysize=7, yoffset=3.5, $
         /inches, /color
   endif else begin
;      create widget if it doesn't exist already.
       if n_elements( sliceWidgetData ) gt 0 then begin
           if Widget_Info( sliceWidgetData.base, /Valid_ID)  eq 0 then begin
               build_widget=1
           endif else begin
               build_widget=0
           endelse
       endif else begin
           build_widget=1
       endelse
       
       if build_widget then begin
           b= widget_base( title='hydra_faverage_slice', /col )
           child= widget_base( b ) 
           state= { control_parent:0L, $
                    control_base:0L, $
                    f_min:yrange_def(0), $
                    f_max:yrange_def(1), $
                    show_all:1, $
                    velocity:0 }         
           d= widget_draw( b, xsize=500, ysize=500 )
           b1= widget_base( b, /row )
           bu= widget_button( b1, value='Control', uvalue='Control' )
           bu= widget_button( b1, value='Help', uvalue='Help' )
           bu= widget_button( b1, value='Print', uvalue='Print' )
           bu= widget_button( b1, value='Close', uvalue='Close' )
           state.control_parent= widget_base(b) 
           widget_control, b, /realize
           widget_control, d, get_value=winidx
           sliceWidgetData= { base:b, $
                              winidx:winidx, $
                              panelNr:panelNr, $
                              seconds:seconds, $
                              yValue:yValue, $
                              species:species }
           xmanager, 'user_hydra_faverage_hydra_spec', b, cleanup='hydra_faverage_killed'
           widget_control, child, set_uvalue=state
       endif else begin
           wset, sliceWidgetData.winidx
       endelse
       sliceWidgetData.panelNr= panelNr
       sliceWidgetData.seconds= seconds
       sliceWidgetData.yValue= yValue
       
   endelse

   child= widget_info( sliceWidgetData.base, /child )
   widget_control, child, get_uvalue=state
   
   yrange= [ state.f_min, state.f_max ]

   convert_T90_to_date, xut1, year, doy, hour, minute, second, $
     month, cmonth, day_om

   date_str= string( year, format='(i4.4)' ) + $
     string( month, format='(i2.2)' ) + $
     string( day_om, format='(i2.2)' )
   
   if n_elements( hydra_sliceWidgetData ) eq 0 then begin
       hydra_sliceWidgetData= { hydra_sliceWidgetData_struct, $
                                type:fix(0) $
                              }       
   endif 

; check to see if it is necessary to load data.
   forward_function hyd_dc
   data_context= hyd_dc( thisPlot.typevector(1), thisPlot.typevector(2) )
   debye= spec_header( data_context ).options and 1L
   show_debye= type(3) and 1L
   
   if debye ne show_debye then begin
       widget_control, /hourglass
       erase, get_color_index('white')
       xyouts, 0.2, 0.3, 'Loading Data...', align=0.5, color=1, /norm, $
         charsize=1.6
       r_hydra_spec_new, data_context, options= type(3)
       debye= spec_header( data_context ).options and 1L
   endif


; set the panel window for the slice to full window

   !p.position=[0.15,0.15,0.9,0.9]

   if data_context lt 5 then begin
       if n_elements( spec_aligned_data ) gt 0 then begin
           if spec_data(0).time eq spec_aligned_data(0).time then show_all=1 else show_all=0
       endif else begin
           show_all=0
       endelse
   endif else begin
       if n_elements( hr_spec_aligned_data ) gt 0 then begin
           if hr_spec_data(0).time eq hr_spec_aligned_data(0).time then show_all=1 else show_all=0
       endif else begin
           show_all=0
       endelse
   endelse

;   if data_context gt 4 then show_all=0

   if show_all and state.show_all then begin
       if data_context lt 5 then data= spec_data else data= hr_spec_data
       color='black'
   endif else begin
       exe_str='data=' + spec_header(data_context).data
       r=execute( exe_str )      
       color= ( [ 'black', 'red', 'purple', 'blue' ] )(data_context mod 5)
   endelse
   
   color= get_color_index(color)
   black= get_color_index('black')
   white= get_color_index('white')
   

   t90= data(*).time + spec_header(data_context).start_time - xut1

; pick closest block
;  this is kludgy

   rvalid= where( data(*).mode ne 0 and $
                  ( ( data(*).species and type(0)+1 ) eq type(0)+1 ) )

   if rvalid(0) eq -1 then return
   
   dd= seconds - t90(rvalid)
   r= where(dd ge 0)
   if r(0) ne -1 then ishow = rvalid(r(n_elements(r)-1)) else return

   if dd(r(n_elements(r)-1)) gt 13.8 then return

   mode= data(ishow).mode

   energy= spec_header(data_context).mode_energy(*,mode-1)
   rspec= where( energy * species gt 0 )
   energy= species * energy( rspec )
   spectrum= data(ishow).spectrum(rspec)
   time= data(ishow).time + spec_header(data_context).start_time
   sc_pot= data(ishow).sc_pot

   if species eq -1 then specstr='Electron' else specstr='Ion'
   ctit='POLAR/HYDRA '+specstr+' Energy Spectrum'
   xtitle='Observed '+specstr+' Energy, eV'
   ytitle='distribution function'
   yst=yrange(0) & yen=yrange(1)

   onecount= spectrum*0.0+1.0
   
   detector_area= 0.242000D  
   solid_angle= 0.015300D
   delta_time= 0.02395830D      ; true for mode 41
   if species eq -1 then mass= 9.11d-28  else mass= 1.67d-24

   facv4= detector_area * solid_angle * delta_time * 0.06 * 0.5 * $
     ( energy * 2 * 1.6d-12 / mass )^2
   
   logf= spectrum/facv4
   onecount= onecount/facv4

   if state.velocity then begin
       v= sqrt( energy * 2 * 1.6d-12 / mass ) / 1e8
       energy= v
       if species eq -1 then begin
           xtitle= 'Velocity, 1000 km/s'
           xrange=[0,80]
       endif else begin
           xtitle= 'Velocity, 1000 km/s'
           xrange=[0,2]
       endelse           
       xlog=0
   endif else begin
       xtitle= 'Energy, eV'
       xrange=[1,20000]
       xlog=1
   endelse

   if show_debye then begin
       xtitle='Debye '+xtitle
   endif else begin       
       xtitle='Observed '+xtitle
   endelse

   r=where( spectrum eq 1e-20, n_nodata )
   if n_nodata gt 0 then spectrum(r) = -1

   circx= cos( findgen(21)/20 * 2 * !pi )
   circy= sin( findgen(21)/20 * 2 * !pi )
   usersym, circx, circy

   erase, get_color_index('white')
   !x.ticks=0
   !x.minor=0
   !y.ticks=0
   !y.minor=0   

   r=where( spectrum gt 0.01 )
   if r(0) ne -1 then begin
       plot,energy(r),logf(r),/nodata, $
         xtitle=xtitle,ytitle=ytitle, title=ctit, $
         xrange=xrange, xstyle=1, $
         yrange=[yst,yen], ystyle=1, $
         xlog=xlog, /ylog, $
         color= black, psym=-8
       oplot, energy(r),logf(r), color=color, psym=-8, thick=2
       oplot, energy, onecount, linestyle=1, color=black
   endif else begin
       plot, energy, onecount, linestyle=1, color=black
   endelse

   line= !d.y_ch_size / float( !d.y_size )
   if show_all and state.show_all then begin
       if data_context lt 5 then begin
           oplot, energy, spec_aligned_data(ishow).spectrum(rspec) / facv4, $
             psym=-8, color=get_color_index('red')
           xyouts, 0.64, 0.87-line*5, 'aligned', /norm, color=get_color_index('red')
           oplot, energy, spec_opposed_data(ishow).spectrum(rspec) / facv4, $
             psym=-8, color=get_color_index('blue')
           xyouts, 0.64, 0.87-line*6, 'opposed', /norm,color=get_color_index('blue')
           oplot, energy, spec_perp_data(ishow).spectrum(rspec) / facv4, $
             psym=-8, color=get_color_index('purple')
           xyouts, 0.64, 0.87-line*7, 'perp', /norm, color=get_color_index('purple')
       endif else begin
           oplot, energy, hr_spec_aligned_data(ishow).spectrum(rspec) / facv4, $
             psym=-8, color=get_color_index('red')
           xyouts, 0.64, 0.87-line*5, 'aligned', /norm, color=get_color_index('red')
           oplot, energy, hr_spec_opposed_data(ishow).spectrum(rspec) / facv4, $
             psym=-8, color=get_color_index('blue')
           xyouts, 0.64, 0.87-line*6, 'opposed', /norm,color=get_color_index('blue')
           oplot, energy, hr_spec_perp_data(ishow).spectrum(rspec) / facv4, $
             psym=-8, color=get_color_index('purple')
           xyouts, 0.64, 0.87-line*7, 'perp', /norm, color=get_color_index('purple')
       endelse
   endif else begin
       xyouts, 0.64, 0.87-line*5, /norm, $
         'Pitch-Angle filtered!c'+$
         'spectrograms not loaded.!c'+$
         '(Add aligned !cspectrogram panel)', $
         color=get_color_index('grey')
   endelse

   convert_t90_to_Date,time, year, day_oy, hour, min, sec, $
     month, cmonth, day_om 

; convert_t90_to_Date trucates the seconds rather than rounding them.
   start_time= hydra_hms( time, secformat='(f5.2)' )
   end_time= hydra_hms( time+spec_header(data_context).time_resolution, $
                        secformat='(f5.2)' )
   
   info1=string(day_om,cmonth,year,$
                format="('Date: ',i2.2,' ',a3,' ',i4.4,' ')")

   xyouts, 0.64, 0.87, info1, /normal, color=1
   xyouts, 0.64, 0.84, start_time+'-'+end_time, /normal, color=1
   
   if sc_pot gt 1e-31 then begin 
       potstr= strtrim( string(data(ishow).sc_pot,format="(f6.2)"),2 )
   endif else begin
       potstr= 'NV'
   endelse
   xyouts, 0.64, 0.81, /normal, color=1, $
     'S/C Pot: '+potstr

   if not debye then begin
       oplot, [1,1]*data(ishow).sc_pot, 10.^!y.crange, color=1, linestyle=1
       oplot, [1,1]*data(ishow).sc_pot-2, 10.^!y.crange, color=1, linestyle=1
   endif
; Replace these labels and include your plot! 

; user defined routine for plotting the slice included here. An example is in 
; $PAPCO_MODULES/panels&slices/crres_slices.pro
; You typically need to include the commons from the read routine, a way
; of finding the index of the data you want to plot using the time "seconds"
; (in t90 format of course), plus a simple plot statement to plot the data.
; Two strings, info1 and info2, can be used to annotate the slice window
; by providing additional information, ie ephemeris data, etc.

   if hc then begin
       device, /close
       r= widget_message( ['Printed ',filename], /info )
       set_plot, 'x'
   endif
   return

END


