PRO r_hydra_ppa

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_ppa_data, $
    ppa_header, $
    ppa_l1_data, $
    ppa_l1_support, $
    ppa_spec_data, $
    ppa_aligned_data, $
    ppa_opposed_data, $
    ppa_perp_data, $
    ppa_skew_data

     my_name='r_hydra_ppa'
     module_name='HYDRA-ppa'
     
     IF n_elements( ppa_header ) EQ 0 THEN BEGIN 
        ppah1={ hydra_ppa_dum_header, $
                start_time:long(0), $
                end_time:long(0), $
                data_version:float(0), $
                reload_flag:fix(0), $
                ncalc:0, $
                recalc_flag:intarr(5) $ ; All,Aligned,Perp,Opposed,Skew
              }
        ppa_header = ppah1
     ENDIF
     ppa_header.start_time=xut1
     ppa_header.end_time=xut2
     ppa_header.reload_flag=1
     ppa_header.ncalc = 5
     ppa_header.recalc_flag = 1

     forward_function convert_date_to_t90
     
     get_err_no=0
     get_err_msg= my_name +': data-file read succesfully'

; read data files for time period
   num_files_read = 0
   time=xut1
   while time-1 lt xut2 do begin
       day_start= time / 86400 * 86400
       start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
       end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
       end_time= end_time - day_start 
       convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om       
       date_str=string(year,month,day_om,format="(i2.2,i2.2,i2.2)")       

       if start_time ne end_time then begin
           r_hydra_ppa_oneday, date_str, start_time, end_time, data_values, data_support
           
           if get_err_no eq 0 then BEGIN
              num_files_read = num_files_read + 1
              data_values(*).time= $
               data_values(*).time + ( day_start - xut1 )
              IF (num_files_read EQ 1) THEN BEGIN
                 data_buf = [data_values]
              ENDIF ELSE BEGIN
                 data_buf = [data_buf,data_values]
              ENDELSE

           endif       
       ENDIF

       time=day_start+86400          ; prepare to read next day
   endwhile
   
   if (n_elements(data_buf) gt 0) then BEGIN
      ppa_l1_data = data_buf
      ppa_l1_support = data_support
      get_err_no=0              ; all's well
   endif else begin
      get_err_no=2
      print,get_err_msg
      return
   endelse
   
   print,'Read '+module_name+': done'
   
   return
end


pro r_hydra_ppa_oneday, date_str, start_time, end_time, data_values, data_support

   common  get_error, get_err_no, get_err_msg
   common hydra_ppa_data, $
    ppa_header, $
    ppa_l1_data, $
    ppa_l1_support, $
    ppa_spec_data, $
    ppa_aligned_data, $
    ppa_opposed_data, $
    ppa_perp_data, $
    ppa_skew_data

   myname= 'r_hydra_ppa_oneday'
   
   f= hydra_findfile( '19'+date_str, /ppal1 )

   if (f NE '') then begin
      message, 'Opening '+f+'...',/cont
      cdf = cdf_open(f)
      n= strlen(f)
      ppa_header.data_version= float( strmid( f, n-8, 4 ))
   endif else begin
      return
   ENDELSE
   
   cdf_control, cdf, variable='BLOCK_TIME', get_var_info=r
   cdf_varget, cdf, 'BLOCK_TIME', epoch, rec_count=r.maxrec+1
   time = (epoch MOD 86400000)/1000.

   rec_start = ( where( time ge start_time ) )(0)
   if rec_start(0) eq -1 then begin
      get_err_msg= myname+': No data found after start_time '
      print, get_err_msg
      get_err_num = 1
      return
   ENDIF
      
   rec_stop = ( where( time GE end_time ) )(0)
   IF rec_stop(0) EQ -1 THEN BEGIN
      message, 'Defaulting rec_stop to last record',/cont
      rec_stop = r.maxrec
   ENDIF

   rec_count = rec_stop - rec_start + 1

; Which mode are we in?
   cdf_varget, cdf, 'BLOCK_MODE', block_mode, $
    rec_start=rec_start, rec_count=rec_count
   
   IF (min(block_mode) EQ max(block_mode) AND min(block_mode) EQ 1) THEN BEGIN

      index = 0

      CDF_VARGET, cdf, 'NHBINS', nbin, $
       rec_start = index, rec_count = 1
      CDF_VARGET, cdf, 'NLEVELS', nen, $
       rec_start = index, rec_count = 1

;      nbin = 120
;      nen = 36

      data_values1= { hydra_ppa01_dum_data, $
                      time:0.0, $
                      dt:0.0, $
                      counts:intarr(nbin,nen), $
                      vt:fltarr(nbin,nen) $
                    }
      
      data_values = replicate( data_values1, rec_count )
      data_support = {nbin:0,nen:0,t_meas:0.0,overflow_divisor:0.0,$
                      energy:fltarr(nen), $
                      alpha:fltarr(nbin),time_offset:fltarr(nen), $
                      width:lonarr(nbin)}
      
      CDF_VARGET, cdf, 'C_HIST_01', counts, $
       rec_start = rec_start, rec_count = rec_count
      CDF_VARGET, cdf, 'PROB_01', prob, $
       rec_start = rec_start, rec_count = rec_count
      
   ENDIF ELSE IF (min(block_mode) EQ max(block_mode) AND $
                  min(block_mode EQ 40)) THEN BEGIN

      index = 1      

      CDF_VARGET, cdf, 'NHBINS', nbin, $
       rec_start = index, rec_count = 1
      CDF_VARGET, cdf, 'NLEVELS', nen, $
       rec_start = index, rec_count = 1

;      nbin = 160
;      nen = 16

      
      data_values1= { hydra_ppa40_dum_data, $
                      time:0.0, $
                      dt:0.0, $
                      counts:intarr(nbin,nen), $
                      vt:fltarr(nbin,nen) $
                    }

      data_values = replicate( data_values1, rec_count )
      data_support = {nbin:0,nen:0,t_meas:0.0,overflow_divisor:0.0, $
                      energy:fltarr(nen), $
                      alpha:fltarr(nbin),time_offset:fltarr(nen), $
                      width:lonarr(nbin)}

      CDF_VARGET, cdf, 'C_HIST_40', counts, $
       rec_start = rec_start, rec_count = rec_count
      CDF_VARGET, cdf, 'PROB_40', prob, $
       rec_start = rec_start, rec_count = rec_count

   ENDIF ELSE BEGIN

      get_err_no = 1
      get_err_msg = myname+': Not able to handle multiple modes'
      cdf_close, cdf
      return

   ENDELSE

; Extract the time and support data

   CDF_VARGET, cdf, 'BLOCK_TIME', time, $
    rec_start = rec_start, rec_count = rec_count
   time = (time MOD 86400000)/1000.
   CDF_VARGET, cdf, 'BLOCK_DT', dt, $
    rec_start = rec_start, rec_count = rec_count
;      dt = fltarr(rec_count) + 82.8
;      dt = fltarr(rec_count) + 49.1
   
   CDF_VARGET, cdf, 'T_MEAS', t_meas, rec_count = 1
   CDF_VARGET, cdf, 'OVERFLOW_DIVISOR', overflow_divisor, rec_count= 1
   CDF_VARGET, cdf, 'ENERGY', energy, rec_start=index, rec_count=1
   CDF_VARGET, cdf, 'ALPHA', alpha, rec_start=index, rec_count=1
   CDF_VARGET, cdf, 'TIME_OFFSET', time_offset, rec_start=index, rec_count=1
   CDF_VARGET, cdf, 'WIDTH', width, rec_start=index, rec_count=1
   cdf_close,cdf
   
; RECONSTRUCT THE VIEWING TIME, vt
;                     prob is just the probability for
;                     PPA1 only, not multiplied by measuring time and
;                     actually 4 times larger than the actual
;                     probability because of the way we accounted for
;                     the counting_time_weight.  Also, there could
;                     be overflow counts which can be recovered. Define
;                     vt to be the viewing time (in seconds) for both 
;                     PPA1 and PPA2, after correcting for all of thee above.
   
;  Resurrect the overflow counts
   prob = float(prob)           ; Make it a float since we're going to multiply
   over = where(prob LT 0.)
   IF (over(0) NE -1) THEN prob(over) = prob(over)*overflow_divisor*(-1.)
   
   vt = fltarr(nbin,nen,rec_count)
   FOR ll = 0, long(nbin/2.)-1 DO BEGIN 
      vt(ll,*,*) = prob(ll,*,*) + prob(nbin-1-ll,*,*)
      vt(nbin-1-ll,*,*) = vt(ll,*,*)
   ENDFOR 
   vt = vt*t_meas/4.            ; Factor of 4 is because of counting_time_weight
   
; Define the support data
   data_support.nbin = nbin
   data_support.nen = nen
   data_support.t_meas = t_meas
   data_support.overflow_divisor = overflow_divisor
   data_support.energy = energy(0:nen-1)
   data_support.alpha = alpha(0:nbin-1)
   data_support.time_offset = time_offset(0:nen-1)
   data_support.width = width(0:nbin-1)

; Define the data
   r = lindgen(rec_count)
   data_values(r).time = reform(time)
   data_values(r).dt = reform(dt)
   data_values(r).counts = counts
   data_values(r).vt = vt

;expand this out to the 256 buckets using the widths? Not needed since we're 
;ulitmately going to average/sum over pitch-angle

; Sort the energy array to be monotonically increasing
   sorted =  sort(data_support.energy)
   data_support.energy = data_support.energy(sorted)
   data_support.time_offset = data_support.time_offset(sorted)
   data_values(*).counts(*,*) = data_values(*).counts(*,sorted)
   data_values(*).vt(*,*) = data_values(*).vt(*,sorted)

   return

END
