PRO calc_hydra_ppa_spec,scpot_time, scpot, bcor=bcor,vtcor=vtcor,yticks=yticks,ytickv=ytickv, $
                        ylog_init=ylog_init, ytickname=ytickname

common time, xut1,xut2          ;common time limits in T90
common coordinateSystems, plotted_x, plotted_y
                                ;info on coords, used by mouse
                                ;                   functions   
COMMON hydra_ppa_data, $
  ppa_header, $
  ppa_l1_data, $
  ppa_l1_support, $
  ppa_spec_data, $
  ppa_aligned_data, $
  ppa_opposed_data, $
  ppa_perp_data, $
  ppa_skew_data

data = ppa_l1_data
support = ppa_l1_support

dxut= xut2-xut1                 ; How many seconds of data are in the buffer
t_ssxut1 = data.time + ( ppa_header.start_time - xut1 ) ; time in seconds since xut1
rvis= where( t_ssxut1 ge 0 and t_ssxut1 le dxut, nvis )
if nvis lt 2 then begin
    plotted_x = !x
    plotted_y = !y
    print, 'calc_hydra_ppa_spec: no data in interval'
    stop
endif

; zdat definition
if (vtcor) then begin
    IF (bcor) THEN zdat = reform(data(rvis).cps_tot_mbg) ELSE $
      zdat = reform(data(rvis).cps_tot)
endif else begin
    if (bcor) then zdat = reform(data(rvis).counts_tot_mbg) else $
      zdat = reform(data(rvis).counts_tot)
endelse

; Default energy definition
energy = support.energy

; Sort the energies to be monotonically increasing
sorted = sort(energy)
energy = energy(sorted)
zdat = zdat(sorted,*)           ; Still [nen,ntime], transposed below

; As a first look, just butt up the energies next to each other
e1= lindgen(n_elements(energy))
n=n_elements(e1)-1
de= e1(n) - e1(n-1)
e2= [e1(1:*),e1(n)+de ]
eout= reform([ e1, e2], n_elements(e1), 2 )

uniq_inds = uniq(energy)
if (n_elements(uniq_inds) le 30) then tickinds = uniq_inds else $
  tickinds = where(e1 mod 2 eq 0) ; Every other energy level
yticks = n_elements(tickinds)-1
ytickv = e1(tickinds)
ytickname = string(energy(tickinds),'(f7.2)')
ylog_init=0

; Map the spacecraft potential into this weird y-space in order to
; overplot it on top of the PPA spectrogram
hyd_access_get_timetags, timetags, $
  'sc_potential', gen_time(xut1, /t90), gen_time(xut2, /t90)
hyd_access, timetags, 'time_bin_start_t90', sctime_t90
hyd_access, timetags, 'sc_potential', scpot_eV

t_ssxut1 = sctime_t90 - xut1    ; time in seconds since xut1
rv = where( t_ssxut1 ge 0 and t_ssxut1 le dxut, nv )
if (nv ge 2) then begin
    scpot_time = t_ssxut1(rv)
    scpot = interpol(eout(uniq_inds,0),energy(uniq_inds),scpot_eV(rv))
endif else begin
    scpot_time = -1
    scpot = -1
endelse

; Old
;e1= alog10(energy)
;n=n_elements(e1)-1
;de= e1(n) - e1(n-1)
;e2= [e1(1:*),e1(n)+de ]
;eout= reform( 10^[ e1, e2], n_elements(e1), 2 )
;yticks = n_elements(eout(*,0))-1
;ytickv = reform(eout(*,0))
;ytickname = string(ytickv,'(f7.2)')
;ylog_init=1

;==========================================================
nen = n_elements(eout(*,0))
ntime = n_elements(data(rvis).time)

; Output structure
ppa_spec_data = {pfill:0.0, $
                 xdat:fltarr(ntime,2), $
                 ydat:fltarr(nen,2), $
                 zdat:fltarr(ntime,nen) $
                }
; Define the fill value
ppa_spec_data.pfill = support.pfill

; Define the zdat
ppa_spec_data.zdat = transpose(zdat)

; Define the xdat (time) in ssxut1 (seconds since xut1)
time = reform(data(rvis).time)
dt = reform(data(rvis).dt)
ppa_spec_data.xdat(*,0) = time + ( ppa_header.start_time - xut1 )
ppa_spec_data.xdat(*,1) = ppa_spec_data.xdat(*,0) + dt

; Define the ydat (energy)
ppa_spec_data.ydat = eout

return
END

