function callformat_example2, index, x, _extra=e
; The call format procedure is intended to provide a way to interface
; existing routines to the thumb_plot code. 

; The idea is given the plot index (identifies plot) and the x
; ordinate, generate a string to call your procedure.  In this example,
; a routine called hydra_colorplot is to be called, and it prints as its title
; the index number.  So, 
;    (index,x) --> [ callformat_example ] --> "hydra_colorplot, title='1', ..."
;
; Alternatively, this routine can do the plot and return '' so that no
; additional plotting is done.
;
; _extra=e is intended to allow future expansion of the 
; thumb_plot code without breaking existing callformat interfaces.  
; In the future this code may receive
; keywords like "/axis_above" or "row=row", for example. 

common depth, s
n= randomu(s)

if ( n lt .5 ) then begin
    r= "hydra_colorplot, dist(20)"
    n=n+1
endif else begin
    r= "thumb_plot, dist(2), callFormat='callformat_example2' "
    n=n-1
endelse
return, r

end
   
