function ceppad_get_types
   return, [ '' ]
end

function ceppad_get_list
   data_env_var='PO_CEP_IF_DIR'
   c_path=papco_getenv(data_env_var)
   dirsep='/'
   fln= c_path + dirsep + 'PO_CEP_RAL_*_*_*.DAT'
   f= findfile( fln )
   n= strlen( c_path + dirsep )
   files= strmid( f,n,100 )
   q= strpos( files, '.DAT' )
   dates= strarr(n_elements(files))
   date1= strarr(n_elements(files))
   for i=0,n_elements(files)-1 do begin
       date1(i)= strmid( files(i), q(i)-7, 7 )
       year= strmid( date1(i), 0, 4 )
       doy= strmid( date1(i), 4, 3 )
       jan1= julday( 1, 1, fix( year )>1)
       caldat, jan1+(doy-1), mon, day, iyear
       dates(i)= strtrim(mon,2)+'-'+strtrim(day,2)+'-'+strtrim(iyear,2)
   endfor
   list= dates+' '+files
   s= sort( date1 )
   return, list(s)
end

function cammice_get_types
   return, [ '' ]
end

function cammice_get_list
   data_dir='POLAR_CAMMICE_DATA_ARCHIVE'
   c_path=papco_getenv(data_dir)
   ext='.red'
   fln= c_path+'*'+ext
   f= findfile( fln )
   n= strlen( c_path )
   files= strmid( f,n,100 )
   q= strpos( files, ext )
   dates= strarr(n_elements(files))
   date1= strarr(n_elements(files))
   for i=0,n_elements(files)-1 do begin
       date1(i)= strmid( files(i), q(i)-8, 8 )
       year= strmid( date1(i), 0, 4 )
       mon= strmid( date1(i), 4, 2 )
       day= strmid( date1(i), 6, 2 )
       dates(i)= strtrim(mon,2)+'-'+strtrim(day,2)+'-'+strtrim(year,2)
   endfor
   list= dates+' '+files
   s= sort( date1 )
   return, list(s)
end

function hydra_get_types
   return, [ 'Survey', 'Level1', 'Calibration' ]
end

function hydra_get_type_list, type
   case type of
       'survey': begin
           data_dir='HYDRA_SURVEY_DATA_PATH'
           id='_sv_'
       end
       'level1': begin
           data_dir='HYDRA_LEVEL1_DATA_PATH'
           id='_dd_'
       end
       'calibration': begin
           data_dir='HYDRA_DDCAL_DATA_PATH'
           id='_ddcal_'
       end
   endcase
   c_path=papco_getenv(data_dir)
   dir_sep=':'
   c_path= str_sep( c_path, dir_sep )
   c_path=c_path(n_elements(c_path)-1)
   fln= c_path+'*'+id+'*.cdf'
   f= findfile( fln )
   n= strlen( c_path )
   files= strmid( f,n,100 )
   list= files
   s= sort( list )
   return, list(s)
end

function hydra_survey_get_list
   return, hydra_get_type_list( 'survey' )
end

function hydra_level1_get_list
   return, hydra_get_type_list( 'level1' )
end

function hydra_calibration_get_list
   return, hydra_get_type_list('calibration')
end

function timas_get_types
   return, ['']
end

function timas_get_list
   data_dir_env = 'TIMAS_LEVEL1_DATA_PATH'
   data_dir = getenv(data_dir_env)
   indir= data_dir
   IF strmid(indir, strlen(indir)-1, 1) NE '/' THEN $
     indir = indir+'/' 
   f = findfile(indir + 'po_h0_tim_' + '*' + '_v??.cdf', $
                 Count=count)
   n= strlen( indir )
   files= strmid( f,n,100 )
   return, files
end

function tide_get_types
   return, ['']
end

function tide_get_list
data_dir='tide_data'
   c_path=getenv(data_dir)
   f = findfile( c_path + '*' + '.idl', $
                 Count=count)
   n= strlen( c_path )
   files= strmid( f,n,100 )
   return, files
end

pro dataman_event, ev
   widget_control, ev.top, get_uvalue= widgetData   
   
   if ev.id eq widgetData.selectID then begin
       widget_control, widgetData.selectID, get_uvalue= modules
       widgetData.selected= strlowcase( modules( ev.index ) )
       exe= 'types= '+widgetData.selected+'_get_types()'
       r= execute( exe )
       if r eq 0 then types=''
       widget_control, widgetData.listID, set_value=['Getting List...']
       if types(0) ne '' then begin
           widget_control, widgetData.typesID, set_value=types
           widget_control, widgetData.typesID, set_uvalue=types
           widget_control, widgetData.typesbaseID, map=1
           exe= 'list= '+widgetData.selected+'_'+$
             strlowcase(types(0))+'_get_list()' 
       endif else begin
           widget_control, widgetData.typesID, set_value=['   ']           
           widget_control, widgetData.typesID, set_uvalue=['']           
           widget_control, widgetData.typesbaseID, map=1
           exe= 'list= '+widgetData.selected+'_get_list()' 
       endelse     
       r= execute( exe )
       if r(0) ne 1 then begin
           print, 'Call caused error: '+exe           
           list=['']
       endif       
       wait, 0.2
       widget_control, widgetData.listID, set_value=list
   endif

   if ev.id eq widgetData.typesID then begin
       widget_control, widgetData.typesID, get_uvalue=types
       widgetData.type= strlowcase( types( ev.index ) )
       if widgetData.type ne '' then $
         exe= 'list= '+widgetData.selected+'_'+$
         widgetData.type+'_get_list()' $
       else $
         exe= 'list= '+widgetData.selected+'_get_list()' 
       r= execute( exe )
       if r(0) ne 1 then begin
           print, 'Call caused error: '+exe           
           list=['']
       endif            
       widget_control, widgetData.listID, set_value=list
   endif
   widget_control, widgetData.baseID, set_uvalue=widgetData
end
   
pro dataman

; Purpose:  Visualize data availablilty and automate data retrieval
;
; Called from papco.  Needs each module's environment variables to be set.
;

b= widget_base( title='Data Manager', /row )

b1= widget_base( b,/column )    ; control buttons
widgetData= { dataman_struct, baseID:b, $
              selected:'', type:'' }

list=replicate(' ', 40)
listID= widget_list( b,value=list, ysize=15, xsize=50, $
                     uvalue='list' ) ; list output
widgetData= create_struct( widgetData, { listID:listID } )

modules= ['Hydra','Ceppad','Cammice','Timas','Tide']
selectID= widget_droplist( b1, value=modules, uvalue=modules )
widgetData= create_struct( widgetData, { selectID:selectID } )

b2= widget_base( b1, /column )
widgetData= create_struct( widgetData, { typesID:0L } )
widgetData= create_struct( widgetData, { typesbaseID:0L } )
widgetData.typesID= widget_droplist( b2, value=['     '],uvalue=['    '], $
                                     xsize=20 )
widgetData.typesbaseID= b2

widget_control, b, /realize, set_uvalue=widgetData

event= { top:0L, id:0L, index:0L }
event.top= widgetData.baseID
event.id= widgetData.selectID
event.index=0
dataman_event, event 

xmanager, 'dataman', b

end

