PRO dump_bfield,date_in,time1,time2,highres=highres,midres=midres,ultrares=ultrares, path=path

; AUTHOR: Pamela Puhl-Quinn, 12/17/97
; PURPOSE: Dump the magnetic field into an IDL save set for purposes
;          other than PAPCO

;                 date_in     = YYMMDD or YYYYMMDD
;                 time1,time2 =
;                 'HH:MM:SS','HH:MM',HHMMSS,HHMM,HH.HHH,H

   myname = 'dump_bfield'

   hydra_time_io,date_in,time1,fyear,fmonth,fday,fhour,fminute,fsecond
   hour = string(fhour,'(i2.2)')
   min = string(fminute,'(i2.2)')
   second = string(fsecond,'(i2.2)')
   datestr = date_in
   timestr1 =  hour+':'+min+':'+second
   start_time = time1*3600.

   hydra_time_io,date_in,time2,fyear,fmonth,fday,fhour,fminute,fsecond
   hour = string(fhour,'(i2.2)')
   min = string(fminute,'(i2.2)')
   second = string(fsecond,'(i2.2)')
   timestr2 =  hour+':'+min+':'+second
   end_time = time2*3600.
   
   IF (keyword_set(highres)) THEN BEGIN
      res_str = '27'
      hydtim = 1
      mfetim = 0
      Hz50 = 0
   ENDIF ELSE IF (keyword_set(midres)) THEN BEGIN
      res_str = '08'
      hydtim = 0
      mfetim = 1
      Hz50 = 0
   ENDIF ELSE IF (keyword_set(ultrares)) THEN BEGIN
      res_str = '54'
      Hz50 = 1
      hydtim = 0
      mfetim = 0      
   ENDIF ELSE BEGIN
      print, myname+': Must choose either /highres or /midres or /ultrares'
      stop
   ENDELSE

   IF (keyword_set(path)) THEN path = path ELSE path = '/home/ppq/F_AGU_97'

   print, 'Date: ',datestr
   print, 'Time1: ',timestr1+'  (',start_time,'  s)'
   print, 'Time2: ',timestr2+'  (',end_time,'  s)'
   print, 'Resolution: '+res_str+' Hz'
   print, 'Path: ',path

   f= hydra_findfile( datestr, /level1 )
   if (f NE '') then begin
      print, myname+': opening '+f+'...'
      cdf_l1 = cdf_open(f)
   endif else begin
      print, myname+': Level1 file not found'
      stop
   ENDELSE
   
;  check if high-resolution bfield vectors are available.
   cdf_control, cdf_l1, var='B_HIGH_RAW', get_var_info=r 
   IF n_elements( r ) GT 0 THEN BEGIN 
      IF r.maxrec GT -1 THEN BEGIN 
         print, myname+': High res. Bfield data IS avail. in the level1 file'
      ENDIF ELSE BEGIN
         print, myname+': High res. Bfield data not in level1 file'
         stop
      ENDELSE
   ENDIF ELSE BEGIN
      print, myname+': High res. Bfield data not in level1 file'
      stop
   ENDELSE
;  -- end check if high-resolution bfield vectors are available

   f= hydra_findfile( datestr, /ddcal )
   if (f NE '') then begin
      print, myname+': opening '+f+'...'
      cdf_cal = cdf_open(f)
      n= strlen(f)
      cal_data_version= strmid( f, n-8, 4 )
   endif else begin
      print, myname+': Level1 DDCAL file not found'
      stop
   ENDELSE

   file_str = path+'/'+datestr+'_bfield_'+res_str+'_ddcal'+cal_data_version+'.idlsav'

   print, 'Filename: ',file_str
   print, 'cdf_l1: ',cdf_l1
   print, 'cdf_cal: ',cdf_cal
   
   gen_bfield, cdf_l1, start_time=start_time, end_time=end_time, $
    /xyz, bx=bx_pay, by=by_pay, bz=bz_pay, time=t,  $
    fixed_payload=1, hydtim=hydtim, mfetim=mfetim, Hz50=Hz50, cdfcal=cdf_cal

   print, myname+': Saving data to ',file_str
   save, t, bx_pay, by_pay, bz_pay, filename=file_str

   cdf_close, cdf_l1
   cdf_close, cdf_cal
   
   
END





