pro hyd_ident, footprint, concise=concise, _extra=e
;   hydra_id(footprint) is printed if in presentation mode.
;     if concise string is not specified, then print
;     hydra_id(footprint) either way.

  draft= !d.name ne 'PS'
  id= hydra_id( footprint, draft=draft )

  if getenv( 'hydra_presentation_mode' ) eq '1' then begin
      return
  endif else begin
      if n_elements( concise ) eq 0 then begin
          string= id
      endif else begin
          string= concise
      endelse
  endelse
  string= strtrim( string,2 )
  xyouts, 0.99, !p.position(3), /normal, $
    string, charsize= !p.charsize*0.7, $
    orientation=-90., color=1
  
end

