PRO hydra_calc_b_alignment, vec, bvec, bvec_error, color_type

   COMMON papco_color_names

   vec = vec(0:2,*)
   bvec = bvec(0:2,*)
   bvec_error_angle = bvec_error*180./!pi

   nn = n_elements(bvec_error)
   color_type = lonarr(nn)
   max_alignment_angle = 30
   max_error_angle = 15
   
   FOR iii=0,nn-1 DO BEGIN

      vl = sqrt(total(vec(*,iii)^2))
      IF (vl EQ 0) THEN BEGIN
         color_type(iii) = white
         GOTO, skip_this
      ENDIF 
      bl = sqrt(total(bvec(*,iii)^2))
      dot = total(vec(*,iii)*bvec(*,iii))
      theta = acos(dot/vl/bl)*180./!pi
      IF (theta GT 90.) THEN theta = 180.-theta
      theta_min = theta - bvec_error_angle(iii)
      
      IF (bvec_error_angle(iii) LE max_error_angle) THEN BEGIN 
         IF (theta_min LE max_alignment_angle AND dot GE 0) THEN $
          color_type(iii) = red $
         ELSE IF (theta_min LE max_alignment_angle AND dot LT 0) THEN $ 
          color_type(iii) = cyan $
         ELSE IF (theta_min GT max_alignment_angle AND dot GE 0) THEN $
          color_type(iii) = yellow $
         ELSE IF (theta_min GT max_alignment_angle AND dot LT 0) THEN $
          color_type(iii) = yellow ; could make this green 
      ENDIF ELSE BEGIN
         color_type(iii) = white ; Don't know because B is so bad
      ENDELSE

      skip_this:
 
   ENDFOR

   return
END
