pro hydra_define_structure, mom_lab=$
                            mom_lab, cur_lab=cur_lab, ppa_lab=ppa_lab, $
                            tpphr_lab=tpphr_lab, kp_lab=kp_lab

  forward_function hydra_code_version

  IF keyword_set(mom_lab) THEN BEGIN ;*_*_*_*_*_*_*_*_*_*_*_*
     
     COMMON hydra_moments_labels, $
      moments_labels

; ********NOTE*******NOTE**********NOTE********NOTE***********
;  IF YOU CHANGE ANY OF THE LABEL DEFINITIONS BELOW, YOU MUST
;  ALSO CHANGE THE DATA VARIABLES IN p_hydra_moments.pro!!!!
;  THE FIRST INDEX OF moments_labels REFERS TO THE CASE NUMBER IN
;  p_hydra_moments.pro
; ********NOTE*******NOTE**********NOTE********NOTE***********
     
; How many plottable quantities?
     nplot = 60
     
     moments_labels = strarr(nplot,4)
     
; ORDER: Panel, Descriptor, Plot, Units

     moments_labels(0,*) = ['Density','Density','Density','cm!u-3!n']
     moments_labels(1,*) = ['Mean Energy','Mean Energy','Mean Energy','eV']
     moments_labels(2,*) = ['Mean Energy Oplt','Mean Energy Oplt',' ',' ']
     moments_labels(3,*) = ['ux_pay','ux_pay','U!dx!uPAY!n','km/s']
     moments_labels(4,*) = ['uy_pay','uy_pay','U!dy!uPAY!n','km/s']
     moments_labels(5,*) = ['uz_pay','uz_pay','U!dz!uPAY!n','km/s']
     moments_labels(6,*) = ['ux_gsm','ux_gsm','U!dx!uGSM!n','km/s']
     moments_labels(7,*) = ['uy_gsm','uy_gsm','U!dy!uGSM!n','km/s']
     moments_labels(8,*) = ['uz_gsm','uz_gsm','U!dz!uGSM!n','km/s']
     moments_labels(9,*) = ['u_mag','u_mag','U!dmag!n','km/s']
     moments_labels(10,*) = ['u_parl','u_parl','U!d!9#!x!n','km/s']
     moments_labels(11,*) = ['uperp_x_pay','uperp_x_pay','U!s!d!9x!x,x!n!r!uPAY!n','km/s']
     moments_labels(12,*) = ['uperp_y_pay','uperp_y_pay','U!s!d!9x!x,y!n!r!uPAY!n','km/s']
     moments_labels(13,*) = ['uperp_z_pay','uperp_z_pay','U!s!d!9x!x,z!n!r!uPAY!n','km/s']
     moments_labels(14,*) = ['uperp_x_gsm','uperp_x_gsm','U!s!d!9x!x,x!n!r!uGSM!n','km/s']
     moments_labels(15,*) = ['uperp_y_gsm','uperp_y_gsm','U!s!d!9x!x,y!n!r!uGSM!n','km/s']
     moments_labels(16,*) = ['uperp_z_gsm','uperp_z_gsm','U!s!d!9x!x,z!n!r!uGSM!n','km/s']
     moments_labels(17,*) = ['uperp_mag','u_perp_mag','!9!!!xU!d!9x!x!n!9!!!x','km/s']
     moments_labels(18,*) = ['kT_parl','kt_parl','kT!d!9#!x!n','eV']
     moments_labels(19,*) = ['kT_perp','kt_perp','kT!d!9x!x!n','eV']
     moments_labels(20,*) = ['P_parl','p_parl','P!d!9#!x!n','cgs']
     moments_labels(21,*) = ['P_perp','p_perp','P!d!9x!x!n','cgs']
     moments_labels(22,*) = ['Angyrotropy','angyrotropy','!sG!r/!s!dMOM!n',' ']
     moments_labels(23,*) = ['Anisotropy','anisotropy','Anisotropy',' ']
     moments_labels(24,*) = ['V_alf','v_alf','V!dA!n','km/s']
     moments_labels(25,*) = ['M_tot','m_tot','M_tot',' ']
     moments_labels(26,*) = ['M_parl','m_parl','M!d!9#!x!n',' ']
     moments_labels(27,*) = ['M_perp','m_perp','M!d!9x!x!n',' ']
     moments_labels(28,*) = ['S/C Pot.','sc_pot','S/C Potential','eV']
     moments_labels(29,*) = ['q_mag','q_mag','q!dmag!n','erg/cm!u2!n/s']
     moments_labels(30,*) = ['q_parl','q_parl','q!d!9#!x!n','erg/cm!u2!n/s']
     moments_labels(31,*) = ['q_perp_mag','q_perp_mag','q!d!9x!x,mag!n','erg/cm!u2!n/s']
     moments_labels(32,*) = ['qparl/B','qparl_over_bmag','q!d!9#!x!n/B','erg/cm!u2!n/s/nT']
     moments_labels(33,*) = ['Bx_pay','bx_pay','B!dx!uPAY!n','nT']
     moments_labels(34,*) = ['By_pay','by_pay','B!dy!uPAY!n','nT']
     moments_labels(35,*) = ['Bz_pay','bz_pay','B!dz!uPAY!n','nT']
     moments_labels(36,*) = ['Bx_gsm','bx_gsm','B!dx!uGSM!n','nT']
     moments_labels(37,*) = ['By_gsm','by_gsm','B!dy!uGSM!n','nT']
     moments_labels(38,*) = ['Bz_gsm','bz_gsm','B!dz!uGSM!n','nT']
     moments_labels(39,*) = ['B_mag','b_mag','B!dmag!n','nT']
     moments_labels(40,*) = ['Angle_bavg_bproxy','angle_bavg_bproxy','!7h!x!dB,Bproxy!n','degrees']
     moments_labels(41,*) = ['Cosangle_q_bavg','cosangle_q_bavg','Cos(!7h!x!dq,B!n)',' ']
     moments_labels(42,*) = ['Cosangle_u_bavg','cosangle_u_bavg','Cos(!7h!x!du,B!n)',' ']
     moments_labels(43,*) = ['Bavg_angle_cone','bavg_angle_cone','B_error_cone','degrees']
     moments_labels(44,*) = ['Diagonalization Status','diag_status','Diag. Status',' ']
     moments_labels(45,*) = ['-u_mag','-u_mag','-u!dmag!n','km/s']
     moments_labels(46,*) = ['-q_mag','-q_mag','-q!dmag!n','erg/cm!u2!n/s']
     
     moments_labels(47,*) = ['ux_gse','ux_gse','U!dx!uGSE!n','km/s']
     moments_labels(48,*) = ['uy_gse','uy_gse','U!dy!uGSE!n','km/s']
     moments_labels(49,*) = ['uz_gse','uz_gse','U!dz!uGSE!n','km/s']
     
     moments_labels(50,*) = ['qx_gsm','qx_gsm','q!dx!uGSM!n','erg/cm!u2!n/s']
     moments_labels(51,*) = ['qy_gsm','qy_gsm','q!dy!uGSM!n','erg/cm!u2!n/s']
     moments_labels(52,*) = ['qz_gsm','qz_gsm','q!dz!uGSM!n','erg/cm!u2!n/s']
     moments_labels(53,*) = ['qx_gse','qx_gse','q!dx!uGSE!n','erg/cm!u2!n/s']
     moments_labels(54,*) = ['qy_gse','qy_gse','q!dy!uGSE!n','erg/cm!u2!n/s']
     moments_labels(55,*) = ['qz_gse','qz_gse','q!dz!uGSE!n','erg/cm!u2!n/s']
     moments_labels(56,*) = ['HR Angyrotropy', 'hr angyrotropy', '!sG!r/'+'!dHR', ' ' ]
     moments_labels(57,*) = ['qnu_parl','qnu_parl','qnU!d!9#!x!n','!7l!xA/m!u2!n']
     moments_labels(58,*) = ['eflux_parl','eflux_parl','!7C!x!d!9#!x!n','erg/cm!u2!n/s']
     moments_labels(59,*) = ['eflux_parl_over_b','eflux_parl_over_b','!7C!x!d!9#!x!n/B','erg/cm!u2!n/s/nT']
 ENDIF                          ;*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*
 
 
 IF keyword_set(cur_lab) THEN BEGIN ;*_*_*_*_*_*_*_*_*_*_*_*
     
     COMMON hydra_current_labels, $
      current_labels

; ********NOTE*******NOTE**********NOTE********NOTE***********
;  IF YOU CHANGE ANY OF THE LABEL DEFINITIONS BELOW, YOU MUST
;  ALSO CHANGE THE DATA VARIABLES IN p_hydra_current.pro!!!!
;  THE FIRST INDEX OF current_labels REFERS TO THE CASE NUMBER IN
;  p_hydra_current.pro
; ********NOTE*******NOTE**********NOTE********NOTE***********
     
; How many plottable quantities?
     nplot = 50
     
     current_labels = strarr(nplot,4)
     
; ORDER: Panel, Descriptor, Plot, Units

; dU = U_ion - U_ele (perp/parl)
     current_labels(0,*) = ['dU_perp_mag','du_perp_mag','dU!s!d!9x!x!n!umag!n','norm!9?S!xT!de!n']
     current_labels(1,*) = ['dU_perp_x_pay','du_perp_x_pay','(dU!s!d!9x!x!n!ux!n)!dpay!n','norm!9?S!xT!de!n']
     current_labels(2,*) = ['dU_perp_y_pay','du_perp_y_pay','(dU!s!d!9x!x!n!uy!n)!dpay!n','norm!9?S!xT!de!n']
     current_labels(3,*) = ['dU_perp_z_pay','du_perp_z_pay','(dU!s!d!9x!x!n!uz!n)!dpay!n','norm!9?S!xT!de!n']
     current_labels(4,*) = ['dU_perp_x_gsm','du_perp_x_gsm','(dU!s!d!9x!x!n!ux!n)!dgsm!n','norm!9?S!xT!de!n']
     current_labels(5,*) = ['dU_perp_y_gsm','du_perp_y_gsm','(dU!s!d!9x!x!n!uy!n)!dgsm!n','norm!9?S!xT!de!n']
     current_labels(6,*) = ['dU_perp_z_gsm','du_perp_z_gsm','(dU!s!d!9x!x!n!uz!n)!dgsm!n','norm!9?S!xT!de!n']
     current_labels(7,*) = ['dU_parl','du_parl','dU!s!d!9#!x!n','norm!9?S!xT!de!n']
     
; J (perp/parl)
     current_labels(8,*) = ['J_perp_mag','j_perp_mag','!9!!!xJ!s!d!9x!x!n!9!!!x','!7l!xA/m!u2!n']
     current_labels(9,*) = ['J_perp_x_pay','j_perp_x_pay','(J!s!d!9x!x!n!ux!n)!dpay!n','!7l!xA/m!u2!n']
     current_labels(10,*) = ['J_perp_y_pay','j_perp_y_pay','(J!s!d!9x!x!n!uy!n)!dpay!n','!7l!xA/m!u2!n']
     current_labels(11,*) = ['J_perp_z_pay','j_perp_z_pay','(J!s!d!9x!x!n!uz!n)!dpay!n','!7l!xA/m!u2!n']
     current_labels(12,*) = ['J_perp_x_gsm','j_perp_x_gsm','(J!s!d!9x!x!n!ux!n)!dgsm!n','!7l!xA/m!u2!n']
     current_labels(13,*) = ['J_perp_y_gsm','j_perp_y_gsm','(J!s!d!9x!x!n!uy!n)!dgsm!n','!7l!xA/m!u2!n']
     current_labels(14,*) = ['J_perp_z_gsm','j_perp_z_gsm','(J!s!d!9x!x!n!uz!n)!dgsm!n','!7l!xA/m!u2!n']
     current_labels(15,*) = ['J_parl','j_parl','J!s!d!9#!x!n','!7l!xA/m!u2!n']

; Perpendicular current length scale
     current_labels(16,*) = ['Perp CLS','perp_cls','!9x!x Current !cLength Scale','km']
     current_labels(17,*) = ['Perp CLS_rgyro_ion','perp_cls_rgyro_ion','!9x!x Current !cLength Scale','r!dL!n!uion!n']
     current_labels(18,*) = ['Perp CLS_rgyro_ele','perp_cls_rgyro_ele','!9x!x Current !cLength Scale','r!dL!n!uele!n']
     current_labels(19,*) = ['Perp CLS_inert_ion','perp_cls_inert_ion','!9x!x Current !cLength Scale','c/!7x!x!dp!n!uion!n']
     current_labels(20,*) = ['Perp CLS_inert_ele','perp_cls_inert_ele','!9x!x Current !cLength Scale','c/!7x!x!dp!n!uele!n']

; Other length scales
     current_labels(21,*) = ['Rgyro_ion','rgyro_ion','r!dL!n!uion!n','km']
     current_labels(22,*) = ['Rgyro_ele','rgyro_ele','r!dL!n!uele!n','km']
     current_labels(23,*) = ['Inert_ion','inert_ion','c/!7x!x!dp!n!uion!n','km']
     current_labels(24,*) = ['Inert_ele','inert_ele','c/!7x!x!dp!n!uele!n','km']

     current_labels(25,*) = ['Total Pressure','total_pres','P!dtot!n=P!d!9x!x!n+P!dmagnetic!n','nPa']

     current_labels(26,*) = ['Total Particle Pressure','total_particle_pres','P=(P!d!9#!x!n+2P!d!9x!x!n)/3 ','nPa']

     current_labels(27,*) = ['Magnetic Pressure','total_mag_pres','P!dmagnetic!n','nPa']

     current_labels(28,*) = ['Parl. Particle Pressure','total_parl_pres','P!d!9#!x!n=P!d!9#!x!n!uele!n+P!d!9#!x!n!uion!n','nPa']

     current_labels(29,*) = ['Perp. Particle Pressure','total_perp_pres','P!d!9x!x!n=P!d!9x!x!n!uele!n + P!d!9x!x!n!uion!n','nPa']

     current_labels(30,*) = ['Total Anisotropy','total_anisotropy','A=P!d!9#!x!n/P!d!9x!x!n',' ']

     current_labels(31,*) = ['J_mag','j_mag','J!dmag!n','!7l!xA/m!u2!n']

     current_labels(32,*) = ['-J_mag','-j_mag','-J!dmag!n','!7l!xA/m!u2!n']

     current_labels(33,*) = ['J_x_gse','j_x_gse','J!dx!n!uGSE!n','!7l!xA/m!u2!n']
     current_labels(34,*) = ['J_y_gse','j_y_gse','J!dy!n!uGSE!n','!7l!xA/m!u2!n']
     current_labels(35,*) = ['J_z_gse','j_z_gse','J!dz!n!uGSE!n','!7l!xA/m!u2!n']
     current_labels(36,*) = ['J_x_gsm','j_x_gsm','J!dx!n!uGSM!n','!7l!xA/m!u2!n']
     current_labels(37,*) = ['J_y_gsm','j_y_gsm','J!dy!n!uGSM!n','!7l!xA/m!u2!n']
     current_labels(38,*) = ['J_z_gsm','j_z_gsm','J!dz!n!uGSM!n','!7l!xA/m!u2!n']
     current_labels(39,*) = ['PWI MCAB','pwi-mcab','PWI MCAB !cEnergy Density','nPa']
     current_labels(40,*) = ['PWI MCAE','pwi-mcae','PWI MCAE !cEnergy Density','nPa']
     current_labels(41,*) = ['PWI SFRA','pwi-sfra','PWI SFRA !cEnergy Density','nPa']
     current_labels(42,*) = ['PWI SFRB','pwi-sfrb','PWI SFRB !cEnergy Density','nPa']

; Parallel current length scale
     current_labels(43,*) = ['Parl CLS','parl_cls','!9#!x Current !cLength Scale','km']
     current_labels(44,*) = ['Parl CLS_rgyro_ion','parl_cls_rgyro_ion','!9#!x Current !cLength Scale','r!dL!n!uion!n']
     current_labels(45,*) = ['Parl CLS_rgyro_ele','parl_cls_rgyro_ele','!9#!x Current !cLength Scale','r!dL!n!uele!n']
     current_labels(46,*) = ['Parl CLS_inert_ion','parl_cls_inert_ion','!9#!x Current !cLength Scale','c/!7x!x!dp!n!uion!n']
     current_labels(47,*) = ['Parl CLS_inert_ele','parl_cls_inert_ele','!9#!x Current !cLength Scale','c/!7x!x!dp!n!uele!n']
     current_labels(48,*) = ['total_eflux_parl','total_eflux_parl','!7C!x!di,!9#!x!n+!7C!x!de,!9#!x!n','erg/cm!u2!n/s']
     current_labels(49,*) = ['total_eflux_parl_over_b','total_eflux_parl_over_b','(!7C!x!di,!9#!x!n+!7C!x!de,!9#!x!n)/B','erg/cm!u2!n/s/nT']

     
  ENDIF ;*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*  

  IF keyword_set(ppa_lab) THEN BEGIN
     
     COMMON hydra_ppa_labels, $
      ppa_labels
     
; ********NOTE*******NOTE**********NOTE********NOTE***********
;  IF YOU CHANGE ANY OF THE LABEL DEFINITIONS BELOW, YOU MUST
;  ALSO CHANGE THE DATA VARIABLES IN p_hydra_ppa.pro!!!!
;  THE FIRST INDEX OF ppa_labels REFERS TO THE CASE NUMBER IN
;  p_hydra_ppa.pro
; ********NOTE*******NOTE**********NOTE********NOTE***********
     
; How many plottable quantities?
;     nplot = 5
     nplot = 4

     ppa_labels = strarr(nplot,4)
     
; ORDER: Panel, Descriptor, Plot, Units

     ppa_labels(0,*) = ['Cor Counts (raw counts/view time, summed over all pitch-angles)','ppa-cor-cnts','All Pitch Angles',' ']
     ppa_labels(1,*) = ['Background(t) = min(Cor Counts(t,*))','ppa-bg-cor','PPA Cor Counts Background',' ']
     ppa_labels(2,*) = ['Raw Counts (summed over all pitch-angles)','ppa-raw-cnts','All Pitch Angles',' ']
     ppa_labels(3,*) = ['Background(t) = min(Raw Counts(t,*))','ppa-bg-raw','PPA Raw Counts Background',' ']

;     ppa_labels(1,*) = ['field aligned (pitch= 0-30 deg)','ppa-aligned','Aligned',' ']
;     ppa_labels(2,*) = ['perpendicular (pitch= 75-105)','ppa-perp','Perp',' ']
;     ppa_labels(3,*) = ['field opposed (pitch= 150-180)','ppa-opposed','Opposed',' ']
;     ppa_labels(4,*) = ['skew','ppa-skew','Skew',' ']

  ENDIF ;************************************************************

  IF (keyword_set(tpphr_lab)) THEN BEGIN 

     COMMON hydra_tpphr_labels, $
      tpphr_labels
     
; ********NOTE*******NOTE**********NOTE********NOTE***********
;  IF YOU CHANGE ANY OF THE LABEL DEFINITIONS BELOW, YOU MUST
;  ALSO CHANGE THE DATA VARIABLES IN p_hydra_tpphr.pro!!!!
;  THE FIRST INDEX OF tpphr_labels REFERS TO THE CASE NUMBER IN
;  p_hydra_tpphr.pro
; ********NOTE*******NOTE**********NOTE********NOTE***********
     
; How many plottable quantities?
     nplot = 35
     
     tpphr_labels = strarr(nplot,4)
     
; ORDER: Panel, Descriptor, Plot, Units
     
     tpphr_labels(0,*) = ['Density','densitybest','n!di!n','cm!u-3!n']
     tpphr_labels(1,*) = ['Density (Mode)','densitymode','n!di!n (Mode)','cm!u-3!n'] 
     tpphr_labels(2,*) = ['Mean Energy','meane','kT!di!n','eV']
     tpphr_labels(3,*) = ['<B> Angle Cone','b_angle_cone','<B> Angle Cone','nT']
     tpphr_labels(4,*) = ['Emax Patched','maxe','E!dmax!n Patched','eV']
     tpphr_labels(5,*) = ['Emin Patched','maxi','E!dmin!n Patched','eV']
     tpphr_labels(6,*) = ['Angle b/t parl e.v. and B','angle_parl','!7h!x!d!9#!x!n','degrees']
     tpphr_labels(7,*) = ['v_alf','valf','V!dA!n','km/s']
     tpphr_labels(8,*) = ['u_mag','umag','U!dmag!n','km/s']
     tpphr_labels(9,*) = ['u_parl','uparl','U!d!9#!x!n','km/s']
     tpphr_labels(10,*) = ['uperp_x_pay','uperpxpay','U!s!d!9x!x,x!n!r!uPAY!n','km/s']
     tpphr_labels(11,*) = ['uperp_y_pay','uperpypay','U!s!d!9x!x,y!n!r!uPAY!n','km/s']
     tpphr_labels(12,*) = ['uperp_z_pay','uperpzpay','U!s!d!9x!x,z!n!r!uPAY!n','km/s']
     tpphr_labels(13,*) = ['uperp_mag','uperpmag','U!d!9x!x,mag!n','km/s']
     tpphr_labels(14,*) = ['ux_pay','uxpaybest','U!dx!n!uPAY!n','km/s']
     tpphr_labels(15,*) = ['ux_pay (Mode)','uxpaymode','U!dx!n!uPAY!n (Mode)','km/s']
     tpphr_labels(16,*) = ['uy_pay','uypaybest','U!dy!n!uPAY!n','km/s']
     tpphr_labels(17,*) = ['uy_pay (Mode)','uypaymode','U!dy!n!uPAY!n (Mode)','km/s']
     tpphr_labels(18,*) = ['uz_pay','uzpaybest','U!dz!n!uPAY!n','km/s']
     tpphr_labels(19,*) = ['uz_pay (Mode)','uzpaymode','U!dz!n!uPAY!n (Mode)','km/s']
     tpphr_labels(20,*) = ['ux_gsm','uxgsmbest','U!dx!n!uGSM!n','km/s']
     tpphr_labels(21,*) = ['uy_gsm','uygsmbest','U!dy!n!uGSM!n','km/s']
     tpphr_labels(22,*) = ['uz_gsm','uzgsmbest','U!dz!n!uGSM!n','km/s']

     tpphr_labels(23,*) = ['kTparl','ktparlbest','kT!d!9#!x!n','eV']
     tpphr_labels(24,*) = ['kTparl (Mode)','ktparlmode','kT!d!9#!x!n (Mode)','eV']
     tpphr_labels(25,*) = ['kTperp','ktperpbest','kT!d!9x!x!n','eV']
     tpphr_labels(26,*) = ['kTperp (Mode)','ktperpmode','kT!d!9x!x!n (Mode)','eV']
     tpphr_labels(27,*) = ['P_parl','pparlbest','P!d!9#!x!n','ergs/cm!u3!n']
     tpphr_labels(28,*) = ['P_perp','pperpbest','P!d!9x!x!n','ergs/cm!u3!n']
     tpphr_labels(29,*) = ['Gyrotropy','gyrobest','Gyrotropy',' ']
     tpphr_labels(30,*) = ['Gyrotropy (Mode)','gyromode','Gyrotropy (Mode)',' ']
     tpphr_labels(31,*) = ['rchi2 (fit)','rchi2','!7v!dm!x!u2!n (fit)',' ']
     tpphr_labels(32,*) = ['npatch','npatch','npatch',' ']
     tpphr_labels(33,*) = ['nrealizations','nreal','nrealizations',' ']
     tpphr_labels(34,*) = ['Anisotropy','anisbest','Anisotropy',' ']

  ENDIF

  IF keyword_set(kp_lab) THEN BEGIN ;*_*_*_*_*_*_*_*_*_*_*_*
     
     COMMON hydra_kp_labels, $
      kp_labels

; ********NOTE*******NOTE**********NOTE********NOTE***********
;  IF YOU CHANGE ANY OF THE LABEL DEFINITIONS BELOW, YOU MUST
;  ALSO CHANGE THE DATA VARIABLES IN p_hydra_kp.pro!!!!
;  THE FIRST INDEX OF kp_labels REFERS TO THE CASE NUMBER IN
;  p_hydra_kp.pro
; ********NOTE*******NOTE**********NOTE********NOTE***********
     
; How many plottable quantities?
     nplot = 16
     
     kp_labels = strarr(nplot,4)
     
; ORDER: Panel, Descriptor, Plot, Units

     kp_labels(0,*) = ['n','den','n','cm!u-3!n']
     kp_labels(1,*) = ['kT','kt','kT','eV']
     kp_labels(2,*) = ['kT Oplt','ktoplt',' ',' ']
     kp_labels(10,*) = ['n Fit (low res. ele only)','denfit','n!dfit!n','cm!u-3!n']
     kp_labels(11,*) = ['kT Fit (low res. ele only)','ktfit','kT!dfit!n','eV']
     kp_labels(12,*) = ['Kurtosis (low res. ele only)','kurt','Kurt',' ']
     kp_labels(13,*) = ['Kurt. Blk. Frac. (low res. ele only)','KBF','kbf',' ']
     kp_labels(14,*) = ['n Hot (low res. ele only)','denhot','n!dhot!n',' ']
     kp_labels(15,*) = ['kT Hot (low res. ele only)','kthot','kT!dhot!n',' ']
     kp_labels(3,*) = ['dn/n','dnon','!7d!xn!ie!n/<n!ie!n>',' ']
     kp_labels(4,*) = ['dT/T','dtot','!7d!xT!ie!n/<T!ie!n>',' ']
     kp_labels(5,*) = ['<n>','avgn','<n!ie!n>','cm!u-3!n']
     kp_labels(6,*) = ['<kT>','avgt','<kT!ie!n>','eV']
     kp_labels(7,*) = ['Tmin,Tmax Angle','tangle','Tmin,Tmax Angle','deg']
     kp_labels(8,*) = ['-ln(Ni/Ne)',' ','e!7dU!x/kT!ie',' ']
     kp_labels(9,*) = ['delta scpot',' ','e!7dU!x','eV']

     
     




 endif

  return
end
