;==============================================================================
;
;  NAME:
;     
;     ddeis_energy_interpol
;
;  PURPOSE:
;     
;     This procedure interpolates measurements from the even DDEIS 
;     detector energies (box 2) to the odd DDEIS detector energies
;     (box 1).
;
;  ARGUMENTS:
;     
;     Input
;     -----
;
;     z_old (STRUCTURE):
;
;        an element of a structure array output by 'ddeis_block_process'
;     
;     Ouput
;     -----
;
;     z_new (STRUCTURE):
;
;        same format as 'z_old' above; contains data interpolated to
;        box 1 energies
;
;     file_flag (INTEGER):
;
;  USAGE:
;
;     IDL> ddeis_energy_interpol, z_old, z_new
;  
;  HISTORY:
;
;     VERSION 1.00 -- 1/21/98 -- Written, John C. Dorelli
;
;=============================================================================

PRO ddeis_energy_interpol, z_old, z_new

nseg = n_elements(z_old)

z_new = z_old

FOR i = 1, 6 DO BEGIN
    idx1 = 2*i-2
    idx2 = 2*i-1
    FOR j = 1, nseg DO BEGIN

    ; break time series for each segment into half-sweeps and 
    ; interpolate times

        FOR k = 1, long(2.*6./nseg) DO BEGIN
            
            idx3 = 16*(k-1)
            idx4 = 16*k-1
            energy1 = z_old(j-1).energy(idx3: idx4, idx1)
            energy2 = z_old(j-1).energy(idx3: idx4, idx2)

            time1 = z_old(j-1).time(idx3: idx4, idx1)
            time2 = z_old(j-1).time(idx3: idx4, idx2)

            phi1 = z_old(j-1).phi(idx3: idx4, idx1)
            phi2 = z_old(j-1).phi(idx3: idx4, idx2)

            thetab1 = z_old(j-1).thetab(idx3:idx4, idx1)
            thetab2 = z_old(j-1).thetab(idx3:idx4, idx2)

            phib1 = z_old(j-1).phib(idx3: idx4, idx1)
            phib2 = z_old(j-1).phib(idx3: idx4, idx2)

            alpha1 = z_old(j-1).alpha(idx3: idx4, idx1)
            alpha2 = z_old(j-1).alpha(idx3: idx4, idx2)

            z1 = z_old(j-1).z(idx3: idx4, idx1)
            z2 = z_old(j-1).z(idx3: idx4, idx2)

            time_new = interpol(time2, energy2, energy1)
            phi_new = interpol(phi2, time2, time_new)
            thetab_new = interpol(thetab2, time2, time_new)
            phib_new = interpol(phib2, time2, time_new)
            alpha_new = interpol(alpha2, time2, time_new)
            znew = interpol(z2, time2, time_new)
            
            z_new(j-1).energy(idx3: idx4, idx2) = $
              energy1
            z_new(j-1).time(idx3: idx4, idx2) = time_new
            z_new(j-1).phi(idx3: idx4, idx2) = phi_new
            z_new(j-1).phib(idx3: idx4, idx2) = phib_new
            z_new(j-1).alpha(idx3: idx4, idx2) = alpha_new
            z_new(j-1).z(idx3: idx4, idx2) = znew

        ENDFOR
    ENDFOR
ENDFOR

END
