PRO ddeis_fvis_3D, date, time, gzcoord, z

; prepare input to 'ddeis_block_process'

control1 = {$
             correct: 1, $
             potential: 1, $
             filter: [0., 10000., 0.1, 20000, 0., !pi], $
             ztype: 1, $
             nseg: 2}

; prepare input to 'ddeis_epa_avg.pro

control2 = {$
             enmin: 0.1, $
             enmax: 20000., $
             de: 0.06, $
             da: 4., $
             sigma: 1}

;prepare input to 'ddeis_epa_ratio'

control3 = {$
             zlow: 5, $
             binr: 0.05, $
             r0: 0., $
             r1: 2.}

; process one block of data

ddeis_block_get, date, time, block_data, mode_info, file_flag, _extra = e
IF NOT file_flag THEN BEGIN
    print, 'DDEIS_EPA_CUTS:  level1 file not found....'
    return
ENDIF
ddeis_block_process, block_data, mode_info, control1, z_ele, z_ion, err1
z = z_ele(0)

; bin average the data in energy pitch-angle space

ddeis_epa_avg, z, control2, epa_out

; compute ratios for gyrotropy ratio test

print, 'computing ratios....'
ddeis_epa_ratio, epa_out, control3, ratio_out
print, 'finished computing ratios....'
stop

; interpolate energies from one DDEIS box to the other

z_old = z_ele
ddeis_energy_interpol, z_old, z_new
z_ele = z_new

; transform data to 'gyro-z' coordinate system

z = z_ele(0)
ddeis_fp_to_gz, z, gz

; sort data onto speed shells

ddeis_shells, z, gz, z_en, gz_en

stop

END

