;	$Id: fitdata_loop.pro,v 1.1.1.1 2003/11/04 21:24:01 friedel Exp $	
;; This file contains an unsupported function which creates a file of
;; fit parameters for a given range of data.  See fitdata_plot.pro.
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO fitdata_loop, path, t0, tf

tfsep = str_sep(tf, ':')
tffloat = 3600.*float(tfsep(0))+60.*float(tfsep(1))+float(tfsep(2))

init_fitf, path, t0, state

state.select = 0
state.mode(state.select).dalph = 30.
;state.mode(state.select).dalph = 60.
seg_idx = state.mode(state.select).seg_idx
;state.mode(state.select).hres = 6
state.mode(state.select).hres = 1
state.winidx = 0
state.mode(state.select).fitrange(0) = 50.

;open file
result = pickfile(/write, get_path = path, $
                  filter = '*.fitdata', /fix_filter)
IF (result NE '') THEN BEGIN
    IF (strpos(result, '/') EQ -1) THEN BEGIN
        filename = path+result 
    ENDIF ELSE BEGIN
        filename = result
    ENDELSE
    IF (strpos(result, '.fitdata') EQ -1) THEN BEGIN
        filename = filename+'.fitdata'
        ret = widget_message('Filename must have '+$
                             '".fitdata" extention, '+$
                             'extension apended. ')
    ENDIF 
    openw, /get_lun, unit, filename, error = error, /append
    IF (error NE 0) THEN BEGIN
        print, 'Error opening file.', !err_string
        ret = widget_message(/error, 'Error opening file: '+$
                             !err_string)
    ENDIF ELSE BEGIN
        state.mode(state.select).filename = filename
        state.mode(state.select).fileunit = unit
    ENDELSE
ENDIF ELSE BEGIN
    print, 'Error in file name.'
    ret = widget_message(/error, 'Error in file name.')
ENDELSE

;plot current time
state.mode(state.select).next = 0
state.mode(state.select).prev = 0
wset, state.winidx
retval=fitf_plot(state, datatime = datatime)
state.mode(state.select).seg_idx = seg_idx


;loop over range
repeat begin

    IF (state.mode(state.select).seg_idx LT $
        state.mode(state.select).hres-1) THEN BEGIN
        
        state.mode(state.select).seg_idx = $
          state.mode(state.select).seg_idx+1
        state.mode(state.select).next = 0
        state.mode(state.select).prev = 0
        wset, state.winidx
        retval=fitf_plot(state, datatime = datatime)
    ENDIF ELSE BEGIN
        state.mode(state.select).seg_idx = 0
        state.mode(state.select).next = 1
        state.mode(state.select).prev = 0
        wset, state.winidx
        retval=fitf_plot(state, datatime = datatime)
    ENDELSE        

    timesep = str_sep(datatime(1), ':')
    time = 3600.*float(timesep(0))+60.*float(timesep(1))+float(timesep(2))
    print, 'time = ', time, 'tfinal = ', tffloat
endrep UNTIL (time GT tffloat)

;close file
close, state.mode(state.select).fileunit
free_lun, state.mode(state.select).fileunit
state.mode(state.select).fileunit = -1
state.mode(state.select).filename = ''


END
