;$Id: fitf_which_help.pro,v 1.1.1.1 2003/11/04 21:24:02 friedel Exp $
function fitf_which_help, fname, all=all
;+
; NAME:
;       which_help
;
; PURPOSE:
;       The purpose of this function is to find the path of a help file.
;
; CATEGORY:
;       hydra_fitf
;
; CALLING SEQUENCE:
;       helppath=which_help('helpfilename')
;
; INPUTS:
;       helpfilename:  Name of the help file which is being searched for.
;
; KEYWORD PARAMETERS:
;       all:   Not fully supported yet, keyword to look for multiple
;       instnace of a helpfile.
;
; OUTPUTS:
;       This function returns the full path to the helpfile.
;
; COMMON BLOCKS:
;       module_paths: Papco common block containing the path to all
;       registered modules.
;
; PROCEDURE:
;       The 'paths' variable in module_paths is searched for the
;       helpfile if it exists, otherwise the !path variable is searched.
;
; EXAMPLE:
;
;
;               F = fitf_which_help('fitf_control.help')
;
; Written by:   Eric E. Dors, 16 March 1999.
;
; MODIFICATION HISTORY:
;
;       Thu Apr 20 14:40:03 2000, Eric E. Dors
;       <edors@universe.lanl.gov>
;
;		Added paths+'papco_interface' to the searchpath list
;		of places to search for the help file.
;
;-

   COMMON module_paths

   IF n_elements(paths) NE 0 THEN BEGIN
       searchpath = paths+'plot_read/hydra_fitf/'+fname
       searchpath = [searchpath, paths+'papco_interface/'+fname]
   ENDIF ELSE BEGIN
       searchpath = !path+fname
   ENDELSE
   
   if n_params() eq 0 then stop, 'pro which, fname, all=all, file=file'
   once= not keyword_set(all)
   for i=0, n_elements( searchpath )-1 do begin
       f= findfile( searchpath[i] )
       if f(0) ne ''  then begin
           file=f 
           if (once) then goto, done
       endif
   endfor

   done:

   return, file
   
end
   
