;$Id: fitf_xyouts.pro,v 1.1.1.1 2003/11/04 21:24:02 friedel Exp $
PRO fitf_xyouts, x, y, output, compress = compress, bangCcnt = bangCcnt, $
                 remove_all = remove_all, _extra = e
;+
; NAME:
;       fitf_xyouts
;
; PURPOSE:
;       
;       This procedure facilitates multiple lines of output through the
;       xyouts procedure.
;
; CATEGORY:
;       
;       hydra_fitf
;
; CALLING SEQUENCE:
;       
;       fitf_xyouts, xpos, ypos, string, color=fg, bangCcnt=bangCcnt, 
;
; INPUTS:
;       xpos:  The x position to plot to.
;
;       ypos:  The y position to plot to.
;
;       string: The string to print.
;
; KEYWORD PARAMETERS:
;       compress:   swwitch to set if strcompress should be run
;                   before printing string.
;
;       remove_all: swwitch to remove all spaces with strcompress.
;
;       bangCcnt:   A counter which keeps track of the line number to
;                   be printed to.  This counter should be set to zero
;                   by the user the first time fitf_xyouts is called.
;                   It will be incremented by fitf_xyouts as more
;                   lines are written to the screen.
;
;       _extra:     Any other keywords which xyouts accepts.
;
; EXAMPLE:
;
;       IDL> bangCcnt = 0   ;reset the line counter
;       IDL> fitf_xyouts, 0.65, 0.93, line1, /normal, bangCcnt=bangCcnt, $
;                color=fg
;
;       IDL> fitf_xyouts, 0.65, 0.93, line2, /normal, bangCcnt=bangCcnt, $
;                color=fg
;
; Written by:   Eric E. Dors, 1 March 1998.
;
; MODIFICATION HISTORY:
;
;-

cr = ''
IF (n_elements(bangCcnt) EQ 1) THEN BEGIN
    FOR i = 1, bangCcnt DO cr = '!C' + cr
    bangCcnt = bangCcnt + 1
ENDIF 


IF keyword_set(compress) THEN BEGIN
    ostring = cr+strcompress(remove_all = remove_all, output)
ENDIF ELSE BEGIN
    ostring = cr+output
ENDELSE

xyouts, x, y, ostring, _extra = e



END
