pro hydra_footprint, header, string=footprint_string

   common papco_color_names

   if fix( getenv( 'hydra_presentation_mode' ) ) eq 1 then $
     return

   if n_elements( footprint_string ) eq 0 then begin       
       tags= tag_names( header )
       
       footprint_str= $
         'data:' + $
         strtrim( string(header.data_version,format="(f6.2)"), 2) 
       if ( where( tags eq 'READER_VERSION' ) )(0) ne -1 then begin
           footprint_str= footprint_str + ' reader:' + $
             strtrim( string(header.reader_version,format="(f6.2)"), 2) 
       endif
       if ( where( tags eq 'CALIBRATION_VERSION' ) )(0) ne -1 then begin
           footprint_str= footprint_str + ' !ccalibration:'+$
             strtrim( string(header.calibration_version,format="(f6.2)"), 2)
       endif else begin
           if ( where( tags eq 'RGAINS_VERSION' ) )(0) ne -1 then begin
               footprint_str= footprint_str + '!crgains:' + $
                 strtrim( string(header.rgains_version,format="(f6.3)"), 2)
           endif
           if ( where( tags eq 'IGAINS_VERSION' ) )(0) ne -1 then begin
               footprint_str= footprint_str + ' igains:' + $
                 strtrim( string(header.igains_version,format="(f6.3)"), 2)
           endif
       endelse
   endif 

   xyouts, 0.99, !p.position(3), /normal, $
     footprint_str, charsize= !p.charsize*0.7, $
     orientation=-90., color=black
   
   return
end
