pro hydra_footprint_new, survey=survey, ddeis_l1_cal=ddeis_l1_cal, $
                         code=code, notes=notes, string=footprint_str

   common papco_color_names

   if fix( getenv( 'hydra_presentation_mode' ) ) eq 1 then return

   if n_elements( footprint_str ) eq 0 then begin
       footprint_str=''
       if n_elements( survey ) gt 0 then $
         footprint_str= footprint_str+' sv:'+$
         strtrim(string(survey,format="(f6.2)"),2)
       if n_elements( ddeis_l1_cal ) gt 0 then $
         footprint_str= footprint_str+' l1cal:'+$
         strtrim(string(ddeis_l1_cal,format="(f6.2)"),2)
       if n_elements( code ) gt 0 then $
         footprint_str= footprint_str+' code:'+$
         strtrim(string(code,format="(f6.2)"),2)

       if n_elements( notes ) gt 0 then $
         footprint_str= footprint_str+' '+notes
   endif

   footprint_str= strtrim( footprint_str, 2 )
   xyouts, 0.99, !p.position(3), /normal, $
     footprint_str, charsize= !p.charsize*0.7, $
     orientation=-90., color=black

   return
end
