PRO fv_contour, x, y, z, del_t, fv_input, winidx, speed_low_meas, $
                xrawv, yrawv

COMMON papco_color_names
if n_elements( black ) eq 0 then begin
    black = !p.color
    red = !p.color
    blue = !p.color
    grey = !p.color
endif

!p.color=1

species_string = '!5POLAR/Hydra Electrons'
IF NOT fv_input.species.ele AND fv_input.species.ion THEN $
  species_string = '!5POLAR/Hydra Ions'
date = strtrim(fv_input.args.path, 1)

zmax = fv_input.control.zmax
zmin = fv_input.control.zmin
IF fv_input.control.autoscale THEN BEGIN
    zmax = max(z)
    zmin = min(z)
ENDIF

hr1 = long(del_t(0))
min1 = long(del_t(1))
sec1 = del_t(2)
hr2 = long(del_t(3))
min2 = long(del_t(4))
sec2 = del_t(5)

IF hr1 GE 10 THEN BEGIN
    hst1 = strtrim(hr1, 1)
ENDIF ELSE BEGIN
    hst1 = '0'+strtrim(hr1, 1)
ENDELSE
IF min1 GE 10 THEN BEGIN
    mst1 = strtrim(min1, 1)
ENDIF ELSE BEGIN
    mst1 = '0'+strtrim(min1, 1)
ENDELSE
IF sec1 GE 10 THEN BEGIN
    sst1 = string(sec1, format = '(f5.2)')
ENDIF ELSE BEGIN
    sst1 = '0'+string(sec1, format = '(f4.2)')
ENDELSE
IF hr2 GE 10 THEN BEGIN
    hst2 = strtrim(hr2, 1)
ENDIF ELSE BEGIN
    hst2 = '0'+strtrim(hr2, 1)
ENDELSE
IF min2 GE 10 THEN BEGIN
    mst2 = strtrim(min2, 1)
ENDIF ELSE BEGIN
    mst2 = '0'+strtrim(min2, 1)
ENDELSE
IF sec2 GE 10 THEN BEGIN
    sst2 = string(sec2, format = '(f5.2)')
ENDIF ELSE BEGIN
    sst2 = '0'+string(sec2, format = '(f4.2)')
ENDELSE

date_length = strlen(date)
IF date_length EQ 8 THEN BEGIN
    date1 = strmid(date, 0, 4)
    date2 = strmid(date, 4, 2)
    date3 = strmid(date, 6, 2)
ENDIF ELSE BEGIN
    date1 = strmid(date, 0, 2)
    date2 = strmid(date, 2, 2)
    date3 = strmid(date, 4, 2)
ENDELSE

date_string = date2+'-'+date3+'-'+date1

t1 = hst1+':'+mst1+':'+sst1
t2 = hst2+':'+mst2+':'+sst2

title1 = species_string
title2 = date_string+' '+t1+'-'+t2

xdata = fv_input.control.vxrange/1000.
ydata = fv_input.control.vyrange/1000.
ncon = fv_input.control.ncon
normpos = fv_input.control.normpos
hc = fv_input.control.hc

IF NOT hc THEN wset, winidx
IF hc THEN BEGIN
    set_plot, 'ps'
    filename = 'hydra_fv_'+fv_input.args.path+'_'+fv_input.args.t0+'.ps'
    device, xsize = 0.7*700./72., ysize = 0.7*700./72.*0.9, $
      /inches, xoffset = 1., yoffset = 3.5, $
      filename = filename, /color, bits=8
    cd, current=pwd
    message, 'Printing to file '+pwd+'/'+filename, /cont
ENDIF

erase

;IF hc THEN BEGIN
IF 0 THEN BEGIN
    blackp = 0
    bluep = 0
    redp = 0
ENDIF ELSE BEGIN
    blackp = black
    bluep = blue
    redp = red
ENDELSE

IF NOT fv_input.species.ele AND fv_input.species.ion THEN begin
    unitstr= '100 km/sec'
    units= 1d7
    xdata= xdata * 10
    ydata= ydata * 10
endif else begin
    unitstr= '1000 km/sec'
    units= 1d8
endelse
    
contour, z, x/units, y/units, $
  xrange = [xdata(0), xdata(1)], $
  yrange = [ydata(0), ydata(1)], $
  xstyle = 1, ystyle = 1, $
  levels = zmin+(zmax-zmin)*dindgen(ncon)/(ncon-1d0), $
  charsize = 1.2, /follow, position = normpos, /normal, $
  xtitle = '!5v!l!9#!5!n ('+unitstr+')', $
  ytitle = '!5v!l!9x!5!n ('+unitstr+')', $
  title = title1+'!c'+title2, max_val = 1d19, color=1, xticks=0, yticks=0

cx = -1.+2.*dindgen(100)/99.
circ_up = speed_low_meas/units*sqrt(1-cx^2)
circ_down = -speed_low_meas/units*sqrt(1-cx^2)
oplot, speed_low_meas/units*cx, circ_up
oplot, speed_low_meas/units*cx, circ_down

IF fv_input.control.data THEN BEGIN
   oplot, xrawv/units, yrawv/units, psym =  3, color = bluep
ENDIF
      
xaxis = replicate(0., 20)

oplot, xdata(0)+(xdata(1)-xdata(0))*dindgen(20)/19., xaxis, linestyle = 2, $
  color = 1
oplot, xaxis, xdata(0)+(xdata(1)-xdata(0))*dindgen(20)/19., linestyle = 2, $
  color = 1
arrow, !x.crange(1)-1, 0, !x.crange(1), 0, /data, /solid, hthick=3, color=red

xyouts, 0.80, 0.48, /norm, '!sB!r!a^', color=1, charsize=3

IF NOT hc THEN BEGIN
    polyfill, speed_low_meas/units*cx, circ_up, color = grey
    polyfill, speed_low_meas/units*cx, circ_down, color = grey
ENDIF ELSE BEGIN
    polyfill, speed_low_meas/units*cx, circ_up, color = grey
    polyfill, speed_low_meas/units*cx, circ_down, color = grey
ENDELSE

IF hc THEN BEGIN
    device, /close
;    spawn, 'lpr hydra_fv.ps'
    set_plot, 'x'
    r= widget_message( ['Print written to file ',pwd+'/'+filename ], /info )
ENDIF

END


