PRO fv_control, fv_input

COMMON control_info, control_id, winidx, state, $
  species_store, control_ele, control_ion

IF xregistered('fv_control') THEN return

control_base = widget_base(title = 'hydra_fv control panel', /row)
control_id = control_base
control_base1 = widget_base(control_base, /column)
control_base2 = widget_base(control_base, /column)

species_base = widget_base(control_base1, /frame, /column)
species_label = widget_label(species_base, value = 'Select species')
species_buttons = cw_bgroup(species_base, /exclusive, $
                            ['electrons', 'ions'], uvalue = 'species')

;zdata_base = widget_base(control_base1, /frame, /column)
;zdata_label = widget_label(zdata_base, value = 'Select data type')
;zdata_buttons = cw_bgroup(zdata_base, /exclusive, $
;                          ['distribution function', $
;                           'differential number flux', $
;                           'differential energy flux'], uvalue = 'zselect')

limits_ceiling = cw_fslider(control_base1, /frame, max = 20, min = -50., $
                            /drag, uvalue = 'zmax', edit = 1, $
                           value = fv_input.control.zmax)
limits_label = widget_label(limits_ceiling, $
                   value = 'Log_10 of maximum contour level (cgs)')

limits_floor = cw_fslider(control_base1, /frame, max = 20, min = -50, $
                          /drag, uvalue = 'zmin', edit = 1, $
                          value = fv_input.control.zmin)
limits_label = widget_label(limits_floor, $
                            value = 'Log_10 of minimum contour level (cgs)')

xbase = widget_base(control_base2, /frame, /column)
xrange_label = widget_label(xbase, $
                            value = 'Select v_perp range (km/sec)' )
xrange1_slider = cw_fslider(xbase, /frame, min = -80000., max = -1., $
                           /drag, uvalue = 'vxrange1', $
                            value = fv_input.control.vxrange(0), $
                            edit = 1)
x1label = widget_label(xrange1_slider, $
                       value = 'minimum')
xrange2_slider = cw_fslider(xbase, /frame, min = 1., max = 80000., $
                           /drag, uvalue = 'vxrange2', $
                            value = fv_input.control.vxrange(1), $
                            edit = 1)
x1labe2 = widget_label(xrange2_slider, $
                       value = 'maximum')

ybase = widget_base(control_base2, /frame, /column)
yrange_label = widget_label(ybase, $
                            value = 'Select v_parallel range (km/sec)')
yrange1_slider = cw_fslider(ybase, /frame, min = -80000., max = -1., $
                           /drag, uvalue = 'vyrange1', $
                            value = fv_input.control.vyrange(0), $
                            edit = 1)
ylabel1 = widget_label(yrange1_slider, $
                            value = 'minimum')
yrange2_slider = cw_fslider(ybase, /frame, min = 1., max = 80000., $
                           /drag, uvalue = 'vyrange2', $
                            value = fv_input.control.vyrange(1), $
                            edit = 1)
ylabel1 = widget_label(yrange2_slider, $
                            value = 'maximum')

abin_slider = cw_fslider(control_base1, /frame, min = 4, max = 180., $
                         /drag, uvalue = 'abin', edit = 1, $
                        value = fv_input.control.dalph)
abin_label = widget_label(abin_slider, $
                          value = 'Select pitch-angle bin size (deg)')

ebin_slider = cw_fslider(control_base1, /frame, min = 0.06, max = 1., $
                         /drag, uvalue = 'ebin', edit = 1, $
                        value = fv_input.control.den)
ebin_label = widget_label(ebin_slider, $
                          value = 'Select energy bin size (dE/E)')

lowcnt_slider = cw_fslider(control_base2, /frame, min = 0., max = 500, $
                           /drag, uvalue = 'lowcnt', edit = 1, $
                          value = fv_input.control.lowcnt)
lowcnt_label = widget_label(lowcnt_slider, $
                            value = 'Select low count threshold')

ncon_field = cw_field(control_base1, /frame, uvalue = 'ncon', /integer, $
                      title = 'Number of contours', $
                      value = fv_input.control.ncon, $
                     /return_events)

convect_base = widget_base(control_base2, /frame, /column)
convect_label = widget_label(convect_base, $
                             value = 'Electron convection correction')
convect_buttons = cw_bgroup(convect_base, /exclusive, $
                            ['enabled', 'disabled'], uvalue = 'convect')

nfrag_field = cw_field(control_base1, /frame, uvalue = 'nfrag', /integer, $
                       title = 'Number of sub-blocks', $
                       value = fv_input.control.hres, $
                       /return_events)

seg_idx_field = cw_field(control_base1, /frame, uvalue = 'seg_idx', /integer, $
                         title = 'Sub-block index', $
                         value = fv_input.control.seg_idx, $
                         /return_events)

close_button = widget_button(control_base1, value = 'close', uvalue = 'close')

widget_control, control_base, /realize
xmanager, 'fv_control', control_base, /modal

fv_input = state

END

