PRO fv_convert_time, time_string, time_float, $
                  string_to_float = string_to_float, $
                  float_to_string = float_to_string, $
                  round = round, $
                  stop = stop

IF (keyword_set(string_to_float) AND NOT keyword_set(float_to_string)) OR $
  (keyword_set(string_to_float) AND keyword_set(float_to_string)) OR $
  (NOT keyword_set(string_to_float) AND NOT keyword_set(float_to_string)) $
   THEN BEGIN
    length = strlen(time_string)
    IF length GT 8 THEN BEGIN
        hours = strmid(time_string, 0, 2)
        minutes = strmid(time_string, 3, 2)
        seconds = strmid(time_string, 6, 5)
    ENDIF ELSE BEGIN
        hours = strmid(time_string, 0, 2)
        minutes = strmid(time_string, 3, 2)
        seconds = strmid(time_string, 6, 2)
    ENDELSE

    hours_float = float(hours)
    minutes_float = float(minutes)
    seconds_float = float(seconds)

    time_float = hours_float*3600.+minutes_float*60.+seconds_float

ENDIF ELSE BEGIN
    hours = long(time_float/3600.)
    minutes = long((time_float-hours*3600.)/60.)
    seconds = time_float-hours*3600.-minutes*60.
    
    IF hours LT 10 THEN BEGIN
        hours_string = '0'+string(hours, format = '(i1)')
    ENDIF ELSE BEGIN
        hours_string = string(hours, format = '(i2)')
    ENDELSE

    IF minutes LT 10 THEN BEGIN
        minutes_string = '0'+string(minutes, format = '(i1)')
    ENDIF ELSE BEGIN
        minutes_string = string(minutes, format = '(i2)')
    ENDELSE

    IF seconds LT 10 THEN BEGIN
        seconds_string = '0'+string(seconds, format = '(f4.2)')
        IF keyword_set(round) THEN $
          seconds_string = '0'+string(long(seconds), format = '(i2)')
    ENDIF ELSE BEGIN
        seconds_string = string(seconds, format = '(f5.2)')
        IF keyword_set(round) THEN $
          seconds_string = string(long(seconds), format = '(i2)')
    ENDELSE

    time_string = hours_string+':'+minutes_string+':'+seconds_string
ENDELSE

IF keyword_set(stop) THEN stop

END
