PRO fv_plot, fv_input, window, seg_idx, fv_output, output = output, $
             noplot = noplot

COMMON init1, path_store, t0_store, block_data_store, mode_info_store, $
  blocknum_store
COMMON control_info, control_id, winidx, state, $
  species_store, control_ele, control_ion

@model_include

IF seg_idx GT fv_input.control.hres-1 THEN seg_idx = 0

fv_get_block, fv_input, blocknum, block_data, mode_info, file_flag

IF file_flag EQ 0 THEN BEGIN
    mode_info_store = 0
    block_data_store = 0
    t0_store = 0
    path_store = 0
    block_num_store = 0
    GOTO, finish
ENDIF

test = fv_input.control.test
zs = 0
species = -1
IF fv_input.control.dflux THEN zs = 1
IF fv_input.control.deflux THEN zs = 2
IF fv_input.species.ion AND NOT fv_input.species.ele THEN species = 1
dalph = fv_input.control.dalph
den = fv_input.control.den
lowcnt = fv_input.control.lowcnt
eta = mode_info.delta_time*mode_info.solid_angle* $
  mode_info.detector_area*0.06
ahigh = fv_input.control.ahigh
alow = fv_input.control.alow
ehigh = fv_input.control.ehigh
elow = fv_input.control.elow
enmin = 0.1
enmax = 20000.

calculate_angles, block_data, mode_info

IF NOT test THEN BEGIN
    correct_interpolate, block_data, mode_info
ENDIF ELSE BEGIN
    print, 'generating test counts....'
    test_counts, block_data, mode_info, species, f
    block_data.corrected_counts = block_data.counts
ENDELSE

calculate_f, block_data, mode_info
;block_data.f = f
; correct z_ele_to and z_ion_to for electron perpendicular bulk
; velocity

fv_zselect, block_data, mode_info, test, z_ele_to_tot, z_ion_to_tot, zs

IF species EQ 1 THEN BEGIN
    total_time1 = min(z_ion_to_tot.time_ion)
    total_time2 = max(z_ion_to_tot.time_ion)
ENDIF ELSE BEGIN
    total_time1 = min(z_ele_to_tot.time_ele)
    total_time2 = max(z_ele_to_tot.time_ele)
ENDELSE

nfrag = fv_input.control.hres
fv_fragment, z_ele_to_tot, z_ion_to_tot, nfrag, $
  z_ele_to_array, z_ion_to_array

; Determine whether we're in the originally selected block

fv_convert_time, fv_input.args.t0, time_float
old_block_idx_array = where(mode_info_store.rectime*3600. GT time_float)
old_block_idx = (old_block_idx_array(0)-1) > 0
new_block = 1
IF blocknum_store EQ old_block_idx THEN new_block = 0

IF new_block EQ 0 AND seg_idx EQ 0 THEN BEGIN
    total_time = total_time2-total_time1
    bin_size = total_time/(1d0*nfrag)
    time_offset = time_float-total_time1
;    print, 'FV_PLOT:  times:  ', total_time1, total_time2, time_float, $
    IF time_offset LT 0 THEN BEGIN
        seg_idx = 0 
        state.control.seg_idx = seg_idx
    ENDIF ELSE BEGIN
        seg_idx = long(time_offset/bin_size)
        IF seg_idx GT (state.control.hres-1) THEN BEGIN
            seg_idx = state.control.hres-1
        ENDIF
        state.control.seg_idx = seg_idx
    ENDELSE
ENDIF

;print, 'FV_PLOT:  seg_idx:  ', new_block, seg_idx

ngrid = 51
IF species EQ 1 THEN BEGIN
    ndata = z_ion_to_array(0).n_ion
ENDIF ELSE BEGIN
    ndata = z_ele_to_array(0).n_ele
ENDELSE

xarray = dblarr(nfrag, ngrid)
yarray = dblarr(nfrag, ngrid)
zarray = dblarr(nfrag, ngrid, ngrid)
start_time_array = dblarr(nfrag)
del_t_array = dblarr(nfrag)
xrawv_array = dblarr(nfrag, ndata*12)
yrawv_array = dblarr(nfrag, ndata*12)
dt_array = dblarr(nfrag, 6)
warning= strarr(nfrag)

FOR i = 1, nfrag DO BEGIN
    
    z_ele_to = z_ele_to_array(i-1)
    z_ion_to = z_ion_to_array(i-1)
    
    IF fv_input.control.convect THEN BEGIN
        date_str = strmid(fv_input.args.path, 0, 12)
        print, date_str, fv_input.args.path
        mom_file = hydra_findfile(date_str, /moments_all)
        IF mom_file NE '' THEN BEGIN
            convect = 1
            print, 'correcting for perpendicular electron convection....'
            extract_moments, fv_input.args.path, fv_input.args.t0, $
              60./3600., moments
            
            mom = moments(0)
            
            IF test THEN BEGIN
                mom.v = uc*[sin(thetauc)*cos(phiuc), $
                            sin(thetauc)*sin(phiuc), $
                            cos(thetauc)]
                mom.b_avg = bhat
            ENDIF
            
            z_ele_to_old = z_ele_to
            z_ion_to_old = z_ion_to
            
            fv_convect, z_ele_to_old, z_ion_to_old, mom, $
              z_ele_to_new, z_ion_to_new, test
            
            z_ele_to = z_ele_to_new
            z_ion_to = z_ion_to_new
        ENDIF ELSE BEGIN
            print, 'Could not find moments file....'
        ENDELSE    
    ENDIF
    
    IF species EQ 1 THEN BEGIN
        time1 = min(z_ion_to.time_ion)
        time2 = max(z_ion_to.time_ion)
    ENDIF ELSE BEGIN
        time1 = min(z_ele_to.time_ele)
        time2 = max(z_ele_to.time_ele)
    ENDELSE
    
    hr1 = long(time1/3600.)
    min1 = long((time1-3600.*hr1)/60.)
    sec1 = time1-3600.*hr1-min1*60.
    
    hr2 = long(time2/3600.)
    min2 = long((time2-3600.*hr2)/60.)
    sec2 = time2-3600.*hr2-min2*60.
    
    dt = [float(hr1), float(min1), float(sec1), $
             float(hr2), float(min2), float(sec2)]
    del_t = double(time2-time1)
    start_time = double(time1)
    
    fv_zavg, z_ele_to, z_ion_to, species, zavg2d, abar, ebar, $
      ndb2d, xraw, yraw, dalph*!pi/180., den, lowcnt, zs, eta, $
      ahigh, alow, ehigh, elow, nba, nblogE, enmax, enmin, err_zavg

    r= where(( z_ele_to.bflags and 4 ) eq 4, count )
    if count gt 0 then warning(i-1)= $
      '#01: Some B field angles interpolated from 8Hz measurements' else $
      warning(i-1)='#00: All okay'
    
    IF err_zavg THEN GOTO, finish
    
    fv_zbuck, zavg2d, abar, ebar, ndb2d, zavg1d, xavg1d, yavg1d, ndb1d, $
      nba, nblogE
    
; now xavg1d, yavg1d, zavg1d contain 1-D bin averaged
; buckshot data in energy-pitch-angle space
    
    fv_pitch_to_vel, species, xavg1d, yavg1d, zavg1d, vxgrid, vygrid, vzgrid, $
      speed_low_meas, xraw, yraw, xrawv, yrawv

    pitch_high= max( xraw, min=pitch_low )

    fv_grid, fv_input, vxgrid, vygrid, alog10(vzgrid+1d-50), triangles, x, y, z
          
    ngrid = n_elements(x)

    xarray(i-1, 0:ngrid-1) = x
    yarray(i-1, 0:ngrid-1) = y
    zarray(i-1, 0:ngrid-1, 0:ngrid-1) = z
    del_t_array(i-1) = del_t
    start_time_array(i-1) = start_time
    xrawv_array(i-1, 0:n_elements(xrawv)-1) = xrawv
    yrawv_array(i-1, 0:n_elements(yrawv)-1) = yrawv  
    dt_array(i-1, *) = dt
ENDFOR

x = xarray(seg_idx, 0:ngrid-1)
y = yarray(seg_idx, 0:ngrid-1)
z = zarray(seg_idx, 0:ngrid-1, 0:ngrid-1)
start_time = start_time_array(seg_idx)
del_t = del_t_array(seg_idx)
xrawv = xrawv_array(seg_idx, 0:n_elements(xrawv)-1)
yrawv = yrawv_array(seg_idx, 0:n_elements(yrawv)-1)
dt = dt_array(seg_idx, *)

x = reform(x, ngrid)
y = reform(y, ngrid)
z = reform(z, ngrid, ngrid)
xrawv = reform(xrawv, n_elements(xrawv))
yrawv = reform(yrawv, n_elements(yrawv))

IF NOT keyword_set(noplot) THEN noplot = 0

IF NOT noplot THEN BEGIN
    fv_contour, x, y, z, dt, fv_input, window, speed_low_meas, xrawv, yrawv
ENDIF

IF keyword_set(output) THEN BEGIN
    fv_output = {output, $
                 x: x, $
                 y: y, $
                 z: z, $
                 start_time: start_time, $
                 del_t: del_t, $
                 speed_low_meas: speed_low_meas, $
                 warning:warning(seg_idx), $
                 pitch_low:0., $
                 pitch_high:0. }
ENDIF
    
finish:

IF NOT file_flag THEN BEGIN
    if not keyword_set( output ) then begin
        print, 'Could not find level 1 file....'
        plot, [0, 1], /nodata, xstyle = 5, ystyle = 5
        xyouts, 0.5, 0.5, align = 0.5, 'Could not find level 1 file', $
          charsize = 1.5, color = 1
        return
    endif
ENDIF

IF err_zavg THEN BEGIN
    if not keyword_set( output ) then begin
        print, 'Filtered out all of the data....'
        plot, [0, 1], /nodata, xstyle = 5, ystyle = 5
        xyouts, 0.5, 0.5, align = 0.5, 'Filtered out all of the data', $
          charsize = 1.5, color = 1
        return
    endif
ENDIF

END


