PRO fv_zselect, block_data, mode_info, test, z_ele_to, z_ion_to, zs

nscan = mode_info.scan_length
ndet = 12

idx_ele = where(mode_info.energy(*, 0) LT 0)
idx_ion = where(mode_info.energy(*, 0) GT 0)

IF idx_ele(0) EQ -1 THEN BEGIN
    print, 'FV_ZSELECT:  No electron measurements found....'
    stop
ENDIF

IF idx_ion(0) EQ -1 THEN BEGIN
    print, 'FV_ZSELECT:  No ion measurements found....'
    stop
ENDIF

n_ele = n_elements(idx_ele)
n_ion = n_elements(idx_ion)

m_ele = 9.11d-28
m_ion = 1.67d-24

z_ele_to = {electrons, $
            time_ele: dblarr(n_ele), $
            theta_ele: fltarr(n_ele, ndet), $
            phi_ele: fltarr(n_ele, ndet), $
            thetab_ele: fltarr(n_ele, ndet), $
            phib_ele: fltarr(n_ele, ndet), $
            bvalid: intarr(n_ele), $
            bflags: intarr(n_ele), $
            alpha_ele: fltarr(n_ele, ndet), $
            energy_ele: fltarr(n_ele, ndet), $
            energy_ele_old: fltarr(n_ele, ndet), $
            z_ele: dblarr(n_ele, ndet), $
            dm_ele: bytarr(n_ele, ndet), $
            idx_ele: intarr(n_ele), $
            n_ele: 0 $
           }

z_ion_to = {ions, $
            time_ion: dblarr(n_ion), $
            theta_ion: fltarr(n_ion, ndet), $
            phi_ion: fltarr(n_ion, ndet), $
            thetab_ion: fltarr(n_ion, ndet), $
            phib_ion: fltarr(n_ion, ndet), $
            bvalid: intarr(n_ion), $
            bflags: intarr(n_ion), $
            alpha_ion: fltarr(n_ion, ndet), $
            energy_ion: fltarr(n_ion, ndet), $
            energy_ion_old: fltarr(n_ion, ndet), $
            z_ion: fltarr(n_ion, ndet), $
            dm_ion: bytarr(n_ion, ndet), $
            idx_ion: intarr(n_ion), $
            n_ion: 0 $
           }

species = intarr(nscan)
species(idx_ele) = -1
species(idx_ion) = 1
potential = block_data.sc_potential
IF test THEN potential = 0.
IF block_data.sc_potential_stat EQ 0 THEN potential = 0.

z_ele_to.n_ele = n_ele
z_ion_to.n_ion = n_ion

z_ele_to.bvalid = block_data.bvalid(idx_ele)
z_ion_to.bvalid = block_data.bvalid(idx_ion)
z_ele_to.bflags = block_data.bflags(idx_ele)
z_ion_to.bflags = block_data.bflags(idx_ion)

FOR i = 1, ndet DO BEGIN
    z_ele_to.alpha_ele(*, i-1) = block_data.alpha(idx_ele, i-1)
    z_ion_to.alpha_ion(*, i-1) = block_data.alpha(idx_ion, i-1)
    IF((i+1) MOD 2 EQ 0)THEN BEGIN
        z_ele_to.energy_ele(*, i-1) = $
          mode_info.energy(idx_ele, 0)*species(idx_ele)+ $
          potential*species(idx_ele)
        z_ele_to.energy_ele_old(*, i-1) = $
          mode_info.energy(idx_ele, 0)*species(idx_ele)
        z_ion_to.energy_ion(*, i-1) = $
          mode_info.energy(idx_ion, 0)*species(idx_ion)+ $
          potential*species(idx_ion)
        z_ion_to.energy_ion_old(*, i-1) = $
          mode_info.energy(idx_ion, 0)*species(idx_ion)
    ENDIF ELSE BEGIN
        z_ele_to.energy_ele(*, i-1) = $
          mode_info.energy(idx_ele, 1)*species(idx_ele)+ $
          potential*species(idx_ele)
        z_ele_to.energy_ele_old(*, i-1) = $
          mode_info.energy(idx_ele, 1)*species(idx_ele)
        z_ion_to.energy_ion(*, i-1) = $
          mode_info.energy(idx_ion, 1)*species(idx_ion)+ $
          potential*species(idx_ion)
        z_ion_to.energy_ion_old(*, i-1) = $
          mode_info.energy(idx_ion, 1)*species(idx_ion)
    ENDELSE
    z_ele_to.dm_ele(*, i-1) = block_data.datamask(idx_ele, i-1)
    z_ion_to.dm_ion(*, i-1) = block_data.datamask(idx_ion, i-1)
    z_ele_to.z_ele(*, i-1) = block_data.f(idx_ele, i-1)
    z_ion_to.z_ion(*, i-1) = block_data.f(idx_ion, i-1)
    z_ele_to.theta_ele(*, i-1) = block_data.theta_ele(i-1)
    z_ion_to.theta_ion(*, i-1) = block_data.theta_ion(i-1)
    z_ele_to.phi_ele(*, i-1) = block_data.phi_det(idx_ele, i-1)
    z_ion_to.phi_ion(*, i-1) = block_data.phi_det(idx_ion, i-1)
    z_ele_to.thetab_ele(*, i-1) = block_data.thetab(idx_ele)
    z_ion_to.thetab_ion(*, i-1) = block_data.thetab(idx_ion)
    z_ele_to.phib_ele(*, i-1) = (block_data.phib(idx_ele)+ $
      mode_info.phi_offset(idx_ele) +block_data.phase_start) MOD (2.*!pi)
    z_ion_to.phib_ion(*, i-1) = (block_data.phib(idx_ion)+ $
      mode_info.phi_offset(idx_ion) + block_data.phase_start) MOD (2.*!pi)
ENDFOR
z_ele_to.time_ele = double(block_data.time+ $
                           mode_info.time_offset(idx_ele))
z_ion_to.time_ion = double(block_data.time+ $
                           mode_info.time_offset(idx_ion))
IF(zs EQ 1)THEN BEGIN
    e_ele = z_ele_to.energy_ele*1.6d-19*1d7
    e_ion = z_ion_to.energy_ion*1.6d-19*1d7
    z_ele_to.z_ele = 2.*e_ele*z_ele_to.z_ele/m_ele/m_ele
    z_ion_to.z_ion = 2.*e_ion*z_ion_to.z_ion/m_ion/m_ion
ENDIF

IF(zs EQ 2)THEN BEGIN
    e_ele = z_ele_to.energy_ele*1.6d-19*1d7
    e_ion = z_ion_to.energy_ion*1.6d-19*1d7
    z_ele_to.z_ele = 2.*e_ele^2*z_ele_to.z_ele/m_ele/m_ele
    z_ion_to.z_ion = 2.*e_ion^2*z_ion_to.z_ion/m_ion/m_ion
ENDIF

END




