PRO hydra_fv_event, event

COMMON control_info, control_id, winidx, state, $
  species_store, control_ele, control_ion

common papco_ext_common, papcoData

widget_control, event.id, get_uvalue = button_string

seg_idx = state.control.seg_idx

CASE button_string OF
    'button_draw': $
      BEGIN
        IF state.control.seg_idx GE state.control.hres-1 THEN seg_idx = 0
        state.control.next = 0
        state.control.prev = 0
        fv_plot, state, winidx, seg_idx, fv_output
        state.control.seg_idx = seg_idx
      END
    'button_close': $
      BEGIN
        IF xregistered('fv_control') THEN BEGIN
            widget_control, control_id, /destroy
        ENDIF
        widget_control, event.top, /destroy
      END
    'button_next': $
      BEGIN
        IF state.control.seg_idx NE state.control.hres-1 THEN BEGIN
            state.control.seg_idx = state.control.seg_idx+1
            state.control.next = 0
            state.control.prev = 0
;            print, 'hydra_fv_event:  ', state.control.seg_idx, $
;              state.control.next, state.control.prev
            seg_idx = state.control.seg_idx
            fv_plot, state, winidx, seg_idx, fv_output, /output
            state.control.seg_idx = seg_idx
        ENDIF ELSE BEGIN
            state.control.seg_idx = 0
            state.control.next = 1
            state.control.prev = 0
;            print, 'hydra_fv_event:  ', state.control.seg_idx, $
;              state.control.next, state.control.prev
            seg_idx = state.control.seg_idx
            fv_plot, state, winidx, seg_idx, fv_output, /output
            state.control.seg_idx = seg_idx
            if papcoData.panelNr ne -1 then begin ; move papco cursor
                ttime= fv_output.start_time + 0.5 * fv_output.del_t
                xnorm= ( ttime - papcoData.xrange(0) ) / $
                  ( papcoData.xrange(1)-papcoData.xrange(0) ) * $
                  ( papcoData.xnormal(1)-papcoData.xnormal(0) ) + $
                  papcoData.xnormal(0)
                papco_Cursor_ShowSelection, papcoData.panelNr, 0, 0, $
                  xnorm, 0
            endif               ; move papco cursor
        ENDELSE        
      END
    'button_prev': $
      BEGIN
        IF state.control.seg_idx NE 0 THEN BEGIN
            state.control.seg_idx = state.control.seg_idx-1
            state.control.next = 0
            state.control.prev = 0
;            print, 'hydra_fv_event:  ', state.control.seg_idx, $
;              state.control.next, state.control.prev
            seg_idx = state.control.seg_idx
            fv_plot, state, winidx, seg_idx, fv_output, /output
            state.control.seg_idx = seg_idx
        ENDIF ELSE BEGIN
            state.control.seg_idx = state.control.hres-1
            state.control.prev = 1
            state.control.next = 0
;            print, 'hydra_fv_event:  ', state.control.seg_idx, $
;              state.control.next, state.control.prev
            seg_idx = state.control.seg_idx
            fv_plot, state, winidx, seg_idx, fv_output, /output
            state.control.seg_idx = seg_idx
            if papcoData.panelNr ne -1 then begin ; move papco cursor
                ttime= fv_output.start_time + 0.5 * fv_output.del_t
                xnorm= ( ttime - papcoData.xrange(0) ) / $
                  ( papcoData.xrange(1)-papcoData.xrange(0) ) * $
                  ( papcoData.xnormal(1)-papcoData.xnormal(0) ) + $
                  papcoData.xnormal(0)
                papco_Cursor_ShowSelection, papcoData.panelNr, 0, 0, $
                  xnorm, 0
            endif               ; move papco cursor
        ENDELSE
      END
    'button_help': $
      print, 'help is not available....'
    'button_control': $
      fv_control, state
    'button_print': $
      BEGIN
        state.control.hc = 1
        state.control.prev = 0
        state.control.next = 0
        fv_plot, state, winidx, seg_idx, fv_output
        state.control.hc = 0
      END
ENDCASE

END


