PRO init_fv, path, t0, fv_input, reset = reset

COMMON control_info, control_id, winidx, state, $
  species_store, control_ele, control_ion

ver = 1.00
ver_string = strtrim(ver, 1)
ver_string = strmid(ver_string, 0, 4)

fv_args = {args, $
           path: path, $
           t0: t0}

fv_species = {species, $
              ele: 1, $
              ion: 0}

fv_control_ele = {control, $
                  prev: 0, $
                  next: 0, $
                  dflux: 0, $
                  deflux: 0, $
                  zmax: -24., $
                  zmin: -32., $
                  prange: [0., 180.], $
                  erange: [0., 20000.], $
                  vxrange: [-25000., 25000.], $
                  vyrange: [-25000., 25000.], $
                  dalph: 4., $
                  den: 0.06, $
                  lowcnt: 0, $
                  ahigh: 180., $
                  alow: 0., $
                  ehigh: 20000., $
                  elow: 0., $
                  data: 1, $
                  ncon: 10, $
                  normpos: [0.23, 0.2, 0.23+0.9*0.6, 0.8], $
                  hc: 0, $
                  autoscale: 0, $
                  test: 0, $
                  convect: 0, $
                  hres: 1, $
                  seg_idx: 0} 

fv_control_ion = {control, $
                  prev: 0, $
                  next: 0, $
                  dflux: 0, $
                  deflux: 0, $
                  zmax: -20., $
                  zmin: -25., $
                  prange: [0., 180.], $
                  erange: [0., 20000.], $
                  vxrange: [-800., 800.], $
                  vyrange: [-800., 800.], $
                  dalph: 4., $
                  den: 0.06, $
                  lowcnt: 0, $
                  ahigh: 180., $
                  alow: 0., $
                  ehigh: 20000., $
                  elow: 0., $
                  data: 1, $
                  ncon: 10, $
                  normpos: [0.23, 0.2, 0.23+0.9*0.6, 0.8], $
                  hc: 0, $
                  autoscale: 0, $
                  test: 0, $
                  convect: 0, $
                  hres: 1, $
                  seg_idx: 0} 

fv_control = fv_control_ele

fv_info = {info, $
           ver: ver, $
           ver_string: ver_string}              

fv_input = {fv_in, $
            species: fv_species, $
            control: fv_control, $
            info: fv_info, $
            args: fv_args}

IF NOT keyword_set(state) THEN $
    state = fv_input
IF NOT keyword_set(control_ele) THEN $
  control_ele = fv_control_ele
IF NOT keyword_set(control_ion) THEN $
  control_ion = fv_control_ion
IF NOT keyword_set(species_store) THEN $
  species_store = fv_species

IF keyword_set(reset) THEN return

fv_input.species.ele = species_store.ele
fv_input.species.ion = species_store.ion
IF fv_input.species.ele THEN BEGIN
    fv_input.control = control_ele
ENDIF ELSE BEGIN
    fv_input.control = control_ion
ENDELSE

END

