PRO test_counts, block_data, mode_info, species, f

@model_include

ndet = 12
theta = fltarr(384, ndet)
phi = fltarr(384, ndet)
IF(species LT 0)THEN BEGIN
    FOR i = 1, ndet DO BEGIN
        theta(*, i-1) = block_data.theta_ele(i-1)
        phi(*, i-1) = block_data.phi_det(*, i-1)
    ENDFOR
    mass = 9.11d-28
ENDIF ELSE BEGIN
    FOR i = 1, ndet DO BEGIN
        theta(*, i-1) = block_data.theta_ion(i-1)
        phi(*, i-1) = block_data.phi_det(*, i-1)
    ENDFOR
    mass = 1.67d-24
ENDELSE
energy = fltarr(384, ndet)
FOR i = 1, ndet DO BEGIN
    IF (i+1) MOD 2 EQ 0 THEN BEGIN
        energy(*, i-1) = abs(mode_info.energy(*, 0)*1.6d-19*1d7)
    ENDIF ELSE BEGIN
        energy(*, i-1) = abs(mode_info.energy(*, 1)*1.6d-19*1d7)
    ENDELSE
ENDFOR

speed = sqrt(2.*energy/mass)
test_f, theta, phi, speed, mass, f

eta = mode_info.delta_time*mode_info.detector_area* $
  mode_info.solid_angle*0.06

block_data.counts = long(2.*(energy/mass)*(energy/mass)*eta*f)
;block_data.counts = 2.*(energy/mass)*(energy/mass)*eta*f

vhat1 = sin(theta)*cos(phi)
vhat2 = sin(theta)*sin(phi)
vhat3 = cos(theta)

bhat1 = bhat(0)
bhat2 = bhat(1)
bhat3 = bhat(2)

cosalpha = vhat1*bhat1+vhat2*bhat2+vhat3*bhat3
block_data.alpha = acos(cosalpha)

END



