pro hydra_interp, avg1, sc_pot, energy, yrange=yrange

   print, 'hydra_interp: shifting f by S/C Potential'

   energy_scale = fltarr(n_elements(energy)) ; interpolated energies
   nspec= n_elements( energy )

   if not keyword_set( yrange ) then yrange= [min(energy), $
                                              max(energy)]

   emax= yrange(1)
   emin= yrange(0)
   
   loge = (findgen(nspec)-1)/(nspec-1)*alog10(emax/emin)
   energy_scale= emin* 10^loge
   
   energy_shift=make_array(size=size(energy))

   FOR r=0,(size(avg1))(1)-1 DO BEGIN
       avg1a = avg1(r,*)
       rv = where(avg1a NE 1.e-20) ; valid measurements
;           downshift energies by s/c pot 

       if (abs(sc_pot(r)) lt 1e30) then begin
           energy_shift=energy-sc_pot(r) 
       endif else begin
           energy_shift(*)=0.0  ; don't know energy: make nodata
       endelse
       
       IF (n_elements(rv) gt 1) THEN BEGIN
           rinterp= $
             where(energy_scale GE energy_shift(0) AND $
                   energy_scale LE energy_shift(rv(n_elements(rv)-1)))
           
           if (rinterp(0) ne -1) then begin
               avg1(r,*) = 1.e-20
               f= avg1a(rv)* ( (energy-sc_pot(r))/energy )^2.0 
               avg1(r,rinterp) = $
                 interpol(f,energy_shift(rv),energy_scale(rinterp))
           endif else avg1(r,*)= 1.e-20
       ENDIF 
   endfor 
   return
end



