pro hydra_retrieve_data, data_type, date_str, status, verbose=verbose

; hydra_retrieve_data retrives data for a given day via the
; web.

; data_type is a string identifying the data set needed
; date_str is 'YYYYMMDD' that specifies the day to retrieve.

    verbose= keyword_set(verbose)

    if getenv( 'HYDRA_AUTORETRIEVE' ) eq 'no' then begin
        status= 'no_autoretrieve'
        if verbose then message, $
          'Auto retrieval turned off via HYDRA_AUTORETRIEVE=no', /cont
        return
    endif
    
    wget_exe= getenv( 'wget_exe' )
    if wget_exe eq '' then begin
        message, 'Auto retrieve aborted since env. var wget_exe is not set', $
          /continue
        status='no_wget'        
        return
    endif
    
    if verbose then help, wget_exe

    transfer_rate=50            ; KBytes/sec
    
    status='data_type_not_known'
    
    if ( data_type eq 'hydra_spec_survey' or $
         data_type eq 'hydra_spec_l1' or $
         data_type eq 'hydra_kp' ) then begin
        
        if data_type eq 'hydra_spec_survey' then begin
            wget_dir= 'ftp://supras.physics.uiowa.edu/pub/polar/hydra/survey/'
            wget_file= date_str+'_hyd_sv_v?.??.cdf'
            output_dir= getenv( 'HYDRA_SURVEY_DATA_PATH' )
            data_size= 7000     ; KBytes
        endif
        
        if data_type eq 'hydra_spec_l1' then begin
            wget_dir= 'ftp://supras.physics.uiowa.edu/pub/polar/hydra/l1/'
            wget_file= date_str+'_hyd_l1_v?.??.cdf'
            output_dir= getenv( 'HYDRA_LEVEL1_DATA_PATH' )
            data_size= 70000    ; KBytes
        endif
        
        if output_dir eq ' ' then begin
            status= 'no_output_dir'
            return
        endif
        
        eta= string((data_size/transfer_rate)/60, format='(f8.1)') ; minutes
        getIt= widget_message( ['The data set you have requested is', $
                                'not available.  Estimated retrieval', $
                                'time is '+strtrim(eta,2)+' minutes. ', $
                                'Retrieve file? '], /question, $
                               title='No data file' )
        
        if ( getIt eq 'No' ) then begin
            status= 'user_abort'
            return
        endif

        spawn, 'pwd', pwd
        cd, output_dir
        exe_str= wget_exe+" '"+wget_dir+wget_file+"'"
        if verbose then print, 'Executing: '+exe_str
        spawn, exe_str, str_out

        if verbose then r= widget_message( str_out, /info )
        
        cd, pwd(0)
        
;   parse output for success/fail
        nsaved= n_elements( where( strpos( str_out, ' saved [' ) ne -1 ) ) -1
        if verbose then help, nsaved
        if nsaved eq 0 then begin
            r= widget_message( [ 'No files found on remote system.' ] )
            status='remote_file_no_found'
            return
        endif
        
        status='okay'
        
    endif
    
    return
end
