function hydra_union, A1_in, A2_in, idx1, idx2, errtot=err
;+
; function hydra_union, A1_in, A2_in, idx1, idx2, errtot=err
;
; returns the set of elements that are present
; in both arrays A1 and A2.  idx1 are the indeces of the
; union in A1, and idx2 are the indeces of the union
; in A2.
; 
; Notes:
;    Input data is assumed to not have repeated values within each
; array, and if the data is real, then it is assumed that the data
; can be decretized with the following function:
;    A(i)= m * iA(i) + b
; where m and b are reals, but iA(i) is an integer.
;
; Needs:
;    gcd.pro,   if the data must be descretized.
;      
; Written, 2-4-97, Jeremy Faden  ISTP POLAR/Hydra University of Iowa
;-

  type= (size( A1_in(0) ))(2)
  descretize= ( type eq 4 ) or ( type eq 5 )

  if descretize then begin
      if n_elements( err ) eq 0 then $
        err= (A1_in(1)-A1_in(0))/100. ; bin within this error
      min= min( [ A1_in,A2_in ], max=max )
      gcd= gcd( [ A1_in,A2_in ] - min, errtot= err )
      iA1= long( ( ( A1_in - min ) / gcd ) + 0.5 )
      iA2= long( ( ( A2_in - min ) / gcd ) + 0.5 )
      imax= long( ( ( max - min ) / gcd ) + 0.5 ) 
  endif else begin
      iA1= A1_in
      iA2= A2_in
      imax= max( [ iA1,iA2 ])
  endelse
  
  icount= intarr( imax )
  idx1= lonarr( imax )
  idx2= lonarr( imax )
  
  idx1( iA1 ) = lindgen( n_elements( iA1 ) )
  idx2( iA2 ) = lindgen( n_elements( iA2 ) )
  
  icount( iA1 ) = icount( iA1 ) + 1
  icount( iA2 ) = icount( iA2 ) + 1
  
  r= where( icount eq 2 )
  if r(0) ne -1 then begin
      idx1= idx1(r)
      idx2= idx2(r)
      return, A1_in( idx1 )
  endif else begin
      idx1= -1
      idx2= -1
      return, 'none found'
  endelse
  
end
