pro hydra_ylim_1, panel, typeVector, yray_in, yrange=yrange, ylog=ylog

  common yscale, yscl             ; from PaPCo core

  r= where( yray_in lt 1e30 and yray_in gt -1e30 ) ; fill data removed.
  if r(0) ne -1 then yray= yray_in(r) else yray= yray_in

  ord=sort(yray)
  n=n_elements(ord)
  
; define options
  ylim_options= typeVector(3)

  center_zero = ( 1 and ylim_options ) eq 1
  include_zero = ( 2 and ylim_options ) eq 2
  multicycle_log_only = ( 4 and ylim_options ) eq 4
  smart= ( 8 and ylim_options ) eq 8 
  manual_linlog = 1             ; make this always true.  Confusing otherwise.
  
  manual= yscl(panel,0) eq 1

  if manual then begin
      yst= yscl(panel,1)
      yen= yscl(panel,2)
      ylog= yscl(panel,3)      

      yrange= [ yst, yen ]
      
      return

  endif else begin
      if ( manual_linlog ) or n_elements(ylog) eq 0 then ylog= yscl(panel,3) 

      ylog= keyword_set(ylog)
      if ylog then begin
          r= where( yray le 0.0 )
          if r(0) ne -1 then begin
              message, $
                'Zero or negative data found, swwitching to linear.', /cont
              yscl(panel,3)=0
              ylog=0
          endif
      endif

      redo:
      if smart then begin
          yst=yray(ord(n/200))
          yen=yray(ord(long((n-1)-(n/200.)+0.5)))
      endif else begin
          yst=yray(ord(0))
          yen=yray(ord(n-1))
      endelse
      
      if keyword_set(ylog) then begin 
          yst=10.^floor(alog10(yst))
          yen=10.^ceil( alog10(yen))
          
          if  multicycle_log_only and yen/yst eq 10. then begin 
              message, /cont, $
                'Only one cycle, plotting linear instead of logarythmic'
              ylog=0
              goto, redo
          endif
      endif

  endelse
  
  if not ylog then begin
      if center_zero then begin
          max= max( [abs(yst),abs(yen)] )
          yst= -max
          yen= max
      endif
      
      if include_zero  then begin
          yst= yst < 0 
          yen= yen > 0
      endif
  endif

; set yscale for overplots.
  yscl(panel(0),1)= yst
  yscl(panel(0),2)= yen
  yscl(panel(0),3)= ylog
  
; extend axis by 10%
  yrange=abs(yen-yst)
  if keyword_set(ylog) then begin
      yst=yst*0.9
      yen=yen*1.1
  endif else begin
      yst=yst-yrange*0.1
      yen=yen+yrange*0.1
  endelse

  yrange= [ yst, yen ]
  
end





