PRO load_mfe_bavg, cdfid, time, bavg, bavg_sig, bavg_angle_cone, bavg_status

   myname = 'load_mfe_bavg'

   rfill = -1.e+31

   start_time = time(0)
   end_time = time(n_elements(time)-1)

   cdf_control, cdfid, var='BLOCK_TIME', get_var_info=r
   cdf_varget, cdfid, 'BLOCK_TIME',block_time,rec_start=0, rec_count=r.maxrec+1
   block_time = (block_time MOD 86400000)/1000.

   rec_start = (where(long(block_time) EQ long(start_time)))(0)
   rec_stop = (where(long(block_time) EQ long(end_time)))(0)
   IF (rec_start EQ -1 OR rec_stop EQ -1) THEN BEGIN
      print, myname+': Start/Stop records not found'
      stop
   ENDIF
   rec_count = rec_stop - rec_start + 1

   cdf_varget, cdfid, 'BLOCK_TIME', block_time, $
    rec_start=rec_start, rec_count=rec_count
   block_time = (block_time MOD 86400000)/1000.
   cdf_varget, cdfid, 'BLOCK_MODE', block_mode, $
    rec_start=rec_start, rec_count=rec_count
   cdf_varget, cdfid, 'MFE_B_AVG', mfe_b_avg, $
    rec_start=rec_start, rec_count=rec_count
   cdf_varget, cdfid, 'MFE_B_AVG_SIGMA', mfe_b_avg_sigma,  $
    rec_start=rec_start, rec_count=rec_count

   bavg = fltarr(3,n_elements(time))
   bavg_sig = fltarr(3,n_elements(time))
   bavg_status = intarr(n_elements(time))
   bavg_angle_cone = fltarr(n_elements(time))
   
   diffvec = long(reform(time)) - long(reform(block_time))
   IF ( (n_elements(time) NE n_elements(block_time)) OR $
        (max(diffvec) NE 0) ) THEN BEGIN 
      print, myname + ': Synchronizing moments and L1 times'
      FOR ii=0,n_elements(time)-1 DO BEGIN
         index = (where(long(block_time) EQ long(time(ii))))(0)
         IF (index NE -1) THEN BEGIN
            IF (mfe_b_avg(0,index) NE 0.) THEN BEGIN 
               bavg(0:2,ii) = mfe_b_avg(0:2,index)
               bavg_sig(0:2,ii) = mfe_b_avg_sigma(0:2,index)
               bavg_status(ii) = 1
            ENDIF ELSE BEGIN 
               bavg(0:2,ii) = rfill
               bavg_sig(0:2,ii) = rfill
               bavg_status(ii) = 0
            ENDELSE
         ENDIF ELSE BEGIN
            bavg(0:2,ii) = rfill
            bavg_sig(0:2,ii) = rfill
            bavg_status(ii) = 0
         ENDELSE
      ENDFOR
   ENDIF ELSE BEGIN 
      bavg = mfe_b_avg
      bavg_sig = mfe_b_avg_sigma
      bavg_status(*) = 1
   ENDELSE 


   gd = where(bavg_status EQ 1)
   ngd = where(bavg_status NE 1)
   bavg_mod = sqrt( bavg(0,gd)^2 + bavg(1,gd)^2 + bavg(2,gd)^2 )

   bavg_angle_cone(gd) = atan( sqrt(bavg_sig(0,gd)^2+ $
                                    bavg_sig(1,gd)^2+ $
                                    bavg_sig(2,gd)^2) $
                               / bavg_mod )
   IF (ngd(0) NE -1) THEN bavg_angle_cone(ngd) = rfill


   return
END

   
   


   




