;***************************************************************************
;*
;* PROCEDURE:
;*      p_hydra_current, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* DESCRIPTION:
;*	This procedure plots data of type hydra_current for inclusion in PAPCO.
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behaviour is controlled by the vector panel
;*	which controlls positioning of the plot (see papco_conventions.text
;*      in $PAPCO). In general, the following plot conventions are used:
;*      	- if the panel is at the bottom plot time axis plus any
;*              - additional axis (ie ephemeris) needed.
;*              - if panel is at the top also plot a title
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a colorbar.
;*              - panels all have common time
;*              - y-scaling (or z-scaling for color plots) is either
;*              - automatic or manualy set using common yscale
;*
;* INPUTS:
;*	panel	three element integer vector. Controlls positioning of the plot
;*              (see papco_conventions.text in $PAPCO)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the PAPCO structure PAPCO_PLOTINFO which is set
;*              by the paneleditor. Additional fields that can be used if
;*              needed are PAPCO_PLOTINFO.swwitch (three element vector) and
;*              PAPCO_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fileds than these you have to extend the definition
;*              of the structure PAPCO_PLOTINFO
;*              (procedure PAPCO_getPlotInfoStruct in $PAPCO/papco.pro). Try to
;*              avoid this!
;*
;* OUTPUTS:
;*   	none
;*
;* KEYWORDS:
;*      OVERPLOT  if you support this you can alter the appearance of your
;*              plot id it is an overplot to an exisiting panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*      PLOTS_ATTHISPOSITION  used to control the lft side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and linestyle.
;*
;* CALLING SEQUENCE:
;*       p_hydra_current, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:
;*     template written December 1995, Reiner Friedel, at Goddard
;*     customized for U of Iowa HYDRA Fall 1996, Jeremy Faden, U of Iowa
;*
;***************************************************************************

pro p_hydra_current, panel, type, $
                     OVERPLOT=OVERPLOT, $
                     PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
                     _EXTRA=extra_par, subtable=subtable

; The following common blocks are needed:

common time, xut1,xut2          ;common time limits in T90
common mjdt, mjdt1, mjdt2
common get_error, get_err_no, get_err_msg

;   common hydra_yscale, yscl
common yscale, yscl             ;man/auto yscaling
common coordinateSystems, plotted_x, plotted_y
                                ;info on coords used by mouse

common hydra_current_data, $
  current_header, $
  current_data

COMMON hydra_current_labels, $
  current_labels

common papco_color_names

panelset,panel			;sets the panel position viewport

oldy=!y
oldx=!x

rfill = -1.e+31

goodticks, xtickv, xminor
xticks=n_elements(xtickv)-1

; set duplex font if big_gif is device ; duplex roman
if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

; the plot calls normally use the arrays t90 for the time axis and yray (ymat
; for color plots) for the y or z axis.
dxut= xut2-xut1

data = current_data

; Define the labels
IF n_elements(current_labels) EQ 0 THEN $
  hydra_define_structure, /cur_lab

panel_title='Hyd Moments-J!c' 
if getenv('hydra_presentation_mode') eq '1' then panel_title=''

IF (type(0) LT 39 OR type(0) GT 42) THEN $
  ctit2=panel_title+current_labels(type(0),2) ELSE $
  ctit2 = current_labels(type(0),2)
cytit = current_labels(type(0),3)

if getenv('hydra_presentation_mode') eq '1' and type(0) lt 16 then ctit2= ctit2 + '!r!ue'

IF (type(1)) THEN color_code = 1 ELSE color_code = 0

plot_name=' '
eplot = 0
vector = ' '
case type(0) of
    0:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_pay(3)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    1:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_pay(0)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    2:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_pay(1)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    3:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_pay(2)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    4:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_gsm(0)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    5:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_gsm(1)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    6:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_perp_gsm(2)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    7:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).du_parl
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 1
        oplot_y2 = -1
    END
    8:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_pay_filtered(3)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_pay(3)
        endelse
        dt=13.8
        this_Par={ ylog:1 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    9:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_pay_filtered(0)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_pay(0)
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    10:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_pay_filtered(1)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_pay(1)
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    11:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_pay_filtered(2)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_pay(2)
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    12:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_gsm_filtered(0)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_gsm(0)
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    13:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_gsm_filtered(1)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_gsm(1)
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    14:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_perp_gsm_filtered(2)
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_perp_gsm(2)
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    15:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        if (type(2) and 4) eq 4 then begin
            ydat = data(*).j_parl_filtered
            ctit2 = ctit2+' (filtered)'
        endif else begin
            ydat= data(*).j_parl
        endelse
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        pres_unit='!7l!xA/m!u2!n'
        polyref = 0.
    END
    16:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    END
    17:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_rgyro_ion
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    18:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_rgyro_ele
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    19:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_inert_ion
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    20:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_inert_ele
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    21:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).rgyro_ion
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    END
    22:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).rgyro_ele
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    END
    23:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).inert_ion
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    END
    24:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).inert_ele
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    END
    25:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_pressure
        dt=13.8
        this_Par={ ylog:1 }
        polyref = 0.
        oplot_y = 0.
    END
    26:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_particle_pressure
        dt=13.8
        this_Par={ ylog:1 }
        polyref = 0.
        oplot_y = 0.
    END
    27:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_magnetic_pressure
        dt=13.8
        this_Par={ ylog:1 }
        polyref = 0.
        oplot_y = 0.
    END
    28:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_parl_particle_pressure
        dt=13.8
        this_Par={ ylog:1 }
        polyref = 0.
        oplot_y = 0.
    END
    29:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_perp_particle_pressure
        dt=13.8
        this_Par={ ylog:1 }
        polyref = 0.
        oplot_y = 0.
    END
    30:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_anisotropy
        dt=13.8
        this_Par={ ylog:1 }
        polyref = 1.
        oplot_y = 1.
    END
    31:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat = fltarr(n_elements(t90)) + rfill
        gd = where(data(*).j_parl ne rfill and data(*).j_perp_pay(3) ne rfill)
        ydat(gd)= sqrt(data(gd).j_parl^2 + data(gd).j_perp_pay(3)^2)
        dt=13.8
        this_Par={ ylog:1 }
        vector = 'current'
        polyref = 0.
        oplot_y = 0.
    END
    32:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat = fltarr(n_elements(t90)) + rfill
        gd = where(data(*).j_parl ne rfill and data(*).j_perp_pay(3) ne rfill)
        ydat(gd)= -1.*sqrt(data(gd).j_parl^2 + data(gd).j_perp_pay(3)^2)
        dt=13.8
        this_Par={ ylog:1 }
        ctit2 = ' '
        oplot_y = 0
        polyref = 0.
    END
    33:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat=data.j_gse(0)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        vector = 'current'
        polyref = 0.
    END
    34:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat=data.j_gse(1)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        vector = 'current'
        polyref = 0.
    END
    35:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat=data.j_gse(2)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        vector = 'current'
        polyref = 0.
    END
    36:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data.j_gsm(0)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        vector = 'current'
        polyref = 0.
    END
    37:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat=data.j_gsm(1)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        vector = 'current'
        polyref = 0.
    END
    38:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data.j_gsm(2)
        dt=13.8
        this_Par={ ylog:0 }
        oplot_y = 0
        vector = 'current'
        polyref = 0.
    END
    39:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        r_hydra_pwi_power, data(0).date, data.time_ssm, ydat, $
          /mcab, rfill=-1.e+31
        IF (get_err_no NE 0) THEN return
        dt=13.8
        this_Par={ ylog:1 }
    END
    40:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        r_hydra_pwi_power, data(0).date, data.time_ssm, ydat, $
          /mcae, rfill=-1.e+31
        IF (get_err_no NE 0) THEN return
        dt=13.8
        this_Par={ ylog:1 }
    END
    41:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        r_hydra_pwi_power, data(0).date, data.time_ssm, ydat, $
          /sfra, rfill=-1.e+31
        IF (get_err_no NE 0) THEN return
        dt=13.8
        this_Par={ ylog:1 }
    END
    42:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        r_hydra_pwi_power, data(0).date, data.time_ssm, ydat, $
          /sfrb, rfill=-1.e+31
        IF (get_err_no NE 0) THEN return
        dt=13.8
        this_Par={ ylog:1 }
    END
    43:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_parl
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    END
    44:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_parl_rgyro_ion
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    45:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_parl_rgyro_ele
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    46:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_parl_inert_ion
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    47:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).cls_parl_inert_ele
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 1.
        oplot_y = 1.
    END
    48:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_eflux_parl
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    end
    49:begin
        t90= data(*).time + ( current_header.start_time - xut1 )
        ydat= data(*).total_eflux_parl_over_b
        dt=13.8
        this_Par={ ylog:0 }
        polyref = 0.
        oplot_y = 0.
    end
ENDCASE 

if ((type(2) and 1) eq 1 and n_elements(polyref) ne 0) then $
  hydra_plot_kw = { reference:polyref, $
                    poly_above_ref:red, $
                    poly_below_ref:blue }


;   if getenv( 'hydra_presentation_mode' ) eq '1' then begin
;       if n_elements( pres_unit ) gt 0 then begin
;           cytit= pres_unit
;       endif
;   endif

; Color-codeing decommisioned 19991119 by PPQ.
; If color-coding is desired, find the color_types!
IF (color_code) THEN BEGIN 
    IF (vector EQ 'current') THEN BEGIN
        hydra_calc_b_alignment, data.j_gsm, data.b_gsm, data.b_angle_cone,$
          color_type
    ENDIF ELSE BEGIN 
        color_code = 0
    ENDELSE
ENDIF 

; filter out invalid data
r= where( ydat EQ -1.e+31 )
if r(0) ne -1 then ydat(r)= 1e31

cytit= font+cytit
ctit2= font+ctit2

; the variable used above have the following meaning:
; 	cytit : the y-axis label
;	ctit2 : the right-of plot label defining the data
;       ctit  : the label for top panel plot
; the procedure YLIM is optional and sets the ylimit automatically for the data
; in the chosen time-range, leaving a 10% gap at the top and bottom limits.
; this routine is very simple and does not handle spikes or bad data, you may
; need to supply your own procedure for your own data.
; For 3-D color plots you can use the routine AUTORANGE. (both are in
; $PAPCO/PLOT_prog/Common)

; select only the time interval to be plotted. This is not needed, but does
; speed up plotting images

; Note the kludge to remove the zeroth element, which wasn't being
; filled.  -JBF

index=where((t90 ge 0) and (t90 le dxut),count)
if count ge 2 then begin
    t90=t90(index)
    ydat=ydat(index)
    IF (eplot) THEN ydat_sig = ydat_sig(index)
    IF (color_code) THEN color_type = color_type(index)
end

if ( type(2) and 2 ) eq 2 then begin
    hd_make_timetags, ttag, t90+xut1, 13.8, /t90
    hyd_access, ttag, 'return_current_quality', rc_index
    index= where( rc_index gt 0.1 and rc_index lt 10.0 )
    if index(0) ne -1 then begin
        t90= t90(index)
        ydat= ydat(index)
        IF (eplot) THEN ydat_sig = ydat_sig(index)
        IF (color_code) THEN color_type = color_type(index)
    endif      
endif

; insert breaks where there are data dropouts. (grid the data)
dt= t90(1:*) - t90(0:*)
r= where(dt gt 0)
if r(0) ne -1 then dt=min(dt(r)) else dt=1
nn= max(t90)/dt + 1
ydat_grid= make_array( nn, /float, value=1e31 )
IF (eplot) THEN ydat_sig_grid = make_array( nn, /float, value=1e31 )
IF (color_code) THEN color_type_grid = make_array( nn, /float, value=1e31 )
t90_grid= make_array( nn, /float, value=0 )
r= long( t90/dt )
ydat_grid( r ) = ydat
IF (eplot) THEN ydat_sig_grid( r ) = ydat_sig
IF (color_code) THEN color_type_grid( r ) = color_type
t90_grid( r ) = t90

t90= t90_grid
ydat= ydat_grid
IF (eplot) THEN ydat_sig = ydat_sig_grid
IF (color_code) THEN color_type = color_type_grid   

y_kw= hydra_ytick_parm( ydat, panel=panel(0), _extra=this_Par, fill=1e31 )

; set up extra plot keywords, common ones first
extra_plotPar_common={xrange:[0,dxut], $
                      noerase:1, ticklen:-0.03, xticklen:-0.03, $
                      xtickv:xtickv, xminor:xminor, xticks:xticks, $
                      yticklen:0.010, ytitle:cytit, $
                      ythick:1.3, xthick:1.3, max_value:1e30 }
extra_plotPar_common= create_struct( extra_plotPar_common, y_kw )

; check if the passed in structure extra_par was set. If not, set color to
; default black; which for the color table used by PAPCO is 1.

if n_elements(extra_par) EQ 0 then $
  extra_par={color:1}

; add keyword structure set here with the one passed in

extra_plotPar= create_struct( extra_plotPar_common, extra_par )

axis_plotPar= create_struct( extra_plotPar_common, {color:1} )

; extend this structure by those keywords specific to the plot being bottom
; panel or not. You might have to add your own ytickformat, or leave it out
; for default plot

if panel(0) eq 0 then begin
    xtickformat= 'hydra_timeticks'
endif else begin
    xtickformat= 'noticks'
endelse

; plot the axis in color=1, and only plot if if you're not overplotting
if not keyword_set(overplot) then begin
    plot,t90,ydat, _extra=axis_plotPar, /NODATA, $
      xstyle=1, ystyle=1, xtickformat=xtickformat
    if panel(0) eq 0 then $
      x_side_label,panel,font+'time (UT)!CDate',XTICKLEN=0.03
    
    IF (color_code) THEN BEGIN
        ry = yrange
        FOR ii=0,n_elements(t90)-2 DO BEGIN
            IF (color_type(ii) NE 1e31) THEN $
              polyfill, [t90(ii),t90(ii),t90(ii)+13.8,t90(ii)+13.8], $
              [ry(0),ry(1),ry(1),ry(0)], $
              color=long(color_type(ii))
        ENDFOR 
    ENDIF
    
    if (n_elements(oplot_y) ne 0) then oplot, !x.crange, [oplot_y,oplot_y], line=3, color=dark_grey
    if (n_elements(oplot_y2) ne 0) then oplot, !x.crange, [oplot_y2,oplot_y2], line=3, color=dark_grey
endif

; now do the actual data plot
if n_elements( hydra_plot_kw ) gt 0 then $
  hp_kw= create_struct( extra_plotPar, hydra_plot_kw ) $
else $
  hp_kw= extra_plotPar
hydra_plot, t90, ydat, _extra=hp_kw, xstyle=5, ystyle=5, $
  overplot= keyword_set( overplot )

IF (eplot) THEN BEGIN
    FOR jkl=0,n_elements(t90)-1 DO BEGIN 
        oplot, [t90(jkl)+dt/2.,t90(jkl)+dt/2.],[ydat(jkl)-ydat_sig(jkl),ydat(jkl)+ydat_sig(jkl)],line=0,color=extra_plotPar.color
    ENDFOR
ENDIF

if not keyword_set(overplot) then begin
    plot,t90,ydat, _extra=axis_plotPar, /NODATA, $
      xstyle=1, ystyle=1, xtickformat=xtickformat
    if panel(0) eq 0 then $
      x_side_label,panel,font+'time (UT)!CDate',XTICKLEN=0.03
endif

; store the coordinate information into common block
plotted_x = !x
plotted_y = !y

!x=oldx
!y=oldy

; plot extra x-axis labels (eg. ephemeris) and a x-axis label if required.
; plot in color=1. Example here adds an axis with date information.
; the routine x_side_label puts x-axis label to the right of the axis.
; Use the keyword XTICKLEN if your x-axis ticklengths are not the
; default 0.015

if (panel(0) eq 0) and not keyword_set(OVERPLOT) then begin
    r= where( (xtickv+xut1) mod 86400 eq 0, count )
    if r(0) ne -1 then begin
        xtickv= xtickv(r)
        xticks= count
    endif else begin
        xtickv= xtickv([0,n_elements(xtickv)-1])
        xticks= 1
    endelse
    
    axis_plotPar.xtickv= xtickv
    axis_plotPar.xticks= xticks
    
    plot, t90, ydat, /NODATA, $
      _extra=axis_plotPar, xtickformat='hydra_juldate', $
      xstyle=1, ystyle=5
    
endif

; plot info right of the panel. If you want overplots to have there own label
; you need to add position control for this label using the keyword
; PLOTS_ATTHISPOSITION
abunchoflfs='!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c!c'
lfs= strmid( abunchoflfs, 0, 6*(plots_atthisposition<10) )
right_side_label,panel,lfs+ctit2, _extra=extra_plotPar

hydra_footprint, current_header

get_err_no= 0

end





