function p_hydra_ticks_label,axis,index,t

  common hydra_other_data, other_header, other_data
  common time, xut1, xut2
  COMMON mjdt, mjdt_start, mjdt_end
  common hydra_ticks_common, ticktype, pos
  
  lfs=''
  for i=1,pos do begin
      lfs=lfs+'!c'
  endfor

  t90= other_data(*).time + ( other_header.start_time - xut1 )  

  m= min( abs(t90-t), imin )
  if m gt 600 then return, ' '

  if ticktype gt 1 then begin
      if t gt max(t90) then t=max(t90) ; prevent extrapolation if not time
      if t lt min(t90) then t=min(t90)
  endif
  
  case ticktype of 
      0: begin
          dt= xut2-xut1
          t= (long(t)+xut1) mod 86400
          hour = fix(t/3600.)
          minute = (t mod 3600)/60
          if (dt gt 300) then begin
              str=string(hour,minute,format="(i2.2,':',i2.2)")
          endif else begin
              sec= fix(t mod 60)
              str=string(hour,minute,sec, format="(i2.2,':',i2.2,':',i2.2)")
          endelse
      end
      1:  begin
          mjdt_now=mjdt_start 
   
          add_days = t / 86400l
          add_sec  = t mod 86400l
 
          ssm= (long(t)+xut1) mod 86400

          if ssm eq 0. or index eq 0 then begin
              mjdt_now.mjd = mjdt_start.mjd + add_days
              mjdt_now.t   = mjdt_start.t   + add_sec
              
              if mjdt_now.t ge 86400 then begin
                  mjdt_now.t  = mjdt_now.t  - 86400
                  mjdt_now.mjd= mjdt_now.mjd + 1
              endif
              
              convert_t90_to_date,mjdt_now, $ ;y2k
                year, doy, hour, minutes, sec, month, cmonth, dom, /mjdt
              if year lt 100 then year=year+1900
              str=string(dom,cmonth,year,format="(i2.2,a3,i4.4)")
          endif else str=''
      end
      2: begin
          val= interpol( other_data(*).ilt, t90, t )
          str= strtrim( string( val, format= '(f9.2)' ), 2 )
      end
      3: begin
          val= interpol( other_data(*).mlt, t90, t )          
          hh= fix( val )
          mm= fix( (val-hh)*60 + 0.5 )
          str= strtrim( string( hh, format= '(i2.2)' ),2 ) + $
            strtrim( string( mm, format= '(i2.2)' ),2 )
      end
      4: begin
          r_earth =  6378.1
          val= interpol( other_data(*).radius, t90, t )
          str= strtrim( string( val/r_earth, format='(f9.2)'),2 ) 
      end
      5: begin
          val= interpol( other_data(*).lshell, t90, t )
          str= strtrim( string( val, format='(f9.1)'),2 )
      end
      6: begin
          val= interpol( other_data(*).maglat, t90, t )
          str= strtrim( string( val, format='(f9.1)'), 2 )
      end
  endcase
  return, lfs+str
end

;***************************************************************************
;* 
;* PROCEDURE:     
;*      p_hydra_ticks, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;* 
;* DESCRIPTION:  
;*	This procedure plots data of type hydra_other for inclusion in PAPCO.  
;*      Data must have been read and placed into common blocks before this
;*      routine is called. Behaviour is controlled by the vector panel
;*	which controlls positioning of the plot (see papco_conventions.text
;*      in $PAPCO). In general, the following plot conventions are used:
;*      	- if the panel is at the bottom plot time axis plus any
;*              - additional axis (ie ephemeris) needed.
;*              - if panel is at the top also plot a title
;*              - a descriptor for panels is plotted to the right of each
;*                panel, rotated by 90 deg if there is a colorbar.
;*              - panels all have common time
;*              - y-scaling (or z-scaling for color plots) is either
;*              - automatic or manualy set using common yscale     
;*
;* INPUTS:       
;*	panel	three element integer vector. Controlls positioning of the plot
;*              (see papco_conventions.text in $PAPCO)
;*      type    optional parameter for options. Normally is a four element
;*              integer vector. This is normally equivalent to the field
;*              typeVector of the PAPCO structure PAPCO_PLOTINFO which is set
;*              by the paneleditor. Additional fields that can be used if
;*              needed are PAPCO_PLOTINFO.swwitch (three element vector) and 
;*              PAPCO_PLOTINFO.channel (integer). If your plot routine needs
;*              more input fileds than these you have to extend the definition
;*              of the structure PAPCO_PLOTINFO
;*              (procedure PAPCO_getPlotInfoStruct in $PAPCO/papco.pro). Try to
;*              avoid this!
;*              
;* OUTPUTS: 
;*   	none
;*
;* KEYWORDS:
;*      OVERPLOT  if you support this you can alter the appearance of your
;*              plot id it is an overplot to an exisiting panel. Standard is
;*              to plot data, no axis, using the y-scaling of the first plot
;*              and to shift the labeling on the left down one line. Useful
;*              to plot model data together with real data, ie mag. field.
;*              see p_crres_mag for an example.
;*      PLOTS_ATTHISPOSITION  used to control the lft side labeling for more
;*              than one overplot at the same position.
;*      _EXTRA  the plot structure containing some keyword for calls to
;*              plot. Used to customize color and linestyle.   
;* 
;* CALLING SEQUENCE:
;*       p_hydra_ticks, panel, type, $
;*           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
;*           _EXTRA=extra_par
;*
;* MODIFICATION HISTORY:       
;*     template written December 1995, Reiner Friedel, at Goddard
;*     customized for U of Iowa HYDRA Fall 1996, Jeremy Faden, U of Iowa
;*
;***************************************************************************

pro p_hydra_ticks, panel, type, $
           OVERPLOT=OVERPLOT, PLOTS_ATTHISPOSITION=PLOTS_ATTHISPOSITION,$
           _EXTRA=extra_par, subtable=subtable



; The following common blocks are needed:

   common time, xut1,xut2 ;common time limits in T90
   common mjdt, mjdt1, mjdt2

   common coordinateSystems, plotted_x, plotted_y  
                                        ;info on coords used by mouse

   common hydra_other_data, other_header, other_data
   common hydra_ticks_common, ticktype, pos

   common papco_color_names

   panelset,panel			;sets the panel position viewport

   oldy=!y
   oldx=!x

   goodticks, xtickv, xminor
   xticks=n_elements(xtickv)-1

   r_earth =  6378.1

; set duplex font if big_gif is device  ; duplex roman
   if !d.name eq 'Z' then font='!5' else font=getenv('hydra_font')

; the plot calls normally use the arrays t90 for the time axis and yray (ymat 
; for color plots) for the y or z axis.
   dxut= xut2-xut1
   
   extra_plotPar_common={yrange:[0, 1], ystyle:4, xrange:[0,dxut], $
                         noerase:1, ticklen:-0.03, xticklen:-0.03, $ 
                         xtickv:xtickv, xminor:xminor, xticks:xticks, $
                         yticklen:0.010, $
                         ythick:1.3, xthick:1.3, max_value:1e30 }
   
; check if the passed in structure extra_par was set. If not, set color to
; default black; which for the color table used by PAPCO is 1.
   
   if n_elements(extra_par) EQ 0 then $
    extra_par={color:1}
   
; add keyword structure set here with the one passed in
   
   extra_plotPar=create_struct( extra_plotPar_common, extra_par)
      
   axis_plotPar= create_struct( extra_plotPar_common, {color:1} )
   
   if overplot then begin
       pos=2 
       str='!c!c'
   endif else begin
       pos=0       
       str=''
   endelse

   for ibit= 0,15 do begin
       yesdraw= ( type(0) and long(2)^ibit ) eq  long(2)^ibit
       if yesdraw then begin
           ticktype= ibit       ; common
           plot, [0,1], /nodata, _extra=axis_plotpar, $
             xtickformat='p_hydra_ticks_label', xstyle=1
           case ibit of 
               0: str=str+'time (UT)'
               1: str=str+'date '
               2: str=str+'ILT'
               3: str=str+'MLT'
               4: str=str+'R'
               5: str=str+'L'
               6: str=str+'MAGLAT'
           endcase
           str=str+'!c'
           pos=pos+1            ; common
       endif
   endfor
   x_side_label,panel,str,XTICKLEN=0.03

; store the coordinate information into common block
   plotted_x = !x
   plotted_y = !y
   
   !x=oldx
   !y=oldy
   
end 





