pro p_hydra_walen, hc=hc

common walen_data, datestr, starttime, stoptime, $
  diff_method, zoom, wdata, inds, ref_index, wfit

common get_error, get_err_no, get_err_msg

common data_range_ele, drange_ele

myname = 'p_hydra_walen: '

IF (not hc) THEN BEGIN 
    outsize = 1.2
    pltsize = 1.2
    symsize = 1
ENDIF ELSE BEGIN
    outsize = .6
    pltsize = .75
    symsize = .75
ENDELSE

black= get_color_index('black')
white= get_color_index('white')

outs = fltarr(22,2)

; Time string
ltime = wdata(inds(0)).time/3600.
hr = long(ltime)
mn = long((ltime-hr)*60.)
sc = long(((ltime-hr)*60.-mn)*60.)
ltimestr = string(hr,'(i2.2)')+':'+string(mn,'(i2.2)')+':'+ $
  string(sc,'(i2.2)')

rtime = wdata(inds(n_elements(inds)-1)).time/3600.
hr = long(rtime)
mn = long((rtime-hr)*60.)
sc = long(((rtime-hr)*60.-mn)*60.)
rtimestr = string(hr,'(i2.2)')+':'+string(mn,'(i2.2)')+':'+ $
  string(sc,'(i2.2)')

font = '!5'
timestr = ltimestr+'-'+rtimestr
if (wfit.species eq 1) then titstr = font+datestr+' Ions!c'+timestr else titstr = font+datestr+' Electrons!c'+timestr
xsymvec = fltarr(3,4)
ysymvec = fltarr(3,4)
xsymvec(0,*) = [-1,0,1,0] & ysymvec(0,*) = [0,1,0,-1] ; Diamond
a = 2.*tan(30.*!pi/180.)
xsymvec(1,*) = [-a,0,a,-a] & ysymvec(1,*)=[-1,1,-1,-1] ; Triangle
a = sqrt(2)/2.
xsymvec(2,*) = [-a,a,a,-a] & ysymvec(2,*)=[a,a,-a,-a] ; Square

; Define the variables for this particular interval

nf = wfit.nfit   
f2 = wfit.f1
kappa2 = wfit.kappa/float(nf-1-1) ; REDUCED chi2
kappamin_index2 = wfit.kappamin_index
x = wfit.xfit(0:nf-1)
y = wfit.yfit(0:nf-1)
sigy = wfit.sigyfit(0:nf-1)
sigx = wfit.sigxfit(0:nf-1)
labelstr = wfit.labelfit(0:nf-1)
nparms = 1
slope = wfit.sf68(1)
slope_sigma_68left = abs(wfit.sf68(1)-wfit.sf68(0))
slope_sigma_68right = abs(wfit.sf68(1)-wfit.sf68(2))
slope_sigma_95left = abs(wfit.sf95(1)-wfit.sf95(0))
slope_sigma_95right = abs(wfit.sf95(1)-wfit.sf95(2))
slopemax = abs(wfit.sf68(2))
slopemin = abs(wfit.sf68(0))
slopetheory_max = abs(wfit.st(2))
slopetheory_min = abs(wfit.st(0))
intercept = 0.
rchisq = wfit.r2
slope_theory = wfit.st(1)
slope_theory_sigma = abs(wfit.st(1)-wfit.st(0))

if (diff_method eq 0) then wmi = inds else wmi=[inds(0),inds(n_elements(inds)-1)]
orig_wmi = lindgen(n_elements(wdata.time))

; Kappa Picture ---------------------------------------
xrange = [f2(0),f2(n_elements(f2)-1)]

IF (kappa2(kappamin_index2) GE 10.) THEN BEGIN
    yrange = [10,1000]
ENDIF ELSE BEGIN
    yrange = [.1,100]
ENDELSE

plot,f2,kappa2,xtitle=font+'!7a!x!9`!x (slope)',ytitle=font+'!7v!dm!x!n!u2!n',xstyle=1,ystyle=1,xrange=xrange,title=titstr,/ylog,yrange=yrange,charsize=pltsize,/nodata,ymargin=[4,4],xmargin=[10,6], color=black,xticks=0

oplot, f2,kappa2, color=black

oplot, [f2(kappamin_index2),f2(kappamin_index2)],[min(kappa2),max(kappa2)],line=0, color=black

oplot, [f2(kappamin_index2)-slope_sigma_68left,f2(kappamin_index2)-slope_sigma_68left],[min(kappa2),max(kappa2)],line=2, color=black
oplot, [f2(kappamin_index2)+slope_sigma_68right,f2(kappamin_index2)+slope_sigma_68right],[min(kappa2),max(kappa2)],line=2, color=black

oplot, [f2(kappamin_index2)-slope_sigma_95left,f2(kappamin_index2)-slope_sigma_95left],[min(kappa2),max(kappa2)],line=4, color=black
oplot, [f2(kappamin_index2)+slope_sigma_95right,f2(kappamin_index2)+slope_sigma_95right],[min(kappa2),max(kappa2)],line=4, color=black

;------------------------
; FIT RESULTS
;------------------------
outs(0,*) = norm_axis([.55,.85]) & outs(0,1)=10^(outs(0,1))
outs(1,*) = norm_axis([.55,.75]) & outs(1,1)=10^(outs(1,1))
outs(2,*) = norm_axis([.55,.65]) & outs(2,1)=10^(outs(2,1))
outs(3,*) = norm_axis([.55,.55]) & outs(3,1)=10^(outs(3,1))
outs(4,*) = norm_axis([.55,.45]) & outs(4,1)=10^(outs(4,1))

slp_sig_avg = (slope_sigma_68left+slope_sigma_68right)/2.
xyouts,outs(0,0),outs(0,1),font+'!7a!x!s!9`!x!r!dfit!n = '+string(slope,'(f5.2)')+' !9+!x '+string(slp_sig_avg,'(f4.2)'),charsize=outsize, color=black

xyouts,outs(1,0),outs(1,1),font+'!7v!x!s!u2!n!r!d!7m!x,fit!n = '+string(rchisq,'(f5.2)'), charsize=outsize, color=black

xyouts,outs(2,0),outs(2,1),font+'!7a!x!s!9`!x!r!dtheory!n = '+string(slope_theory,'(f5.2)')+' !9+!x '+string(slope_theory_sigma,'(f4.2)'),charsize=outsize, color=black

xyouts,outs(3,0),outs(3,1),font+' ', color=black, charsize=outsize


;------------------------
; MEASUREMENTS INDICES
;------------------------

if (n_elements(orig_wmi) le 16) then begin
    outs(5,*) = norm_axis([.1,.9]) & outs(5,1)=10^(outs(5,1))
    outs(6,*) = norm_axis([.2,.85]) & outs(6,1)=10^(outs(6,1))
    outs(7,*) = norm_axis([.2,.8]) & outs(7,1)=10^(outs(7,1))
    outs(8,*) = norm_axis([.2,.75]) & outs(8,1)=10^(outs(8,1))
    outs(9,*) = norm_axis([.2,.7]) & outs(9,1)=10^(outs(9,1))
    outs(10,*) = norm_axis([.2,.65]) & outs(10,1)=10^(outs(10,1))
    outs(11,*) = norm_axis([.2,.60]) & outs(11,1)=10^(outs(11,1))
    outs(12,*) = norm_axis([.2,.55]) & outs(12,1)=10^(outs(12,1))
    outs(13,*) = norm_axis([.2,.50]) & outs(13,1)=10^(outs(13,1))
    outs(14,*) = norm_axis([.2,.45]) & outs(14,1)=10^(outs(14,1))
    outs(15,*) = norm_axis([.2,.40]) & outs(15,1)=10^(outs(15,1))
    outs(16,*) = norm_axis([.2,.35]) & outs(16,1)=10^(outs(16,1))
    outs(17,*) = norm_axis([.2,.30]) & outs(17,1)=10^(outs(17,1))
    outs(18,*) = norm_axis([.2,.25]) & outs(18,1)=10^(outs(18,1))
    outs(19,*) = norm_axis([.2,.20]) & outs(19,1)=10^(outs(19,1))
    outs(20,*) = norm_axis([.2,.15]) & outs(20,1)=10^(outs(20,1))
    outs(21,*) = norm_axis([.2,.10]) & outs(21,1)=10^(outs(21,1))
    
    xyouts,outs(5,0),outs(5,1),font+'Measurement indices: ',charsize=outsize,color=black
    FOR iii=0,n_elements(orig_wmi)-1 DO BEGIN
        check = where(wmi EQ orig_wmi(iii))
        strout = string(orig_wmi(iii),'(i4.4)')
        IF (check(0) NE -1) THEN strout = strout + font+' !9C'+font
        if (orig_wmi(iii) eq ref_index) then xyouts,outs(5,0),outs(6+iii,1),'!96!x',charsize=outsize, color=black
        xyouts,outs(6+iii,0),outs(6+iii,1),strout,charsize=outsize, color=black
    ENDFOR

endif

oplot, !x.crange, [1,1], line=3, color=black

; Walen picture ---------------------------------------------------

if (wfit.species eq -1) then begin
    ybig = max( [abs(y-sigy),abs(y+sigy)] )
    xbig = max( [abs(x-sigx),abs(x+sigx)] )
    biggest = max([xbig,ybig])
    xrange = [-biggest,biggest]
    drange_ele = xrange
endif else begin
    xrange=drange_ele
endelse
yrange=xrange

if (wfit.species eq -1) then ytitle = font+'[U!de!n]!d!18j!x!n (km/s) from Hydra' else ytitle = font+'[U!di!n]!d!18j!x!n (km/s) from Hydra'
plot, x, y, psym=3, xrange=xrange, yrange=yrange, xstyle=1, ystyle=1,$
  xtitle=font+'[B/!7q!x]!d!18j!x!n (normalized) from MFE and Hydra', $
  ytitle=ytitle,charsize=pltsize,xmargin=[10,6],ymargin=[4,4], color=black,xticks=0

xfit2 = findgen(10)*(xrange(1)+100-(xrange(0)-100))/9. + xrange(0)-100
yfit2 = slope*xfit2 + intercept

polycol = get_color_index(193,193,193)
; Slope=1
polyfill,[0,xfit2(9),xfit2(9)],[0,(slope_theory+slope_theory_sigma)*xfit2(9),(slope_theory-slope_theory_sigma)*xfit2(9)],/data,color=polycol,noclip=0
polyfill,[0,xfit2(0),xfit2(0)],[0,(slope_theory+slope_theory_sigma)*xfit2(0),(slope_theory-slope_theory_sigma)*xfit2(0)],/data,color=polycol,noclip=0

; Slope=-1
polyfill,[0,xfit2(9),xfit2(9)],[0,-(slope_theory+slope_theory_sigma)*xfit2(9),-(slope_theory-slope_theory_sigma)*xfit2(9)],/data,color=polycol,noclip=0
polyfill,[0,xfit2(0),xfit2(0)],[0,-(slope_theory+slope_theory_sigma)*xfit2(0),-(slope_theory-slope_theory_sigma)*xfit2(0)],/data,color=polycol,noclip=0

oplot, xfit2, yfit2, line=3,color=black
oplot, xfit2, (slope-slope_sigma_68left)*xfit2 + intercept,line=2,color=black
oplot, xfit2, (slope+slope_sigma_68right)*xfit2 + intercept,line=2,color=black

;-----------------------
; COMPONENT LABELS
;-----------------------
outs(0,*) = norm_axis([.5,.9])
outs(1,*) = norm_axis([.5,.85])
outs(2,*) = norm_axis([.5,.80])

xlen = xrange(1)-xrange(0)

usersym, xsymvec(0,*),ysymvec(0,*), /fill
oplot, [outs(0,0)-.05*xlen,outs(0,0)-.05*xlen],[outs(0,1),outs(0,1)],psym=8,symsize=symsize,color=black
xyouts,outs(0,0),outs(0,1),font+'!bX-COMP!n',charsize=outsize,color=black

usersym, xsymvec(1,*),ysymvec(1,*), /fill
oplot, [outs(1,0)-.05*xlen,outs(1,0)-.05*xlen],[outs(1,1),outs(1,1)],psym=8,symsize=symsize,color=black
xyouts,outs(1,0),outs(1,1),font+'!bY-COMP!n',charsize=outsize,color=black

usersym, xsymvec(2,*),ysymvec(2,*), /fill
oplot, [outs(2,0)-.05*xlen,outs(2,0)-.05*xlen],[outs(2,1),outs(2,1)],psym=8,symsize=symsize,color=black
xyouts,outs(2,0),outs(2,1),font+'!bZ-COMP!n',charsize=outsize,color=black

rr = where(strmid(labelstr,0,1) EQ 'X')
bb = where(strmid(labelstr,0,1) EQ 'Y')
gg = where(strmid(labelstr,0,1) EQ 'Z')

usersym, xsymvec(0,*),ysymvec(0,*), /fill
oplot, x(rr),y(rr),psym=8,symsize=symsize,color=black
usersym, xsymvec(1,*),ysymvec(1,*), /fill
oplot, x(bb),y(bb),psym=8,symsize=symsize,color=black
usersym, xsymvec(2,*),ysymvec(2,*), /fill
oplot, x(gg),y(gg),psym=8,symsize=symsize,color=black

FOR i=0,n_elements(x)-1 DO BEGIN
    oplot, [x(i),x(i)],[y(i)-sigy(i),y(i)+sigy(i)],line=0,color=black
    oplot, [x(i)-sigx(i),x(i)+sigx(i)],[y(i),y(i)],line=0,color=black
ENDFOR

time_stamp, label='  Created in PaPCo', color=black

return
end
