pro r_hydra_fv, species

   if n_elements(species) eq 0 then return

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg

   common rp_hydra_fv_common, fv_out_header, fv_ele, fv_ion

   forward_function convert_date_to_t90
   
   my_name= 'r_hydra_fv'
   
;  start assuming there is an error.  
   get_err_no=1
   get_err_msg= my_name +': unidentified error encountered.'

   hydra_fv_rw_list, /read, species, fv_header, fv_data, fv_input_global
   rload= where( fv_data(*).time ge xut1 and $
                 fv_data(*).time le xut2, count )
   if count eq 0 then begin
       fv_spec= { start_time:-1., delta_time:0. }
   endif else begin              
       fv_spec1= { data:dblarr( fv_header.m,fv_header.n ), $
                   x:dblarr(fv_header.n), $
                   y:dblarr(fv_header.m), $
                   speed_low_meas:double(0), $
                   start_time:double(0), $
                   delta_time:double(0), $
                   warning:0, $
                   valid_vparl0:fltarr(20), $
                   valid_vperp0:fltarr(20), $
                   valid_vparl180:fltarr(20), $
                   valid_vperp180:fltarr(20) $
                 }
       fv_spec= replicate( fv_spec1, count )
   endelse
       
   for i=0,count-1 do begin
       message, 'Reading fV ('+strtrim(i+1,2)+'/'+strtrim(count,2)+')...', $
         /cont
       idx= rload(i)
       timestr= convert_secondstotime( fv_data(idx).time, /t90, country=1 )
       if strlen(timestr) eq 19 then begin ; papco 9 sends YYYY, before YY
           yyyymmdd= long( strmid( timestr,6,4 ) +  $
                         strmid( timestr,0,2 ) +  $
                         strmid( timestr,3,2 ) )      
           hhmmss= strmid( timestr, 11, 8 )
       endif else begin
           yyyymmdd= 19000000 + long( strmid( timestr,6,2 ) +  $
                                      strmid( timestr,0,2 ) +  $
                                      strmid( timestr,3,2 ) )      
           hhmmss= strmid( timestr, 9, 8 )
       endelse
           
       fv_input= fv_data(idx).fv_input

       fv_input.mode.ncell=51 ; must be same as in hydra_fv_rw_list

       if fv_input.mode.last_block eq -1 then begin
           fv_input.mode.path= yyyymmdd
           fv_input.mode.t0= hhmmss
       endif
       
       catch, error_status
       if error_status eq 0 then begin
           fpitch_plot, fv_input, 0, 0, fv_output, /output, /noplot
       endif else begin
           message, 'Error encountered in fv_plot', /cont
           if n_elements(fv_output) gt 0 then fv_output.z(*)=-99
       endelse
       catch, /cancel

       if n_elements( fv_output ) gt 0 then begin
           t90_midn= long( fv_data(idx).time / 86400 ) * 86400
           fv_spec(i).start_time= t90_midn + fv_output.start_time
           fv_spec(i).delta_time= fv_output.del_t
           fv_spec(i).data= fv_output.z
           fv_spec(i).x= fv_output.x
           fv_spec(i).y= fv_output.y
           fv_spec(i).speed_low_meas= fv_output.speed_low_meas
           fv_spec(i).warning= fix(strmid(fv_output.warning,1,2))
           fv_spec(i).valid_vparl0=congrid(fv_output.valid_vparl0,20)
           fv_spec(i).valid_vperp0=congrid(fv_output.valid_vperp0,20)
           fv_spec(i).valid_vparl180=congrid(fv_output.valid_vparl180,20)
           fv_spec(i).valid_vperp180=congrid(fv_output.valid_vperp180,20)
           fv_data(idx).reload= 0           
       endif 
   endfor

;  clean up data list if redundant outputs were found.
   if n_elements( fv_spec ) gt 1 then begin
       dtmax= max( fv_spec(*).delta_time )
       r= where( fv_spec(*).start_time gt 0.0 )
       if r(0) ne -1 then base= fv_spec(r(0)).start_time else base=0.0
       id= long( 10 * $
                 ( ( fv_spec(*).start_time-base) * ( dtmax+1 ) + $
                   fv_spec(*).delta_time ) > (-1.0) ) ; zeros -> -1.0
       s= sort( id )
       u= uniq( id, s )
       
       fv_spec= fv_spec(u)
   endif
   
   if species eq 0 then begin
       fv_ele= fv_spec
   endif else begin
       fv_ion= fv_spec
   endelse

   get_err_no=0

   return
end
   
