pro r_hydra_kp_extra

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_kp_extra_data, kp_extra_header, kp_extra_data

     my_name='r_hydra_kp_extra'
     module_name='HYDRA-kp-extra'

     forward_function convert_date_to_t90
     
     get_err_no=0
     get_err_msg= my_name +': data-file read succesfully'

; read data files for time period
   num_files_read=0
   time=xut1
   while time-1 lt xut2 do begin
      day_start= time / 86400 * 86400
      start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
      end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
      end_time= end_time - day_start 
      convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k  
      if year lt 100 then year=year+1900
      date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")       
      
      if start_time ne end_time then begin
         r_hydra_kp_extra_oneday, date_str, start_time, end_time, $
          kp_extra_header, data_values
         
         if get_err_no eq 0 then BEGIN
            num_files_read =  num_files_read + 1
            data_values(*).time_ion= $
             data_values(*).time_ion + ( day_start - xut1 )
            if (num_files_read eq 1) then begin
               data_buf= [ data_values ]
            endif else begin
               data_buf= [ data_buf, data_values ]
            endelse
         endif       
      ENDIF

      time=day_start+86400           ; prepare to read next day

   endwhile
   
   if (n_elements(data_buf) gt 0) then begin
       kp_extra_data= data_buf
       get_err_no=0             ; all's well
   endif else begin
       get_err_no=2
       print,get_err_msg
       return
   endelse

   print,'Read '+module_name+': done'

   return
end


pro r_hydra_kp_extra_oneday, date_str, start_time, end_time, $
                            data_header, data_values

  common  get_error, get_err_no, get_err_msg

  myname= 'r_hydra_kp_extra_oneday'

  f= hydra_findfile( date_str, /kp_extra )
  if (f ne '') then begin
      print, myname+': opening '+f+'...'
      CDF= cdf_open(f)
      n= strlen(f)
      data_header.data_version= float( strmid( f, n-8, 4 ))
  endif else begin
      return
  endelse

  cdf_control, cdf, variable='time', get_var_info=r
  IF (r.maxrec EQ -1) THEN BEGIN
     get_err_msg= myname+': CDF contains no records '
     get_err_no = 1
     print, get_err_msg
     return
  ENDIF

  cdf_varget, cdf, 'time', alltimes, rec_count=r.maxrec+1
  rng = where(alltimes GE start_time AND alltimes LE end_time)
  IF ((rng(0) EQ -1) OR (n_elements(rng) LE 1)) THEN BEGIN 
     get_err_msg= myname+': No data found in this time range '
     get_err_no = 1
     print, get_err_msg
     return
  ENDIF ELSE BEGIN
     rec_start_ion = rng(0)
     rec_count_ion = n_elements(rng)
  ENDELSE

; Determine rstudy_den_stats size
  cdf_varget, cdf, 'rstudy_den_stats', rstudy_den_stats_dummy, $
    rec_start=0, rec_count=1
  rstudy_size = n_elements(reform(rstudy_den_stats_dummy))

  print, myname+': rstudy_size = ', rstudy_size
  
  data_values1_6= { hydra_kp_extra_data_6, $
                    time_ion:float(0), $
                    mean_energy_ion:0.0, $
                    density_ion:0.0, $
                    fit_stat_ion:0,$
                    bhat_block_avg:fltarr(3),$
                    var_bhat_diag:0.0,$
                    lshell:0.0,$
                    radius:0.0,$
                    max_cc:fltarr(2),$
                    min_energy:0.0,$
                    max_energy:0.0,$
                    angle_b:0.0,$
                    u_pay:fltarr(4),$
                    u_gsm:fltarr(4),$
                    ktparl:0.0,$
                    ktperp:0.0,$
                    gyrotropy:0.0,$
                    rchi2_patch:0.0,$
                    rchi2_all:0.0,$
                    npatch:0,$
                    nrealizations:0,$
                    rstudy_den_stats:fltarr(6),$
                    rstudy_u_stats:fltarr(3,6),$
                    rstudy_tparl_stats:fltarr(6),$
                    rstudy_tperp_stats:fltarr(6),$
                    rstudy_gyrotropy_stats:fltarr(6), $
                    pres_parl:0.0,$
                    pres_perp:0.0,$
                    u_parl:0.0,$
                    u_perp:fltarr(4),$
                    v_alf:0.0 $
                  }
  
  data_values1_7= { hydra_kp_extra_data_7, $
                    time_ion:float(0), $
                    mean_energy_ion:0.0, $
                    density_ion:0.0, $
                    fit_stat_ion:0,$
                    bhat_block_avg:fltarr(3),$
                    var_bhat_diag:0.0,$
                    lshell:0.0,$
                    radius:0.0,$
                    max_cc:fltarr(2),$
                    min_energy:0.0,$
                    max_energy:0.0,$
                    angle_b:0.0,$
                    u_pay:fltarr(4),$
                    u_gsm:fltarr(4),$
                    ktparl:0.0,$
                    ktperp:0.0,$
                    gyrotropy:0.0,$
                    rchi2_patch:0.0,$
                    rchi2_all:0.0,$
                    npatch:0,$
                    nrealizations:0,$
                    rstudy_den_stats:fltarr(7),$
                    rstudy_u_stats:fltarr(3,7),$
                    rstudy_tparl_stats:fltarr(7),$
                    rstudy_tperp_stats:fltarr(7),$
                    rstudy_gyrotropy_stats:fltarr(7), $
                    pres_parl:0.0,$
                    pres_perp:0.0,$
                    u_parl:0.0,$
                    u_perp:fltarr(4),$
                    v_alf:0.0 $
                  }   
  
  IF (rstudy_size EQ 6) THEN data_values = replicate( data_values1_6, rec_count_ion ) $
  ELSE data_values = replicate( data_values1_7, rec_count_ion )

  cdf_varget, cdf, 'time', time_ion, $
   rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'h_tparl', ktparl, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'h_tperp', ktperp, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  mean_energy_ion =  1./3.*(ktparl + 2.*ktperp)

  cdf_varget, cdf, 'h_den', h_den, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  h_pres_parl = fltarr(n_elements(h_den))
  h_pres_perp = fltarr(n_elements(h_den))
  gd = where(h_den NE -1.e+31)
  
  IF (rstudy_size EQ 6) THEN BEGIN
     IF (gd(0) NE -1) THEN h_den(gd) = h_den(gd)*1.e-15 ; km-3 to cm-3
  ENDIF 

  h_pres_parl(gd) = h_den(gd)*ktparl*1.6e-12 ;cgs
  h_pres_perp(gd) = h_den(gd)*ktperp*1.6e-12 ;cgs

  cdf_varget, cdf, 'h_iretu', h_iretu, $
    rec_start=rec_start_ion, rec_count=rec_count_ion
  
  cdf_varget, cdf, 'bhat_block_avg', bhat_block_avg, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'bmag', bmag, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'var_bhat_block_avg', var_bhat_block_avg, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  var_bhat_diag =  sqrt(var_bhat_block_avg(0,*)+var_bhat_block_avg(1,*)+var_bhat_block_avg(2,*))

  cdf_varget, cdf, 'lshell', lshell, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'radius', radius, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'max_caverage', max_cc, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'min_energy', min_energy, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'max_energy', max_energy, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'angle_b', angle_b, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'h_u', h_u, $
   rec_start=rec_start_ion, rec_count=rec_count_ion ;h_u is in km/s

; Convert the flow speed from fixed payload to gsm----------
  time =  reform(time_ion)
  hydra_payload_to_gsm, date_str,time,h_u,h_u_gsm,istat,rate=1
  IF (istat EQ 0) THEN BEGIN
     print, myname+': GSM ROTATION NOT SUCCESSFUL!'
     h_u_gsm = fltarr(4,n_elements(time))
  ENDIF

  u_parl = h_u(0,*)*bhat_block_avg(0,*) + h_u(1,*)*bhat_block_avg(1,*) + h_u(2,*)*bhat_block_avg(2,*) ;km/s

  u_perp =  fltarr(4,n_elements(time))
  u_perp(0,*) =  h_u(0,*) - u_parl*bhat_block_avg(0,*) ;km/s
  u_perp(1,*) =  h_u(1,*) - u_parl*bhat_block_avg(1,*) ;km/s
  u_perp(2,*) =  h_u(2,*) - u_parl*bhat_block_avg(2,*) ;km/s
  u_perp(3,*) =  sqrt(u_perp(0,*)^2 + u_perp(1,*)^2 + u_perp(2,*)^2)

  cdf_varget, cdf, 'h_gyrotropy', h_gyrotropy, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'h_rchi2', h_rchi2, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rchi2_all', rchi2_all, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'npatch', npatch, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'nrealizations', nrealizations, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_den_stats', rstudy_den_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  IF (rstudy_size EQ 6) THEN BEGIN
     gd = where(rstudy_den_stats(2,*) NE -1.e+31)
     IF (gd(0) NE -1) THEN BEGIN 
        rstudy_den_stats(0,gd) = rstudy_den_stats(0,gd)*(1.e-15)^2 ; (km-3 to cm-3)^2
        rstudy_den_stats(1,gd) = rstudy_den_stats(1,gd)*(1.e-15) ; km-3 to cm-3
        rstudy_den_stats(2,gd) = rstudy_den_stats(2,gd)*(1.e-15) ; km-3 to cm-3
        rstudy_den_stats(3,gd) = rstudy_den_stats(3,gd)*(1.e-15) ; km-3 to cm-3
        rstudy_den_stats(4,gd) = rstudy_den_stats(4,gd)*(1.e-15) ; km-3 to cm-3
        rstudy_den_stats(5,gd) = rstudy_den_stats(5,gd)*(1.e-15) ; km-3 to cm-3
     ENDIF
  ENDIF 

  cdf_varget, cdf, 'rstudy_u_stats', rstudy_u_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_tparl_stats', rstudy_tparl_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_tperp_stats', rstudy_tperp_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_varget, cdf, 'rstudy_gyrotropy_stats', rstudy_gyrotropy_stats, $
    rec_start=rec_start_ion, rec_count=rec_count_ion

  cdf_close, cdf

; Alfven speed
  v_alf = fltarr(n_elements(time_ion))
  pos = where(h_den GT 0)
  mass = 1.67e-24               ; cgs, hydrogen
  bgauss = bmag(pos)*1.e-9*1.e+4     ; cgs
  rho = h_den(pos)*mass              ; cgs
  v_alf(pos) = bgauss/sqrt(4.*(!pi)*rho) ; cgs
  v_alf(pos) = v_alf(pos)*1.e-5           ; km/s

  rion= lindgen(rec_count_ion)
  data_values(rion).v_alf = reform(v_alf)
  data_values(rion).time_ion= reform(time_ion)  
  data_values(rion).mean_energy_ion= reform(mean_energy_ion)
  data_values(rion).density_ion= reform(h_den)
  data_values(rion).pres_parl = reform(h_pres_parl)
  data_values(rion).pres_perp = reform(h_pres_perp)
  data_values(rion).u_parl = reform(u_parl)
  data_values(rion).fit_stat_ion= reform(h_iretu)
  data_values(rion).var_bhat_diag= reform(var_bhat_diag)
  data_values(rion).lshell= reform(lshell)
  data_values(rion).radius= reform(radius)
  data_values(rion).min_energy= reform(min_energy)
  data_values(rion).max_energy= reform(max_energy)
  data_values(rion).angle_b= reform(angle_b)
  data_values(rion).ktparl= reform(ktparl)
  data_values(rion).ktperp= reform(ktperp)
  data_values(rion).gyrotropy= reform(h_gyrotropy)
  data_values(rion).rchi2_patch= reform(h_rchi2)
  data_values(rion).rchi2_all= reform(rchi2_all)
  data_values(rion).npatch= reform(npatch)
  data_values(rion).nrealizations= reform(nrealizations)

; Arrays of more than one dimension
  data_values(rion).u_perp = u_perp
  data_values(rion).rstudy_den_stats = rstudy_den_stats
  data_values(rion).rstudy_u_stats= rstudy_u_stats
  data_values(rion).rstudy_tparl_stats= rstudy_tparl_stats
  data_values(rion).rstudy_tperp_stats= rstudy_tperp_stats
  data_values(rion).rstudy_gyrotropy_stats= rstudy_gyrotropy_stats
  data_values(rion).bhat_block_avg= bhat_block_avg
  data_values(rion).max_cc= max_cc
  data_values(rion).u_pay(0)= reform(h_u(0,*))
  data_values(rion).u_pay(1)= reform(h_u(1,*))
  data_values(rion).u_pay(2)= reform(h_u(2,*))
  data_values(rion).u_pay(3) = reform(sqrt(h_u(0,*)^2+h_u(1,*)^2+h_u(2,*)^2))
  
  data_values(rion).u_gsm(0)= reform(h_u_gsm(0,*))
  data_values(rion).u_gsm(1)= reform(h_u_gsm(1,*))
  data_values(rion).u_gsm(2)= reform(h_u_gsm(2,*))
  data_values(rion).u_gsm(3) = reform(h_u_gsm(3,*))
  
  return
END

