pro r_hydra_kptest

   common time,xut1,xut2
   common get_error, get_err_no, get_err_msg
   common hydra_kptest_data, $
    kptest_species, $
    kptest_header, $
    kptest_lr_ele_data, $
    kptest_lr_ele_attr, $
    kptest_lr_ion_data, $
    kptest_lr_ion_attr, $
    kptest_hr_ele_data, $
    kptest_hr_ele_attr

     my_name='r_hydra_kptest'
     module_name='HYDRA-kptest'

     forward_function convert_date_to_t90
     
     get_err_no=0
     get_err_msg= my_name +': data-file read succesfully'

; read data files for time period
   num_files_read = 0
   time=xut1
   while time-1 lt xut2 do begin
       day_start= time / 86400 * 86400
       start_time= time - day_start
;          end_time is xut2 or midnight, whichever is sooner...
       end_time= min( [ ( (time+1)/86400 +1) * 86400, xut2 ] ) 
       end_time= end_time - day_start 
       convert_t90_to_date,time, year,doy,h,m,s,month,cm,day_om ; y2k
       if year lt 100 then year=year+1900
       date_str=string(year,month,day_om,format="(i4.4,i2.2,i2.2)")       

       if start_time ne end_time then begin
           r_hydra_kptest_oneday, date_str, start_time, end_time, data_values, data_attr
           
           if get_err_no eq 0 then BEGIN
              num_files_read = num_files_read + 1
              data_values(*).time= $
               data_values(*).time + ( day_start - xut1 )
              IF (num_files_read EQ 1) THEN BEGIN
                 data_buf = [data_values]
              ENDIF ELSE BEGIN
                 data_buf = [data_buf,data_values]
              ENDELSE

           endif       
       ENDIF

       time=time+86400          ; prepare to read next day
   endwhile
   
   if (n_elements(data_buf) gt 0) then BEGIN
      IF (kptest_species EQ 0) THEN BEGIN
         kptest_lr_ele_data = data_buf
         kptest_lr_ele_attr = data_attr
      ENDIF ELSE IF kptest_species EQ 1 THEN BEGIN
         kptest_lr_ion_data = data_buf
         kptest_lr_ion_attr = data_attr
      ENDIF ELSE BEGIN
         kptest_hr_ele_data = data_buf
         kptest_hr_ele_attr = data_attr
      ENDELSE

       get_err_no=0             ; all's well
   endif else begin
       get_err_no=2
       print,get_err_msg
       return
   endelse

   print,'Read '+module_name+': done'

   return
end


pro r_hydra_kptest_oneday, date_str, start_time, end_time, data_values, data_attr

   common  get_error, get_err_no, get_err_msg
   common hydra_kptest_data, $
    kptest_species, $
    kptest_header, $
    kptest_lr_ele_data, $
    kptest_lr_ele_attr, $
    kptest_lr_ion_data, $
    kptest_lr_ion_attr, $
    kptest_hr_ele_data, $
    kptest_hr_ele_attr   

   myname= 'r_hydra_kptest_oneday'
   
   IF (kptest_species EQ 0) THEN BEGIN ;--------low res electrons------------
      
      f= hydra_findfile( date_str, /kptest )
      
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf = cdf_open(f)
         n= strlen(f)
         kptest_header(kptest_species).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return
      ENDELSE

      cdf_control, cdf, variable='LRKP_TIME', get_var_info=r
      cdf_varget, cdf, 'LRKP_TIME', time, rec_count=r.maxrec+1
      rec_start = ( where( time ge start_time ) )(0)
      if rec_start(0) eq -1 then begin
         get_err_msg= myname+': No data found after start_time '
         print, get_err_msg
         get_err_num = 1
         return
      ENDIF
      
      rec_count = r.maxrec+1 - rec_start
      
      data_values1= { hydra_kptest_dum_data, $
                      time:0.0, $
                      mean_energy:0.0, $
                      density:0.0, $
                      status:0 $
                    }   
      
      cdf_varget, cdf, 'LRKP_TIME', t, $
       rec_start=rec_start, rec_count=rec_count
      cdf_varget, cdf, 'LRKP_DENSITY_ELE',den, $
       rec_start=rec_start, rec_count=rec_count
      cdf_varget, cdf, 'LRKP_MEAN_ENERGY_ELE', me, $
       rec_start=rec_start, rec_count=rec_count
      cdf_varget, cdf, 'LRKP_IRETU_ELE', ir, $
       rec_start=rec_start, rec_count=rec_count

      cdf_close,cdf

      ffill =  -1.e+31
      good = where(den NE ffill AND me NE ffill)
      IF (good(0) NE -1) THEN BEGIN 
         time = t(good)
         density = den(good)
         mean_energy = me(good)
         iretu = ir(good)
      ENDIF ELSE BEGIN
         get_err_msg= myname+': No data found between start and end times '
         get_err_no= 1
         print, get_err_msg           
         return
      ENDELSE

      data_values = replicate( data_values1, n_elements(time))

      r= lindgen(n_elements(time))

; One-dimensional data arrays
      data_values(r).time = reform(time)  
      data_values(r).mean_energy= reform(mean_energy)
      data_values(r).density = reform(density)
      data_values(r).status = reform(iretu)

      data_attr = 13.8

   ENDIF ELSE IF (kptest_species EQ 1) THEN BEGIN ;--------low res ions-------

      f= hydra_findfile( date_str, /kptest )
      
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf = cdf_open(f)
         n= strlen(f)
         kptest_header(kptest_species).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return
      ENDELSE

      cdf_control, cdf, variable='LRKP_TIME', get_var_info=r
      cdf_varget, cdf, 'LRKP_TIME', time, rec_count=r.maxrec+1
      rec_start = ( where( time ge start_time ) )(0)
      if rec_start(0) eq -1 then begin
         get_err_msg= myname+': No data found after start_time '
         print, get_err_msg
         get_err_num = 1
         return
      ENDIF
      
      rec_count = r.maxrec+1 - rec_start
      
      data_values1= { hydra_kptest_dum_data, $
                      time:0.0, $
                      mean_energy:0.0, $
                      density:0.0, $
                      status:0 $
                    }   
      
      cdf_varget, cdf, 'LRKP_TIME', t, $
       rec_start=rec_start, rec_count=rec_count
      cdf_varget, cdf, 'LRKP_DENSITY_ION',den, $
       rec_start=rec_start, rec_count=rec_count
      cdf_varget, cdf, 'LRKP_MEAN_ENERGY_ION', me, $
       rec_start=rec_start, rec_count=rec_count

      cdf_close,cdf

      ffill =  -1.e+31
      good = where(den NE ffill AND me NE ffill)
      IF (good(0) NE -1) THEN BEGIN 
         time = t(good)
         density = den(good)
         mean_energy = me(good)
      ENDIF ELSE BEGIN
         get_err_msg= myname+': No data found between start and end times '
         get_err_no= 1
         print, get_err_msg           
         return
      ENDELSE

      data_values = replicate( data_values1, n_elements(time))

      r= lindgen(n_elements(time))

; One-dimensional data arrays
      data_values(r).time = reform(time)  
      data_values(r).mean_energy= reform(mean_energy)
      data_values(r).density = reform(density)

      data_attr = 13.8      
      
   ENDIF ELSE BEGIN ;------------high res electrons-----------------

      f= hydra_findfile( date_str, /kptest )
      if (f NE '') then begin
         print, myname+': opening '+f+'...'
         cdf = cdf_open(f)
         n= strlen(f)
         kptest_header(kptest_species).data_version= float( strmid( f, n-8, 4 ))
      endif else begin
         return
      ENDELSE

      cdf_control, cdf, variable='HRKP_TIME_ELE', get_var_info=r
      cdf_varget, cdf, 'HRKP_TIME_ELE', time, rec_count=r.maxrec+1
      rec_start= ( where( time ge start_time ) )(0)
      if rec_start eq -1 then begin
         get_err_msg= myname+': No data found after start_time, resetting'
         print, get_err_msg
         rec_start=0
      endif
      rec_count= n_elements( where( time(rec_start:*) lt end_time $
                                    and time(rec_start:*) $
                                    gt start_time, $
                                    count ))
      
      if ( count ) eq 0 then begin
         get_err_msg= myname+': No data found within selected interval '
         get_err_no= 1
         print, get_err_msg           
         return
      endif      
      
      data_values1= { hydra_kptest_dum_data, $
                      time:0.0, $
                      mean_energy:0.0, $
                      density:0.0, $
                      status:0 $
                    }   
      
      cdf_varget, cdf, 'HRKP_TIME_ELE',time, $
       rec_start=rec_start, rec_count=rec_count

      cdf_varget, cdf, 'HRKP_DENSITY_ELE',density, $
       rec_start=rec_start, rec_count=rec_count
      
      cdf_varget, cdf, 'HRKP_MEAN_ENERGY_ELE', mean_energy, $
       rec_start=rec_start, rec_count=rec_count
      
      cdf_varget, cdf, 'HRKP_DQF_ELE',status, $
       rec_start=rec_start, rec_count=rec_count


      cdf_close,cdf
      
      time = reform(time)
      density = reform(density)
      mean_energy = reform(mean_energy)
      status = reform(status)

      good = where(status NE 0)
      rec_count =  n_elements(good)

      data_values  = replicate( data_values1, rec_count )

; One-dimensional data arrays
      data_values.time = time(good)  
      data_values.mean_energy= mean_energy(good)
      data_values.density = density(good)
      data_values.status = status(good)

      data_attr =  13.8/12.

   ENDELSE 

   return
end
